/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.ngrams;

import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TrigramIndex
extends ScalarIndexExtension<Integer> {
    public static final boolean ENABLED = "true".equals(System.getProperty("idea.internal.trigramindex.enabled"));
    public static final ID<Integer, Void> INDEX_ID = ID.create((String)"Trigram.Index");
    private static final FileBasedIndex.InputFilter INPUT_FILTER = new FileBasedIndex.InputFilter(){

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/ngrams/TrigramIndex$1", "acceptInput"));
            }
            return !file.getFileType().isBinary();
        }
    };
    private static final FileBasedIndex.InputFilter NO_FILES = new FileBasedIndex.InputFilter(){

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/ngrams/TrigramIndex$2", "acceptInput"));
            }
            return false;
        }
    };

    @NotNull
    public ID<Integer, Void> getName() {
        ID<Integer, Void> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/ngrams/TrigramIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Integer, Void, FileContent> getIndexer() {
        DataIndexer<Integer, Void, FileContent> dataIndexer = new DataIndexer<Integer, Void, FileContent>(){

            @NotNull
            public Map<Integer, Void> map(FileContent inputData) {
                THashMap result = new THashMap();
                TIntHashSet built = TrigramBuilder.buildTrigram((CharSequence)inputData.getContentAsText());
                built.forEach(new TIntProcedure((Map)result){
                    final /* synthetic */ Map val$result;
                    {
                        this.val$result = map;
                    }

                    public boolean execute(int value) {
                        this.val$result.put(value, null);
                        return true;
                    }
                });
                THashMap tHashMap = result;
                if (tHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/ngrams/TrigramIndex$3", "map"));
                }
                return tHashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/ngrams/TrigramIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/ngrams/TrigramIndex", "getKeyDescriptor"));
        }
        return enumeratorIntegerDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        if (ENABLED) {
            FileBasedIndex.InputFilter inputFilter = INPUT_FILTER;
            if (inputFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/ngrams/TrigramIndex", "getInputFilter"));
            }
            return inputFilter;
        }
        FileBasedIndex.InputFilter inputFilter = NO_FILES;
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/ngrams/TrigramIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return ENABLED ? 2 : 1;
    }
}

