/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="FindSettings", storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class FindSettingsImpl
extends FindSettings
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.impl.FindSettingsImpl");
    @NonNls
    private static final String FIND_DIRECTION_FORWARD = "forward";
    @NonNls
    private static final String FIND_DIRECTION_BACKWARD = "backward";
    @NonNls
    private static final String FIND_ORIGIN_FROM_CURSOR = "from_cursor";
    @NonNls
    private static final String FIND_ORIGIN_ENTIRE_SCOPE = "entire_scope";
    @NonNls
    private static final String FIND_SCOPE_GLOBAL = "global";
    @NonNls
    private static final String FIND_SCOPE_SELECTED = "selected";
    private static final String DEFAULT_SEARCH_SCOPE = FindBundle.message("find.scope.all.project.classes", new Object[0]);
    private static final int MAX_RECENT_SIZE = 30;
    public boolean SEARCH_OVERLOADED_METHODS = false;
    public boolean SEARCH_IN_LIBRARIES = false;
    public boolean SKIP_RESULTS_WHEN_ONE_USAGE = false;
    public String FIND_DIRECTION = "forward";
    public String FIND_ORIGIN = "from_cursor";
    public String FIND_SCOPE = "global";
    public String FIND_CUSTOM_SCOPE = null;
    public boolean CASE_SENSITIVE_SEARCH = false;
    public boolean LOCAL_CASE_SENSITIVE_SEARCH = false;
    public boolean PRESERVE_CASE_REPLACE = false;
    public boolean WHOLE_WORDS_ONLY = false;
    public boolean COMMENTS_ONLY = false;
    public boolean STRING_LITERALS_ONLY = false;
    public boolean LOCAL_WHOLE_WORDS_ONLY = false;
    public boolean REGULAR_EXPRESSIONS = false;
    public boolean LOCAL_REGULAR_EXPRESSIONS = false;
    public boolean WITH_SUBDIRECTORIES = true;
    public String SEARCH_SCOPE = DEFAULT_SEARCH_SCOPE;
    public String FILE_MASK;
    public JDOMExternalizableStringList RECENT_FIND_STRINGS = new JDOMExternalizableStringList();
    public JDOMExternalizableStringList RECENT_REPLACE_STRINGS = new JDOMExternalizableStringList();
    public JDOMExternalizableStringList RECENT_DIR_STRINGS = new JDOMExternalizableStringList();
    @NonNls
    public JDOMExternalizableStringList RECENT_FILE_MASKS = new JDOMExternalizableStringList();

    public FindSettingsImpl() {
        this.RECENT_FILE_MASKS.add((Object)"*.properties");
        this.RECENT_FILE_MASKS.add((Object)"*.html");
        this.RECENT_FILE_MASKS.add((Object)"*.jsp");
        this.RECENT_FILE_MASKS.add((Object)"*.xml");
        this.RECENT_FILE_MASKS.add((Object)"*.java");
        this.RECENT_FILE_MASKS.add((Object)"*.js");
        this.RECENT_FILE_MASKS.add((Object)"*.as");
        this.RECENT_FILE_MASKS.add((Object)"*.css");
        this.RECENT_FILE_MASKS.add((Object)"*.mxml");
        if (PlatformUtils.isPyCharm()) {
            this.RECENT_FILE_MASKS.add((Object)"*.py");
        } else if (PlatformUtils.isRubyMine()) {
            this.RECENT_FILE_MASKS.add((Object)"*.rb");
        } else if (PlatformUtils.isPhpStorm()) {
            this.RECENT_FILE_MASKS.add((Object)"*.php");
        }
    }

    @Override
    public boolean isSearchOverloadedMethods() {
        return this.SEARCH_OVERLOADED_METHODS;
    }

    @Override
    public void setSearchOverloadedMethods(boolean search) {
        this.SEARCH_OVERLOADED_METHODS = search;
    }

    public void loadState(Element state) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
        }
        catch (InvalidDataException e) {
            LOG.info((Throwable)e);
        }
    }

    public Element getState() {
        Element element = new Element("state");
        try {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }
        catch (WriteExternalException e) {
            LOG.info((Throwable)e);
        }
        return element;
    }

    @Override
    public boolean isSkipResultsWithOneUsage() {
        return this.SKIP_RESULTS_WHEN_ONE_USAGE;
    }

    @Override
    public void setSkipResultsWithOneUsage(boolean skip) {
        this.SKIP_RESULTS_WHEN_ONE_USAGE = skip;
    }

    @Override
    public String getDefaultScopeName() {
        return this.SEARCH_SCOPE;
    }

    @Override
    public void setDefaultScopeName(String scope) {
        this.SEARCH_SCOPE = scope;
    }

    @Override
    public boolean isForward() {
        return FIND_DIRECTION_FORWARD.equals(this.FIND_DIRECTION);
    }

    @Override
    public void setForward(boolean findDirectionForward) {
        this.FIND_DIRECTION = findDirectionForward ? FIND_DIRECTION_FORWARD : FIND_DIRECTION_BACKWARD;
    }

    @Override
    public boolean isFromCursor() {
        return FIND_ORIGIN_FROM_CURSOR.equals(this.FIND_ORIGIN);
    }

    @Override
    public void setFromCursor(boolean findFromCursor) {
        this.FIND_ORIGIN = findFromCursor ? FIND_ORIGIN_FROM_CURSOR : FIND_ORIGIN_ENTIRE_SCOPE;
    }

    @Override
    public boolean isGlobal() {
        return FIND_SCOPE_GLOBAL.equals(this.FIND_SCOPE);
    }

    @Override
    public void setGlobal(boolean findGlobalScope) {
        this.FIND_SCOPE = findGlobalScope ? FIND_SCOPE_GLOBAL : FIND_SCOPE_SELECTED;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.CASE_SENSITIVE_SEARCH;
    }

    @Override
    public void setCaseSensitive(boolean caseSensitiveSearch) {
        this.CASE_SENSITIVE_SEARCH = caseSensitiveSearch;
    }

    @Override
    public boolean isLocalCaseSensitive() {
        return this.LOCAL_CASE_SENSITIVE_SEARCH;
    }

    @Override
    public boolean isLocalWholeWordsOnly() {
        return this.LOCAL_WHOLE_WORDS_ONLY;
    }

    @Override
    public void setLocalCaseSensitive(boolean caseSensitiveSearch) {
        this.LOCAL_CASE_SENSITIVE_SEARCH = caseSensitiveSearch;
    }

    @Override
    public void setLocalWholeWordsOnly(boolean wholeWordsOnly) {
        this.LOCAL_WHOLE_WORDS_ONLY = wholeWordsOnly;
    }

    @Override
    public boolean isPreserveCase() {
        return this.PRESERVE_CASE_REPLACE;
    }

    @Override
    public void setPreserveCase(boolean preserveCase) {
        this.PRESERVE_CASE_REPLACE = preserveCase;
    }

    @Override
    public boolean isWholeWordsOnly() {
        return this.WHOLE_WORDS_ONLY;
    }

    @Override
    public void setWholeWordsOnly(boolean wholeWordsOnly) {
        this.WHOLE_WORDS_ONLY = wholeWordsOnly;
    }

    @Override
    public boolean isRegularExpressions() {
        return this.REGULAR_EXPRESSIONS;
    }

    @Override
    public void setRegularExpressions(boolean regularExpressions) {
        this.REGULAR_EXPRESSIONS = regularExpressions;
    }

    @Override
    public boolean isLocalRegularExpressions() {
        return this.LOCAL_REGULAR_EXPRESSIONS;
    }

    @Override
    public void setLocalRegularExpressions(boolean regularExpressions) {
        this.LOCAL_REGULAR_EXPRESSIONS = regularExpressions;
    }

    @Override
    public void setWithSubdirectories(boolean b) {
        this.WITH_SUBDIRECTORIES = b;
    }

    private boolean isWithSubdirectories() {
        return this.WITH_SUBDIRECTORIES;
    }

    @Override
    public void initModelBySetings(FindModel model) {
        model.setCaseSensitive(this.isCaseSensitive());
        model.setForward(this.isForward());
        model.setFromCursor(this.isFromCursor());
        model.setGlobal(this.isGlobal());
        model.setRegularExpressions(this.isRegularExpressions());
        model.setWholeWordsOnly(this.isWholeWordsOnly());
        model.setInCommentsOnly(this.isInCommentsOnly());
        model.setInStringLiteralsOnly(this.isInStringLiteralsOnly());
        model.setWithSubdirectories(this.isWithSubdirectories());
        model.setFileFilter(this.FILE_MASK);
        model.setCustomScopeName(this.FIND_SCOPE);
    }

    private static void addStringToList(String str, List<String> list, int maxSize) {
        if (list.contains(str)) {
            list.remove(str);
        }
        list.add(str);
        while (list.size() > maxSize) {
            list.remove(0);
        }
    }

    @Override
    public void addStringToFind(String s) {
        if (s == null || s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return;
        }
        FindSettingsImpl.addStringToList(s, (List<String>)this.RECENT_FIND_STRINGS, 30);
    }

    @Override
    public void addStringToReplace(String s) {
        if (s == null || s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return;
        }
        FindSettingsImpl.addStringToList(s, (List<String>)this.RECENT_REPLACE_STRINGS, 30);
    }

    @Override
    public void addDirectory(String s) {
        if (s == null || s.isEmpty()) {
            return;
        }
        FindSettingsImpl.addStringToList(s, (List<String>)this.RECENT_DIR_STRINGS, 30);
    }

    @Override
    @NotNull
    public String[] getRecentFindStrings() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)this.RECENT_FIND_STRINGS);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindSettingsImpl", "getRecentFindStrings"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getRecentReplaceStrings() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)this.RECENT_REPLACE_STRINGS);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindSettingsImpl", "getRecentReplaceStrings"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getRecentFileMasks() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)this.RECENT_FILE_MASKS);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindSettingsImpl", "getRecentFileMasks"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public List<String> getRecentDirectories() {
        ArrayList<String> arrayList = new ArrayList<String>((Collection<String>)this.RECENT_DIR_STRINGS);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindSettingsImpl", "getRecentDirectories"));
        }
        return arrayList;
    }

    @Override
    public String getFileMask() {
        return this.FILE_MASK;
    }

    @Override
    public void setFileMask(String _fileMask) {
        this.FILE_MASK = _fileMask;
        if (_fileMask != null && !_fileMask.isEmpty()) {
            FindSettingsImpl.addStringToList(_fileMask, (List<String>)this.RECENT_FILE_MASKS, 30);
        }
    }

    @Override
    public String getCustomScope() {
        return this.SEARCH_SCOPE;
    }

    @Override
    public boolean isInStringLiteralsOnly() {
        return this.STRING_LITERALS_ONLY;
    }

    @Override
    public boolean isInCommentsOnly() {
        return this.COMMENTS_ONLY;
    }

    @Override
    public void setInCommentsOnly(boolean selected) {
        this.COMMENTS_ONLY = selected;
    }

    @Override
    public void setInStringLiteralsOnly(boolean selected) {
        this.STRING_LITERALS_ONLY = selected;
    }

    @Override
    public void setCustomScope(String SEARCH_SCOPE) {
        this.SEARCH_SCOPE = SEARCH_SCOPE;
    }
}

