/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageLimitUtil;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FindInProjectTask {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.impl.FindInProjectTask");
    private static final int FILES_SIZE_LIMIT = 0x4600000;
    private static final int SINGLE_FILE_SIZE_LIMIT = 0x500000;
    private final FindModel myFindModel;
    private final Project myProject;
    private final PsiManager myPsiManager;
    @Nullable
    private final PsiDirectory myPsiDirectory;
    private final FileIndex myFileIndex;
    private final Condition<VirtualFile> myFileMask;
    private final ProgressIndicator myProgress;
    @Nullable
    private final Module myModule;
    private final Set<PsiFile> myLargeFiles;
    private boolean myWarningShown;

    FindInProjectTask(@NotNull FindModel findModel, final @NotNull Project project, @Nullable PsiDirectory psiDirectory) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/impl/FindInProjectTask", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/impl/FindInProjectTask", "<init>"));
        }
        this.myLargeFiles = ContainerUtil.newTroveSet();
        this.myFindModel = findModel;
        this.myProject = project;
        this.myPsiDirectory = psiDirectory;
        this.myPsiManager = PsiManager.getInstance((Project)project);
        final String moduleName = findModel.getModuleName();
        this.myModule = moduleName == null ? null : (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

            public Module compute() {
                return ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
            }
        });
        this.myFileIndex = this.myModule == null ? ProjectRootManager.getInstance((Project)project).getFileIndex() : ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
        String filter = findModel.getFileFilter();
        final Pattern pattern = FindInProjectUtil.createFileMaskRegExp(filter);
        this.myFileMask = pattern == null ? Condition.TRUE : new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return file != null && pattern.matcher(file.getName()).matches();
            }
        };
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        this.myProgress = progress != null ? progress : new EmptyProgressIndicator();
    }

    public void findUsages(@NotNull Processor<UsageInfo> consumer, @NotNull FindUsagesProcessPresentation processPresentation) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/impl/FindInProjectTask", "findUsages"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/impl/FindInProjectTask", "findUsages"));
        }
        try {
            this.myProgress.setIndeterminate(true);
            this.myProgress.setText("Scanning indexed files...");
            Set<PsiFile> filesForFastWordSearch = this.getFilesForFastWordSearch();
            this.myProgress.setIndeterminate(false);
            this.searchInFiles(consumer, processPresentation, filesForFastWordSearch);
            this.myProgress.setIndeterminate(true);
            this.myProgress.setText("Scanning non-indexed files...");
            boolean skipIndexed = this.canRelyOnIndices();
            Collection<PsiFile> otherFiles = this.collectFilesInScope(filesForFastWordSearch, skipIndexed);
            this.myProgress.setIndeterminate(false);
            long start = System.currentTimeMillis();
            this.searchInFiles(consumer, processPresentation, otherFiles);
            if (skipIndexed && otherFiles.size() > 1000) {
                FindInProjectTask.logStats(otherFiles, start);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        if (!this.myLargeFiles.isEmpty()) {
            processPresentation.setLargeFilesWereNotScanned(this.myLargeFiles);
        }
        if (!this.myProgress.isCanceled()) {
            this.myProgress.setText(FindBundle.message("find.progress.search.completed", new Object[0]));
        }
    }

    private static void logStats(Collection<PsiFile> otherFiles, long start) {
        long time = System.currentTimeMillis() - start;
        HashMultiset stats = HashMultiset.create();
        for (PsiFile file : otherFiles) {
            stats.add((Object)StringUtil.notNullize((String)file.getViewProvider().getVirtualFile().getExtension()).toLowerCase());
        }
        ArrayList extensions = ContainerUtil.newArrayList((Iterable)stats.elementSet());
        Collections.sort(extensions, new Comparator<String>((Multiset)stats){
            final /* synthetic */ Multiset val$stats;
            {
                this.val$stats = multiset;
            }

            @Override
            public int compare(String o1, String o2) {
                return this.val$stats.count((Object)o2) - this.val$stats.count((Object)o1);
            }
        });
        String message = "Search in " + otherFiles.size() + " files with unknown types took " + time + "ms.\n" + "Mapping their extensions to an existing file type (e.g. Plain Text) might speed up the search.\n" + "Most frequent non-indexed file extensions: ";
        for (int i = 0; i < Math.min(10, extensions.size()); ++i) {
            String extension = (String)extensions.get(i);
            message = message + extension + "(" + stats.count((Object)extension) + ") ";
        }
        LOG.info(message);
    }

    private void searchInFiles(Processor<UsageInfo> consumer, FindUsagesProcessPresentation processPresentation, Collection<PsiFile> psiFiles) {
        int i = 0;
        long totalFilesSize = 0L;
        int count = 0;
        for (PsiFile psiFile : psiFiles) {
            long fileLength;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            int index = i++;
            if (virtualFile == null || (fileLength = UsageViewManagerImpl.getFileLength((VirtualFile)virtualFile)) == -1L || ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile) && !Registry.is((String)"find.search.in.project.files")) continue;
            if (fileLength > 0x500000L) {
                this.myLargeFiles.add(psiFile);
                continue;
            }
            this.myProgress.checkCanceled();
            this.myProgress.setFraction((double)index / (double)psiFiles.size());
            String text = FindBundle.message("find.searching.for.string.in.file.progress", this.myFindModel.getStringToFind(), virtualFile.getPresentableUrl());
            this.myProgress.setText(text);
            this.myProgress.setText2(FindBundle.message("find.searching.for.string.in.file.occurrences.progress", count));
            int countInFile = FindInProjectUtil.processUsagesInFile(psiFile, this.myFindModel, consumer);
            count += countInFile;
            if (countInFile <= 0 || (totalFilesSize += fileLength) <= 0x4600000L || this.myWarningShown) continue;
            this.myWarningShown = true;
            String message = FindBundle.message("find.excessive.total.size.prompt", UsageViewManagerImpl.presentableSize((long)totalFilesSize), ApplicationNamesInfo.getInstance().getProductName());
            UsageLimitUtil.showAndCancelIfAborted((Project)this.myProject, (String)message, (UsageViewPresentation)processPresentation.getUsageViewPresentation());
        }
    }

    @NotNull
    private Collection<PsiFile> collectFilesInScope(final @NotNull Set<PsiFile> alreadySearched, final boolean skipIndexed) {
        if (alreadySearched == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/impl/FindInProjectTask", "collectFilesInScope"));
        }
        SearchScope customScope = this.myFindModel.getCustomScope();
        final GlobalSearchScope globalCustomScope = this.toGlobal(customScope);
        final ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        class EnumContentIterator
        implements ContentIterator {
            final Set<PsiFile> myFiles = new LinkedHashSet<PsiFile>();

            EnumContentIterator() {
            }

            public boolean processFile(final @NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/impl/FindInProjectTask$1EnumContentIterator", "processFile"));
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        ProgressManager.checkCanceled();
                        if (virtualFile.isDirectory() || !virtualFile.isValid() || !FindInProjectTask.this.myFileMask.value((Object)virtualFile) || globalCustomScope != null && !globalCustomScope.contains(virtualFile)) {
                            return;
                        }
                        if (skipIndexed && FindInProjectTask.isCoveredByIdIndex(virtualFile) && (fileIndex.isInContent(virtualFile) || fileIndex.isInLibraryClasses(virtualFile) || fileIndex.isInLibrarySource(virtualFile))) {
                            return;
                        }
                        PsiFile psiFile = FindInProjectTask.this.myPsiManager.findFile(virtualFile);
                        if (psiFile != null && !(psiFile instanceof PsiBinaryFile) && !alreadySearched.contains(psiFile)) {
                            PsiFile sourceFile = (PsiFile)psiFile.getNavigationElement();
                            if (sourceFile != null) {
                                psiFile = sourceFile;
                            }
                            myFiles.add(psiFile);
                        }
                    }
                });
                return true;
            }

            @NotNull
            private Collection<PsiFile> getFiles() {
                Set<PsiFile> set = this.myFiles;
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask$1EnumContentIterator", "getFiles"));
                }
                return set;
            }
        }
        final EnumContentIterator iterator = new EnumContentIterator();
        if (customScope instanceof LocalSearchScope) {
            for (VirtualFile file : FindInProjectTask.getLocalScopeFiles((LocalSearchScope)customScope)) {
                iterator.processFile(file);
            }
        } else if (customScope instanceof Iterable) {
            for (VirtualFile file : (Iterable)customScope) {
                iterator.processFile(file);
            }
        } else if (this.myPsiDirectory != null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){
                {
                }

                @Override
                public void run() {
                    if (FindInProjectTask.this.myPsiDirectory.isValid()) {
                        FindInProjectTask.this.addFilesUnderDirectory(FindInProjectTask.this.myPsiDirectory, iterator);
                    }
                }
            });
            this.myFileIndex.iterateContentUnderDirectory(this.myPsiDirectory.getVirtualFile(), (ContentIterator)iterator);
        } else {
            boolean success = this.myFileIndex.iterateContent((ContentIterator)iterator);
            if (success && globalCustomScope != null && globalCustomScope.isSearchInLibraries()) {
                VirtualFile[] librarySources = (VirtualFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile[]>(){

                    public VirtualFile[] compute() {
                        OrderEnumerator enumerator = FindInProjectTask.this.myModule == null ? OrderEnumerator.orderEntries((Project)FindInProjectTask.this.myProject) : OrderEnumerator.orderEntries((Module)FindInProjectTask.this.myModule);
                        return enumerator.withoutModuleSourceEntries().withoutDepModules().getSourceRoots();
                    }
                });
                FindInProjectTask.iterateAll(librarySources, globalCustomScope, iterator);
            }
        }
        Collection collection = iterator.getFiles();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "collectFilesInScope"));
        }
        return collection;
    }

    private static boolean isCoveredByIdIndex(VirtualFile file) {
        return IdIndex.isIndexable(FileBasedIndexImpl.getFileType(file)) && ((FileBasedIndexImpl)FileBasedIndex.getInstance()).isIndexingCandidate(file, IdIndex.NAME);
    }

    private static boolean iterateAll(@NotNull VirtualFile[] files, final @NotNull GlobalSearchScope searchScope, @NotNull ContentIterator iterator) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/impl/FindInProjectTask", "iterateAll"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/impl/FindInProjectTask", "iterateAll"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/impl/FindInProjectTask", "iterateAll"));
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VirtualFileFilter contentFilter = new VirtualFileFilter(){

            public boolean accept(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/impl/FindInProjectTask$6", "accept"));
                }
                return file.isDirectory() || !fileTypeManager.isFileIgnored(file) && !file.getFileType().isBinary() && searchScope.contains(file);
            }
        };
        for (VirtualFile file : files) {
            if (VfsUtilCore.iterateChildrenRecursively((VirtualFile)file, (VirtualFileFilter)contentFilter, (ContentIterator)iterator)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private GlobalSearchScope toGlobal(final @Nullable SearchScope scope) {
        if (scope instanceof GlobalSearchScope || scope == null) {
            return (GlobalSearchScope)scope;
        }
        return (GlobalSearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<GlobalSearchScope>(){

            public GlobalSearchScope compute() {
                return GlobalSearchScope.filesScope((Project)FindInProjectTask.this.myProject, (Collection)FindInProjectTask.getLocalScopeFiles((LocalSearchScope)scope));
            }
        });
    }

    @NotNull
    private static Set<VirtualFile> getLocalScopeFiles(@NotNull LocalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/impl/FindInProjectTask", "getLocalScopeFiles"));
        }
        LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
        for (PsiElement element : scope.getScope()) {
            PsiFile file = element.getContainingFile();
            if (file == null) continue;
            ContainerUtil.addIfNotNull(files, (Object)file.getVirtualFile());
        }
        LinkedHashSet<VirtualFile> linkedHashSet = files;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "getLocalScopeFiles"));
        }
        return linkedHashSet;
    }

    private boolean canRelyOnIndices() {
        if (DumbService.isDumb((Project)this.myProject)) {
            return false;
        }
        if (this.myFindModel.isRegularExpressions()) {
            return false;
        }
        if (this.myFindModel.getCustomScope() instanceof LocalSearchScope) {
            return false;
        }
        String text = this.myFindModel.getStringToFind();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return false;
        }
        if (TrigramIndex.ENABLED) {
            return !TrigramBuilder.buildTrigram((CharSequence)text).isEmpty();
        }
        return this.myFindModel.isWholeWordsOnly() && text.indexOf(36) < 0 && !StringUtil.getWordsInStringLongestFirst((String)text).isEmpty();
    }

    @NotNull
    private Set<PsiFile> getFilesForFastWordSearch() {
        GlobalSearchScope scope;
        String stringToFind = this.myFindModel.getStringToFind();
        if (stringToFind.isEmpty() || DumbService.getInstance((Project)this.myProject).isDumb()) {
            Set<PsiFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "getFilesForFastWordSearch"));
            }
            return set;
        }
        SearchScope customScope = this.myFindModel.getCustomScope();
        GlobalSearchScope globalSearchScope = this.myPsiDirectory != null ? GlobalSearchScopesCore.directoryScope((PsiDirectory)this.myPsiDirectory, (boolean)true) : (this.myModule != null ? this.myModule.getModuleContentScope() : (scope = customScope instanceof GlobalSearchScope ? (GlobalSearchScope)customScope : this.toGlobal(customScope)));
        if (scope == null) {
            scope = ProjectScope.getContentScope((Project)this.myProject);
        }
        final LinkedHashSet<PsiFile> resultFiles = new LinkedHashSet<PsiFile>();
        if (TrigramIndex.ENABLED) {
            THashSet keys = ContainerUtil.newTroveSet();
            TIntHashSet trigrams = TrigramBuilder.buildTrigram((CharSequence)stringToFind);
            TIntIterator it = trigrams.iterator();
            while (it.hasNext()) {
                keys.add(it.next());
            }
            if (!keys.isEmpty()) {
                ArrayList hits = new ArrayList();
                FileBasedIndex.getInstance().getFilesWithKey(TrigramIndex.INDEX_ID, (Set)keys, (Processor)new CommonProcessors.CollectProcessor(hits), scope);
                for (VirtualFile hit : hits) {
                    if (!this.myFileMask.value((Object)hit)) continue;
                    resultFiles.add(this.findFile(hit));
                }
                LinkedHashSet<PsiFile> linkedHashSet = resultFiles;
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "getFilesForFastWordSearch"));
                }
                return linkedHashSet;
            }
        }
        PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.SERVICE.getInstance((Project)this.myProject);
        helper.processFilesWithText(scope, (short)255, this.myFindModel.isCaseSensitive(), stringToFind, new Processor<VirtualFile>(){

            public boolean process(VirtualFile file) {
                if (FindInProjectTask.this.myFileMask.value((Object)file)) {
                    ContainerUtil.addIfNotNull((Collection)resultFiles, (Object)FindInProjectTask.this.findFile(file));
                }
                return true;
            }
        });
        for (PsiFile file : CacheManager.SERVICE.getInstance(this.myProject).getFilesWithWord(stringToFind, (short)255, scope, this.myFindModel.isCaseSensitive())) {
            if (!this.myFileMask.value((Object)file.getVirtualFile())) continue;
            resultFiles.add(file);
        }
        LinkedHashSet<PsiFile> linkedHashSet = resultFiles;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "getFilesForFastWordSearch"));
        }
        return linkedHashSet;
    }

    private PsiFile findFile(final @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/impl/FindInProjectTask", "findFile"));
        }
        return (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                return FindInProjectTask.this.myPsiManager.findFile(virtualFile);
            }
        });
    }

    private void addFilesUnderDirectory(@NotNull PsiDirectory directory, @NotNull ContentIterator iterator) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/impl/FindInProjectTask", "addFilesUnderDirectory"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/impl/FindInProjectTask", "addFilesUnderDirectory"));
        }
        for (PsiElement child : directory.getChildren()) {
            if (child instanceof PsiFile) {
                VirtualFile virtualFile = ((PsiFile)child).getVirtualFile();
                if (virtualFile == null) continue;
                iterator.processFile(virtualFile);
                continue;
            }
            if (!this.myFindModel.isWithSubdirectories() || !(child instanceof PsiDirectory)) continue;
            this.addFilesUnderDirectory((PsiDirectory)child, iterator);
        }
    }
}

