/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.openapi.util.Condition;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UsageHistory {
    private final List<ConfigurableUsageTarget> myHistory = ContainerUtil.createLockFreeCopyOnWriteList();

    public void add(@NotNull ConfigurableUsageTarget usageTarget) {
        if (usageTarget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/UsageHistory", "add"));
        }
        final String descriptiveName = usageTarget.getLongDescriptiveName();
        ContainerUtil.retainAll(this.myHistory, (Condition)new Condition<ConfigurableUsageTarget>(){

            public boolean value(ConfigurableUsageTarget existing) {
                return !existing.getLongDescriptiveName().equals(descriptiveName);
            }
        });
        this.myHistory.add(usageTarget);
        if (this.myHistory.size() > 15) {
            this.myHistory.remove(0);
        }
    }

    @NotNull
    public List<ConfigurableUsageTarget> getAll() {
        this.removeInvalidElementsFromHistory();
        List<ConfigurableUsageTarget> list = Collections.unmodifiableList(this.myHistory);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/UsageHistory", "getAll"));
        }
        return list;
    }

    private void removeInvalidElementsFromHistory() {
        for (ConfigurableUsageTarget target : this.myHistory) {
            if (target.isValid()) continue;
            this.myHistory.remove(target);
        }
    }
}

