/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindClassUsagesDialog;
import com.intellij.find.findUsages.FindMethodUsagesDialog;
import com.intellij.find.findUsages.FindPackageUsagesDialog;
import com.intellij.find.findUsages.FindThrowUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.FindVariableUsagesDialog;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandlerFactory;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiReferenceProcessor;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetMapper;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.refactoring.util.JavaNonCodeSearchElementDescriptionProvider;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFindUsagesHandler
extends FindUsagesHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.findUsages.JavaFindUsagesHandler");
    public static final String ACTION_STRING = FindBundle.message("find.super.method.warning.action.verb", new Object[0]);
    private final PsiElement[] myElementsToSearch;
    private final JavaFindUsagesHandlerFactory myFactory;

    public JavaFindUsagesHandler(@NotNull PsiElement psiElement, @NotNull JavaFindUsagesHandlerFactory factory) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "<init>"));
        }
        this(psiElement, PsiElement.EMPTY_ARRAY, factory);
    }

    public JavaFindUsagesHandler(@NotNull PsiElement psiElement, @NotNull PsiElement[] elementsToSearch, @NotNull JavaFindUsagesHandlerFactory factory) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "<init>"));
        }
        if (elementsToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "<init>"));
        }
        super(psiElement);
        this.myElementsToSearch = elementsToSearch;
        this.myFactory = factory;
    }

    @Override
    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiPackage) {
            FindPackageUsagesDialog findPackageUsagesDialog = new FindPackageUsagesDialog(element, this.getProject(), this.myFactory.getFindPackageOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findPackageUsagesDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesDialog"));
            }
            return findPackageUsagesDialog;
        }
        if (element instanceof PsiClass) {
            FindClassUsagesDialog findClassUsagesDialog = new FindClassUsagesDialog(element, this.getProject(), this.myFactory.getFindClassOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findClassUsagesDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesDialog"));
            }
            return findClassUsagesDialog;
        }
        if (element instanceof PsiMethod) {
            FindMethodUsagesDialog findMethodUsagesDialog = new FindMethodUsagesDialog(element, this.getProject(), this.myFactory.getFindMethodOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findMethodUsagesDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesDialog"));
            }
            return findMethodUsagesDialog;
        }
        if (element instanceof PsiVariable) {
            FindVariableUsagesDialog findVariableUsagesDialog = new FindVariableUsagesDialog(element, this.getProject(), this.myFactory.getFindVariableOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findVariableUsagesDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesDialog"));
            }
            return findVariableUsagesDialog;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            FindThrowUsagesDialog findThrowUsagesDialog = new FindThrowUsagesDialog(element, this.getProject(), this.myFactory.getFindThrowOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (findThrowUsagesDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesDialog"));
            }
            return findThrowUsagesDialog;
        }
        AbstractFindUsagesDialog abstractFindUsagesDialog = super.getFindUsagesDialog(isSingleFile, toShowInNewTab, mustOpenInNewTab);
        if (abstractFindUsagesDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesDialog"));
        }
        return abstractFindUsagesDialog;
    }

    private static boolean askWhetherShouldSearchForParameterInOverridingMethods(PsiElement psiElement, PsiParameter parameter) {
        return Messages.showOkCancelDialog((Project)psiElement.getProject(), (String)FindBundle.message("find.parameter.usages.in.overriding.methods.prompt", parameter.getName()), (String)FindBundle.message("find.parameter.usages.in.overriding.methods.title", new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    private static PsiElement[] getParameterElementsToSearch(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getParameterElementsToSearch"));
        }
        PsiMethod method = (PsiMethod)parameter.getDeclarationScope();
        PsiMethod[] overrides = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
        for (int i = 0; i < overrides.length; ++i) {
            overrides[i] = (PsiMethod)overrides[i].getNavigationElement();
        }
        ArrayList<PsiParameter> elementsToSearch = new ArrayList<PsiParameter>(overrides.length + 1);
        elementsToSearch.add(parameter);
        int idx = method.getParameterList().getParameterIndex(parameter);
        for (PsiMethod override : overrides) {
            PsiParameter[] parameters = override.getParameterList().getParameters();
            if (idx >= parameters.length) continue;
            elementsToSearch.add(parameters[idx]);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(elementsToSearch);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getParameterElementsToSearch"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiElement[] getPrimaryElements() {
        PsiElement[] psiElementArray;
        PsiMethod method;
        PsiParameter parameter;
        PsiElement scope;
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiParameter && (scope = (parameter = (PsiParameter)element).getDeclarationScope()) instanceof PsiMethod && PsiUtil.canBeOverriden((PsiMethod)(method = (PsiMethod)scope))) {
            boolean hasOverridden;
            PsiClass aClass = method.getContainingClass();
            LOG.assertTrue(aClass != null);
            boolean bl = hasOverridden = OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
            if (hasOverridden && JavaFindUsagesHandler.askWhetherShouldSearchForParameterInOverridingMethods(element, parameter)) {
                PsiElement[] psiElementArray2 = JavaFindUsagesHandler.getParameterElementsToSearch(parameter);
                if (psiElementArray2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getPrimaryElements"));
                }
                return psiElementArray2;
            }
        }
        if (this.myElementsToSearch.length == 0) {
            PsiElement[] psiElementArray3 = new PsiElement[1];
            psiElementArray = psiElementArray3;
            psiElementArray3[0] = element;
        } else {
            psiElementArray = this.myElementsToSearch;
        }
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getPrimaryElements"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiElement[] getSecondaryElements() {
        PsiField field;
        PsiClass containingClass;
        PsiElement element = this.getPsiElement();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getSecondaryElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (element instanceof PsiField && (containingClass = (field = (PsiField)element).getContainingClass()) != null) {
            PsiMethod setter;
            String fieldName = field.getName();
            String propertyName = JavaCodeStyleManager.getInstance((Project)this.getProject()).variableNameToPropertyName(fieldName, VariableKind.FIELD);
            THashSet accessors = new THashSet();
            boolean isStatic = field.hasModifierProperty("static");
            PsiMethod getter = PropertyUtil.findPropertyGetterWithType((String)propertyName, (boolean)isStatic, (PsiType)field.getType(), (Iterator)ContainerUtil.iterate((Object[])containingClass.getMethods()));
            if (getter != null) {
                accessors.add(getter);
            }
            if ((setter = PropertyUtil.findPropertySetterWithType((String)propertyName, (boolean)isStatic, (PsiType)field.getType(), (Iterator)ContainerUtil.iterate((Object[])containingClass.getMethods()))) != null) {
                accessors.add(setter);
            }
            accessors.addAll(PropertyUtil.getAccessors((PsiClass)containingClass, (String)fieldName));
            if (!accessors.isEmpty()) {
                boolean doSearch;
                boolean containsPhysical = ContainerUtil.find((Iterable)accessors, (Condition)new Condition<PsiMethod>(){

                    public boolean value(PsiMethod psiMethod) {
                        return psiMethod.isPhysical();
                    }
                }) != null;
                boolean bl = doSearch = !containsPhysical || Messages.showOkCancelDialog((String)FindBundle.message("find.field.accessors.prompt", fieldName), (String)FindBundle.message("find.field.accessors.title", new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
                if (doSearch) {
                    THashSet elements = new THashSet();
                    for (PsiMethod accessor : accessors) {
                        ContainerUtil.addAll((Collection)elements, (Object[])SuperMethodWarningUtil.checkSuperMethods(accessor, ACTION_STRING));
                    }
                    PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)elements);
                    if (psiElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getSecondaryElements"));
                    }
                    return psiElementArray;
                }
            }
        }
        PsiElement[] psiElementArray = super.getSecondaryElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getSecondaryElements"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiPackage) {
            JavaPackageFindUsagesOptions javaPackageFindUsagesOptions = this.myFactory.getFindPackageOptions();
            if (javaPackageFindUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesOptions"));
            }
            return javaPackageFindUsagesOptions;
        }
        if (element instanceof PsiClass) {
            JavaClassFindUsagesOptions javaClassFindUsagesOptions = this.myFactory.getFindClassOptions();
            if (javaClassFindUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesOptions"));
            }
            return javaClassFindUsagesOptions;
        }
        if (element instanceof PsiMethod) {
            JavaMethodFindUsagesOptions javaMethodFindUsagesOptions = this.myFactory.getFindMethodOptions();
            if (javaMethodFindUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesOptions"));
            }
            return javaMethodFindUsagesOptions;
        }
        if (element instanceof PsiVariable) {
            JavaVariableFindUsagesOptions javaVariableFindUsagesOptions = this.myFactory.getFindVariableOptions();
            if (javaVariableFindUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesOptions"));
            }
            return javaVariableFindUsagesOptions;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            JavaThrowFindUsagesOptions javaThrowFindUsagesOptions = this.myFactory.getFindThrowOptions();
            if (javaThrowFindUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesOptions"));
            }
            return javaThrowFindUsagesOptions;
        }
        FindUsagesOptions findUsagesOptions = super.getFindUsagesOptions(dataContext);
        if (findUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFindUsagesOptions"));
        }
        return findUsagesOptions;
    }

    protected Set<String> getStringsToSearch(final PsiElement element) {
        if (element instanceof PsiDirectory) {
            return this.getStringsToSearch((PsiElement)JavaDirectoryService.getInstance().getPackage((PsiDirectory)element));
        }
        final HashSet<String> result = new HashSet<String>();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (element instanceof PsiPackage) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)((PsiPackage)element).getQualifiedName());
                } else if (element instanceof PsiClass) {
                    String qname = ((PsiClass)element).getQualifiedName();
                    if (qname != null) {
                        result.add(qname);
                        PsiClass topLevelClass = PsiUtil.getTopLevelClass((PsiElement)element);
                        if (topLevelClass != null) {
                            String topName = topLevelClass.getQualifiedName();
                            assert (topName != null);
                            if (qname.length() > topName.length()) {
                                result.add(topName + qname.substring(topName.length()).replace('.', '$'));
                            }
                        }
                    }
                } else if (element instanceof PsiMethod) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)((PsiMethod)element).getName());
                } else if (element instanceof PsiVariable) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)((PsiVariable)element).getName());
                } else if (element instanceof PsiMetaOwner) {
                    PsiMetaData metaData = ((PsiMetaOwner)element).getMetaData();
                    if (metaData != null) {
                        ContainerUtil.addIfNotNull((Collection)result, (Object)metaData.getName());
                    }
                } else if (element instanceof PsiNamedElement) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)((PsiNamedElement)element).getName());
                } else if (element instanceof XmlAttributeValue) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)((XmlAttributeValue)element).getValue());
                } else {
                    LOG.error("Unknown element type: " + element);
                }
            }
        });
        return result;
    }

    @Override
    public boolean processElementUsages(final @NotNull PsiElement element, final @NotNull Processor<UsageInfo> processor, final @NotNull FindUsagesOptions options) {
        boolean success;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "processElementUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "processElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "processElementUsages"));
        }
        if (options instanceof JavaVariableFindUsagesOptions) {
            final JavaVariableFindUsagesOptions varOptions = (JavaVariableFindUsagesOptions)options;
            if ((varOptions.isReadAccess || varOptions.isWriteAccess) && (varOptions.isReadAccess && varOptions.isWriteAccess ? !JavaFindUsagesHandler.addElementUsages(element, processor, options) : !JavaFindUsagesHandler.addElementUsages(element, new Processor<UsageInfo>(){

                public boolean process(UsageInfo info) {
                    boolean isWrite;
                    PsiElement element = info.getElement();
                    boolean bl = isWrite = element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element));
                    return isWrite != varOptions.isWriteAccess || processor.process((Object)info);
                }
            }, varOptions))) {
                return false;
            }
        } else if (options.isUsages && !JavaFindUsagesHandler.addElementUsages(element, processor, options)) {
            return false;
        }
        if (!(success = ((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (ThrowSearchUtil.isSearchable(element) && options instanceof JavaThrowFindUsagesOptions && options.isUsages) {
                    ThrowSearchUtil.Root[] roots;
                    ThrowSearchUtil.Root root = (ThrowSearchUtil.Root)options.getUserData(ThrowSearchUtil.THROW_SEARCH_ROOT_KEY);
                    if (root == null && (roots = ThrowSearchUtil.getSearchRoots(element)) != null && roots.length > 0) {
                        root = roots[0];
                    }
                    if (root != null) {
                        return ThrowSearchUtil.addThrowUsages((Processor<UsageInfo>)processor, root, options);
                    }
                }
                return true;
            }
        })).booleanValue())) {
            return false;
        }
        if (options instanceof JavaPackageFindUsagesOptions && ((JavaPackageFindUsagesOptions)options).isClassesUsages && !JavaFindUsagesHandler.addClassesUsages((PsiPackage)element, processor, (JavaPackageFindUsagesOptions)options)) {
            return false;
        }
        if (options instanceof JavaClassFindUsagesOptions) {
            JavaClassFindUsagesOptions classOptions = (JavaClassFindUsagesOptions)options;
            PsiClass psiClass = (PsiClass)element;
            if (classOptions.isMethodsUsages && !JavaFindUsagesHandler.addMethodsUsages(psiClass, processor, classOptions)) {
                return false;
            }
            if (classOptions.isFieldsUsages && !JavaFindUsagesHandler.addFieldsUsages(psiClass, processor, classOptions)) {
                return false;
            }
            if (psiClass.isInterface()) {
                if (classOptions.isDerivedInterfaces) {
                    if (classOptions.isImplementingClasses ? !JavaFindUsagesHandler.addInheritors(psiClass, processor, classOptions) : !JavaFindUsagesHandler.addDerivedInterfaces(psiClass, processor, classOptions)) {
                        return false;
                    }
                } else if (classOptions.isImplementingClasses) {
                    if (!JavaFindUsagesHandler.addImplementingClasses(psiClass, processor, classOptions)) {
                        return false;
                    }
                    FunctionalExpressionSearch.search((PsiClass)psiClass, (SearchScope)classOptions.searchScope).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiFunctionalExpression>(){

                        public boolean execute(@NotNull PsiFunctionalExpression expression) {
                            if (expression == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler$5", "execute"));
                            }
                            return JavaFindUsagesHandler.addResult((Processor<UsageInfo>)processor, (PsiElement)expression, options);
                        }
                    }));
                }
            } else if (classOptions.isDerivedClasses && !JavaFindUsagesHandler.addInheritors(psiClass, processor, classOptions)) {
                return false;
            }
        }
        if (options instanceof JavaMethodFindUsagesOptions) {
            final PsiMethod psiMethod = (PsiMethod)element;
            boolean isAbstract = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return psiMethod.hasModifierProperty("abstract");
                }
            });
            JavaMethodFindUsagesOptions methodOptions = (JavaMethodFindUsagesOptions)options;
            if (isAbstract && methodOptions.isImplementingMethods || methodOptions.isOverridingMethods) {
                if (!JavaFindUsagesHandler.processOverridingMethods(psiMethod, processor, methodOptions)) {
                    return false;
                }
                FunctionalExpressionSearch.search((PsiMethod)psiMethod, (SearchScope)methodOptions.searchScope).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiFunctionalExpression>(){

                    public boolean execute(@NotNull PsiFunctionalExpression expression) {
                        if (expression == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler$7", "execute"));
                        }
                        return JavaFindUsagesHandler.addResult((Processor<UsageInfo>)processor, (PsiElement)expression, options);
                    }
                }));
            }
        }
        if (element instanceof PomTarget && !JavaFindUsagesHandler.addAliasingUsages((PomTarget)element, processor, options)) {
            return false;
        }
        Boolean isSearchable = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return ThrowSearchUtil.isSearchable(element);
            }
        });
        return isSearchable != false || !options.isSearchForTextOccurrences || !(options.searchScope instanceof GlobalSearchScope) || this.processUsagesInText(element, processor, (GlobalSearchScope)options.searchScope);
    }

    private static boolean addAliasingUsages(@NotNull PomTarget pomTarget, final @NotNull Processor<UsageInfo> processor, final @NotNull FindUsagesOptions options) {
        if (pomTarget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addAliasingUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addAliasingUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addAliasingUsages"));
        }
        for (AliasingPsiTargetMapper aliasingPsiTargetMapper : (AliasingPsiTargetMapper[])Extensions.getExtensions((ExtensionPointName)AliasingPsiTargetMapper.EP_NAME)) {
            for (AliasingPsiTarget psiTarget : aliasingPsiTargetMapper.getTargets(pomTarget)) {
                boolean success = ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters(PomService.convertToPsi((PsiTarget)psiTarget), options.searchScope, false, options.fastTrack)).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                    public boolean processInReadAction(PsiReference reference) {
                        return JavaFindUsagesHandler.addResult((Processor<UsageInfo>)processor, reference, options);
                    }
                });
                if (success) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processOverridingMethods(@NotNull PsiMethod psiMethod, final @NotNull Processor<UsageInfo> processor, final @NotNull JavaMethodFindUsagesOptions options) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "processOverridingMethods"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "processOverridingMethods"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "processOverridingMethods"));
        }
        return OverridingMethodsSearch.search((PsiMethod)psiMethod, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiMethod>(){

            public boolean execute(@NotNull PsiMethod element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler$10", "execute"));
                }
                return JavaFindUsagesHandler.addResult((Processor<UsageInfo>)processor, element.getNavigationElement(), options);
            }
        }));
    }

    private static boolean addClassesUsages(@NotNull PsiPackage aPackage, final @NotNull Processor<UsageInfo> processor, final @NotNull JavaPackageFindUsagesOptions options) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addClassesUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addClassesUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addClassesUsages"));
        }
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.pushState();
        }
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        JavaFindUsagesHandler.addClassesInPackage(aPackage, options.isIncludeSubpackages, classes);
        for (final PsiClass aClass : classes) {
            boolean success;
            if (progress != null) {
                progress.setText(FindBundle.message("find.searching.for.references.to.class.progress", ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return aClass.getName();
                    }
                })));
                progress.checkCanceled();
            }
            if (success = ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters((PsiElement)aClass, options.searchScope, false, options.fastTrack)).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                public boolean processInReadAction(PsiReference psiReference) {
                    return JavaFindUsagesHandler.addResult((Processor<UsageInfo>)processor, psiReference, options);
                }
            })) continue;
            return false;
        }
        if (progress != null) {
            progress.popState();
        }
        return true;
    }

    private static void addClassesInPackage(@NotNull PsiPackage aPackage, boolean includeSubpackages, @NotNull List<PsiClass> array) {
        PsiDirectory[] dirs;
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addClassesInPackage"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addClassesInPackage"));
        }
        for (PsiDirectory dir : dirs = aPackage.getDirectories()) {
            JavaFindUsagesHandler.addClassesInDirectory(dir, includeSubpackages, array);
        }
    }

    private static void addClassesInDirectory(final @NotNull PsiDirectory dir, final boolean includeSubdirs, final @NotNull List<PsiClass> array) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addClassesInDirectory"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addClassesInDirectory"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                Object[] classes = JavaDirectoryService.getInstance().getClasses(dir);
                ContainerUtil.addAll((Collection)array, (Object[])classes);
                if (includeSubdirs) {
                    PsiDirectory[] dirs;
                    for (PsiDirectory directory : dirs = dir.getSubdirectories()) {
                        JavaFindUsagesHandler.addClassesInDirectory(directory, includeSubdirs, array);
                    }
                }
            }
        });
    }

    private static boolean addMethodsUsages(final @NotNull PsiClass aClass, final @NotNull Processor<UsageInfo> processor, final @NotNull JavaClassFindUsagesOptions options) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addMethodsUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addMethodsUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addMethodsUsages"));
        }
        if (options.isIncludeInherited) {
            final PsiManager manager = aClass.getManager();
            PsiMethod[] methods = aClass.getAllMethods();
            block0: for (int i = 0; i < methods.length; ++i) {
                boolean success;
                PsiMethod method = methods[i];
                MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
                for (int j = 0; j < i; ++j) {
                    if (methodSignature.equals(methods[j].getSignature(PsiSubstitutor.EMPTY))) continue block0;
                }
                final PsiClass methodClass = method.getContainingClass();
                if (!(methodClass != null && manager.areElementsEquivalent((PsiElement)methodClass, (PsiElement)aClass) ? !JavaFindUsagesHandler.addElementUsages((PsiElement)methods[i], processor, options) : !(success = MethodReferencesSearch.search((MethodReferencesSearch.SearchParameters)new MethodReferencesSearch.SearchParameters(method, options.searchScope, true, options.fastTrack)).forEach((Processor)new PsiReferenceProcessorAdapter(new PsiReferenceProcessor(){

                    public boolean execute(PsiReference reference) {
                        JavaFindUsagesHandler.addResultFromReference(reference, methodClass, manager, aClass, (Processor<UsageInfo>)processor, options);
                        return true;
                    }
                }))))) continue;
                return false;
            }
        } else {
            for (PsiMethod method : aClass.getMethods()) {
                if (JavaFindUsagesHandler.addElementUsages((PsiElement)method, processor, options)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean addFieldsUsages(final @NotNull PsiClass aClass, final @NotNull Processor<UsageInfo> processor, final @NotNull JavaClassFindUsagesOptions options) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addFieldsUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addFieldsUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addFieldsUsages"));
        }
        if (options.isIncludeInherited) {
            final PsiManager manager = aClass.getManager();
            PsiField[] fields = aClass.getAllFields();
            block0: for (int i = 0; i < fields.length; ++i) {
                boolean success;
                PsiField field = fields[i];
                for (int j = 0; j < i; ++j) {
                    if (Comparing.strEqual((String)field.getName(), (String)fields[j].getName())) continue block0;
                }
                final PsiClass fieldClass = field.getContainingClass();
                if (!(manager.areElementsEquivalent((PsiElement)fieldClass, (PsiElement)aClass) ? !JavaFindUsagesHandler.addElementUsages((PsiElement)fields[i], processor, options) : !(success = ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters((PsiElement)field, options.searchScope, false, options.fastTrack)).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                    public boolean processInReadAction(PsiReference reference) {
                        return JavaFindUsagesHandler.addResultFromReference(reference, fieldClass, manager, aClass, (Processor<UsageInfo>)processor, options);
                    }
                })))) continue;
                return false;
            }
        } else {
            PsiField[] fields;
            for (PsiField field : fields = (PsiField[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiField[]>(){

                public PsiField[] compute() {
                    return aClass.getFields();
                }
            })) {
                if (JavaFindUsagesHandler.addElementUsages((PsiElement)field, processor, options)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static PsiClass getFieldOrMethodAccessedClass(@NotNull PsiReferenceExpression ref, PsiClass fieldOrMethodClass) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "getFieldOrMethodAccessedClass"));
        }
        PsiElement[] children = ref.getChildren();
        if (children.length > 1 && children[0] instanceof PsiExpression) {
            PsiElement refElement;
            PsiExpression expr = (PsiExpression)children[0];
            PsiType type = expr.getType();
            if (type != null) {
                if (!(type instanceof PsiClassType)) {
                    return null;
                }
                return PsiUtil.resolveClassInType((PsiType)type);
            }
            if (expr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)expr).resolve()) instanceof PsiClass) {
                return (PsiClass)refElement;
            }
            return null;
        }
        PsiManager manager = ref.getManager();
        for (PsiReferenceExpression parent = ref; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PsiClass) || !manager.areElementsEquivalent((PsiElement)parent, (PsiElement)fieldOrMethodClass) && !((PsiClass)parent).isInheritor(fieldOrMethodClass, true)) continue;
            return (PsiClass)parent;
        }
        return null;
    }

    private static boolean addInheritors(@NotNull PsiClass aClass, final @NotNull Processor<UsageInfo> processor, final @NotNull JavaClassFindUsagesOptions options) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addInheritors"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addInheritors"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addInheritors"));
        }
        return ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

            public boolean execute(@NotNull PsiClass element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler$17", "execute"));
                }
                return JavaFindUsagesHandler.addResult((Processor<UsageInfo>)processor, (PsiElement)element, options);
            }
        }));
    }

    private static boolean addDerivedInterfaces(@NotNull PsiClass anInterface, final @NotNull Processor<UsageInfo> processor, final @NotNull JavaClassFindUsagesOptions options) {
        if (anInterface == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addDerivedInterfaces"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addDerivedInterfaces"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addDerivedInterfaces"));
        }
        return ClassInheritorsSearch.search((PsiClass)anInterface, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

            public boolean execute(@NotNull PsiClass inheritor) {
                if (inheritor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler$18", "execute"));
                }
                return !inheritor.isInterface() || JavaFindUsagesHandler.addResult((Processor<UsageInfo>)processor, (PsiElement)inheritor, options);
            }
        }));
    }

    private static boolean addImplementingClasses(@NotNull PsiClass anInterface, final @NotNull Processor<UsageInfo> processor, final @NotNull JavaClassFindUsagesOptions options) {
        if (anInterface == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addImplementingClasses"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addImplementingClasses"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addImplementingClasses"));
        }
        return ClassInheritorsSearch.search((PsiClass)anInterface, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

            public boolean execute(@NotNull PsiClass inheritor) {
                if (inheritor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler$19", "execute"));
                }
                return inheritor.isInterface() || JavaFindUsagesHandler.addResult((Processor<UsageInfo>)processor, (PsiElement)inheritor, options);
            }
        }));
    }

    private static boolean addResultFromReference(@NotNull PsiReference reference, @NotNull PsiClass methodClass, @NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull Processor<UsageInfo> processor, @NotNull FindUsagesOptions options) {
        PsiClass usedClass;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addResultFromReference"));
        }
        if (methodClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addResultFromReference"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addResultFromReference"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addResultFromReference"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addResultFromReference"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addResultFromReference"));
        }
        PsiElement refElement = reference.getElement();
        return !(refElement instanceof PsiReferenceExpression) || (usedClass = JavaFindUsagesHandler.getFieldOrMethodAccessedClass((PsiReferenceExpression)refElement, methodClass)) == null || !manager.areElementsEquivalent((PsiElement)usedClass, (PsiElement)aClass) && !usedClass.isInheritor(aClass, true) || JavaFindUsagesHandler.addResult(processor, refElement, options);
    }

    private static boolean addElementUsages(final @NotNull PsiElement element, final @NotNull Processor<UsageInfo> processor, final @NotNull FindUsagesOptions options) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addElementUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addElementUsages"));
        }
        SearchScope searchScope = options.searchScope;
        if (element instanceof PsiMethod && ((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return ((PsiMethod)element).isConstructor();
            }
        })).booleanValue()) {
            PsiMethod method = (PsiMethod)element;
            PsiClass parentClass = method.getContainingClass();
            if (parentClass != null) {
                boolean strictSignatureSearch = !(options instanceof JavaMethodFindUsagesOptions) || !((JavaMethodFindUsagesOptions)options).isIncludeOverloadUsages;
                return MethodReferencesSearch.search((MethodReferencesSearch.SearchParameters)new MethodReferencesSearch.SearchParameters(method, searchScope, strictSignatureSearch, options.fastTrack)).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                    public boolean processInReadAction(PsiReference ref) {
                        return JavaFindUsagesHandler.addResult((Processor<UsageInfo>)processor, ref, options);
                    }
                });
            }
            return true;
        }
        ReadActionProcessor<PsiReference> consumer = new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference ref) {
                return JavaFindUsagesHandler.addResult((Processor<UsageInfo>)processor, ref, options);
            }
        };
        if (element instanceof PsiMethod) {
            boolean strictSignatureSearch = !(options instanceof JavaMethodFindUsagesOptions) || !((JavaMethodFindUsagesOptions)options).isIncludeOverloadUsages;
            return MethodReferencesSearch.search((MethodReferencesSearch.SearchParameters)new MethodReferencesSearch.SearchParameters((PsiMethod)element, searchScope, strictSignatureSearch, options.fastTrack)).forEach((Processor)consumer);
        }
        return ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters(element, searchScope, false, options.fastTrack)).forEach((Processor)consumer);
    }

    private static boolean addResult(@NotNull Processor<UsageInfo> processor, @NotNull PsiElement element, @NotNull FindUsagesOptions options) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addResult"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addResult"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/JavaFindUsagesHandler", "addResult"));
        }
        return !JavaFindUsagesHandler.filterUsage(element, options) || processor.process((Object)new UsageInfo(element));
    }

    private static boolean addResult(Processor<UsageInfo> processor, PsiReference ref, FindUsagesOptions options) {
        if (JavaFindUsagesHandler.filterUsage(ref.getElement(), options)) {
            TextRange rangeInElement = ref.getRangeInElement();
            return processor.process((Object)new UsageInfo(ref.getElement(), rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), false));
        }
        return true;
    }

    private static boolean filterUsage(PsiElement usage, FindUsagesOptions options) {
        PsiElement parent;
        if (!(usage instanceof PsiJavaCodeReferenceElement)) {
            return true;
        }
        if (options instanceof JavaPackageFindUsagesOptions && !((JavaPackageFindUsagesOptions)options).isIncludeSubpackages && ((PsiReference)usage).resolve() instanceof PsiPackage && (parent = usage.getParent()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)parent).resolve() instanceof PsiPackage) {
            return false;
        }
        if (!(usage instanceof PsiReferenceExpression)) {
            if (options instanceof JavaFindUsagesOptions && ((JavaFindUsagesOptions)options).isSkipImportStatements) {
                parent = usage.getParent();
                while (parent instanceof PsiJavaCodeReferenceElement) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiImportStatement) {
                    return false;
                }
            }
            if (options instanceof JavaPackageFindUsagesOptions && ((JavaPackageFindUsagesOptions)options).isSkipPackageStatements) {
                parent = usage.getParent();
                while (parent instanceof PsiJavaCodeReferenceElement) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiPackageStatement) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected boolean isSearchForTextOccurencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "isSearchForTextOccurencesAvailable"));
        }
        if (isSingleFile) {
            return false;
        }
        return new JavaNonCodeSearchElementDescriptionProvider().getElementDescription(psiElement, NonCodeSearchDescriptionLocation.NON_JAVA) != null;
    }

    @Override
    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target, @NotNull SearchScope searchScope) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/JavaFindUsagesHandler", "findReferencesToHighlight"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/JavaFindUsagesHandler", "findReferencesToHighlight"));
        }
        if (target instanceof PsiMethod) {
            PsiMethod[] superMethods = ((PsiMethod)target).findDeepestSuperMethods();
            if (superMethods.length == 0) {
                return MethodReferencesSearch.search((PsiMethod)((PsiMethod)target), (SearchScope)searchScope, (boolean)true).findAll();
            }
            ArrayList<PsiReference> result = new ArrayList<PsiReference>();
            for (PsiMethod superMethod : superMethods) {
                result.addAll(MethodReferencesSearch.search((PsiMethod)superMethod, (SearchScope)searchScope, (boolean)true).findAll());
            }
            return result;
        }
        return super.findReferencesToHighlight(target, searchScope);
    }
}

