/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.CommonFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FindUsagesHandler {
    public static final FindUsagesHandler NULL_HANDLER = new FindUsagesHandler(PsiUtilCore.NULL_PSI_ELEMENT){};
    private final PsiElement myPsiElement;

    protected FindUsagesHandler(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/FindUsagesHandler", "<init>"));
        }
        this.myPsiElement = psiElement;
    }

    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        CommonFindUsagesDialog commonFindUsagesDialog = new CommonFindUsagesDialog(this.myPsiElement, this.getProject(), this.getFindUsagesOptions(DataManager.getInstance().getDataContext()), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        if (commonFindUsagesDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesHandler", "getFindUsagesDialog"));
        }
        return commonFindUsagesDialog;
    }

    @NotNull
    public final PsiElement getPsiElement() {
        PsiElement psiElement = this.myPsiElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesHandler", "getPsiElement"));
        }
        return psiElement;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.myPsiElement.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesHandler", "getProject"));
        }
        return project;
    }

    @NotNull
    public PsiElement[] getPrimaryElements() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myPsiElement};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesHandler", "getPrimaryElements"));
        }
        return psiElementArray;
    }

    @NotNull
    public PsiElement[] getSecondaryElements() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesHandler", "getSecondaryElements"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static FindUsagesOptions createFindUsagesOptions(Project project, @Nullable DataContext dataContext) {
        FindUsagesOptions findUsagesOptions = new FindUsagesOptions(project, dataContext);
        findUsagesOptions.isUsages = true;
        findUsagesOptions.isSearchForTextOccurrences = true;
        return findUsagesOptions;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions() {
        FindUsagesOptions findUsagesOptions = this.getFindUsagesOptions(null);
        if (findUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesHandler", "getFindUsagesOptions"));
        }
        return findUsagesOptions;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        FindUsagesOptions options = FindUsagesHandler.createFindUsagesOptions(this.getProject(), dataContext);
        options.isSearchForTextOccurrences &= this.isSearchForTextOccurencesAvailable(this.getPsiElement(), false);
        FindUsagesOptions findUsagesOptions = options;
        if (findUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/FindUsagesHandler", "getFindUsagesOptions"));
        }
        return findUsagesOptions;
    }

    public boolean processElementUsages(final @NotNull PsiElement element, final @NotNull Processor<UsageInfo> processor, @NotNull FindUsagesOptions options) {
        boolean success;
        boolean searchText;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/FindUsagesHandler", "processElementUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/FindUsagesHandler", "processElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/FindUsagesHandler", "processElementUsages"));
        }
        ReadActionProcessor<PsiReference> refProcessor = new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference ref) {
                TextRange rangeInElement = ref.getRangeInElement();
                return processor.process((Object)new UsageInfo(ref.getElement(), rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), false));
            }
        };
        final SearchScope scope = options.searchScope;
        boolean bl = searchText = options.isSearchForTextOccurrences && scope instanceof GlobalSearchScope;
        if (options.isUsages && !(success = ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters(element, scope, false, options.fastTrack)).forEach((Processor)refProcessor))) {
            return false;
        }
        if (searchText) {
            if (options.fastTrack != null) {
                options.fastTrack.searchCustom((Processor)new Processor<Processor<PsiReference>>(){

                    public boolean process(Processor<PsiReference> consumer) {
                        return FindUsagesHandler.this.processUsagesInText(element, (Processor<UsageInfo>)processor, (GlobalSearchScope)scope);
                    }
                });
            } else {
                return this.processUsagesInText(element, processor, (GlobalSearchScope)scope);
            }
        }
        return true;
    }

    public boolean processUsagesInText(final @NotNull PsiElement element, @NotNull Processor<UsageInfo> processor, @NotNull GlobalSearchScope searchScope) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/FindUsagesHandler", "processUsagesInText"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/FindUsagesHandler", "processUsagesInText"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/FindUsagesHandler", "processUsagesInText"));
        }
        Collection stringToSearch = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<Collection<String>>(){

            public Collection<String> compute() {
                return FindUsagesHandler.this.getStringsToSearch(element);
            }
        });
        if (stringToSearch == null) {
            return true;
        }
        final TextRange elementTextRange = (TextRange)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<TextRange>(){

            public TextRange compute() {
                if (!element.isValid()) {
                    return null;
                }
                return element.getTextRange();
            }
        });
        TextOccurrencesUtil.UsageInfoFactory factory = new TextOccurrencesUtil.UsageInfoFactory(){

            @Override
            public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                if (usage == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/FindUsagesHandler$6", "createUsageInfo"));
                }
                if (elementTextRange != null && usage.getContainingFile() == element.getContainingFile() && elementTextRange.contains(startOffset) && elementTextRange.contains(endOffset)) {
                    return null;
                }
                PsiReference someReference = usage.findReferenceAt(startOffset);
                if (someReference != null) {
                    PsiElement refElement = someReference.getElement();
                    for (PsiReference ref : PsiReferenceService.getService().getReferences(refElement, new PsiReferenceService.Hints(element, null))) {
                        if (!element.getManager().areElementsEquivalent(ref.resolve(), element)) continue;
                        TextRange range = ref.getRangeInElement().shiftRight(refElement.getTextRange().getStartOffset() - usage.getTextRange().getStartOffset());
                        return new UsageInfo(usage, range.getStartOffset(), range.getEndOffset(), true);
                    }
                }
                return new UsageInfo(usage, startOffset, endOffset, true);
            }
        };
        for (String s : stringToSearch) {
            if (TextOccurrencesUtil.processTextOccurences(element, s, searchScope, processor, factory)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    protected Collection<String> getStringsToSearch(final PsiElement element) {
        if (element instanceof PsiNamedElement) {
            return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<String>>(){

                public Collection<String> compute() {
                    return ContainerUtil.createMaybeSingletonList((Object)((PsiNamedElement)element).getName());
                }
            });
        }
        return Collections.singleton(element.getText());
    }

    protected boolean isSearchForTextOccurencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/FindUsagesHandler", "isSearchForTextOccurencesAvailable"));
        }
        return false;
    }

    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target, @NotNull SearchScope searchScope) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/FindUsagesHandler", "findReferencesToHighlight"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/FindUsagesHandler", "findReferencesToHighlight"));
        }
        return ReferencesSearch.search((PsiElement)target, (SearchScope)searchScope, (boolean)false).findAll();
    }
}

