/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.FindUsagesUtil;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageViewUtil;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CommonFindUsagesDialog
extends AbstractFindUsagesDialog {
    @NotNull
    protected final PsiElement myPsiElement;

    public CommonFindUsagesDialog(@NotNull PsiElement element, @NotNull Project project, @NotNull FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/CommonFindUsagesDialog", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/find/findUsages/CommonFindUsagesDialog", "<init>"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/find/findUsages/CommonFindUsagesDialog", "<init>"));
        }
        super(project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, CommonFindUsagesDialog.isTextSearch(element, isSingleFile, handler), !isSingleFile && !element.getManager().isInProject(element));
        this.myPsiElement = element;
        this.init();
    }

    private static boolean isTextSearch(PsiElement element, boolean isSingleFile, FindUsagesHandler handler) {
        return FindUsagesUtil.isSearchForTextOccurrencesAvailable(element, isSingleFile, handler);
    }

    @Override
    protected boolean isInFileOnly() {
        return super.isInFileOnly() || PsiSearchHelper.SERVICE.getInstance((Project)this.myPsiElement.getProject()).getUseScope(this.myPsiElement) instanceof LocalSearchScope;
    }

    @Override
    protected JPanel createFindWhatPanel() {
        return null;
    }

    @Override
    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        if (coloredComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/findUsages/CommonFindUsagesDialog", "configureLabelComponent"));
        }
        coloredComponent.append(StringUtil.capitalize((String)UsageViewUtil.getType(this.myPsiElement)));
        coloredComponent.append(" ");
        coloredComponent.append(DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myPsiElement), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(FindUsagesManager.getHelpID(this.myPsiElement));
    }
}

