/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.FrameworkLibraryProvider;
import com.intellij.facet.impl.ui.libraries.LibraryDownloadSettings;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryDependencyScopeSuggester;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryCompositionSettings
implements Disposable {
    private final CustomLibraryDescription myLibraryDescription;
    @NotNull
    private final NotNullComputable<String> myPathProvider;
    private FrameworkLibraryVersionFilter myVersionFilter;
    private final List<? extends FrameworkLibraryVersion> myAllVersions;
    private LibrariesContainer.LibraryLevel myNewLibraryLevel;
    private NewLibraryEditor myNewLibraryEditor;
    private Library mySelectedLibrary;
    private boolean myDownloadLibraries;
    private LibraryDownloadSettings myDownloadSettings;
    private Map<Library, ExistingLibraryEditor> myExistingLibraryEditors;
    private FrameworkLibraryProvider myLibraryProvider;

    public LibraryCompositionSettings(@NotNull CustomLibraryDescription libraryDescription, @NotNull NotNullComputable<String> pathProvider, @NotNull FrameworkLibraryVersionFilter versionFilter, List<? extends FrameworkLibraryVersion> allVersions) {
        if (libraryDescription == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings", "<init>"));
        }
        if (pathProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings", "<init>"));
        }
        if (versionFilter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings", "<init>"));
        }
        this.myExistingLibraryEditors = ContainerUtil.newIdentityTroveMap();
        this.myLibraryDescription = libraryDescription;
        this.myPathProvider = pathProvider;
        this.myVersionFilter = versionFilter;
        this.myNewLibraryLevel = libraryDescription.getDefaultLevel();
        this.myAllVersions = allVersions;
        List<? extends FrameworkLibraryVersion> versions = this.getCompatibleVersions();
        if (!versions.isEmpty()) {
            this.myDownloadSettings = this.createDownloadSettings(versions.get(0));
        }
    }

    private LibraryDownloadSettings createDownloadSettings(FrameworkLibraryVersion version) {
        return new LibraryDownloadSettings(version, this.myLibraryDescription.getDownloadableLibraryType(), this.myNewLibraryLevel, LibraryCompositionSettings.getDefaultDownloadPath(this.getBaseDirectoryPath()));
    }

    public void setVersionFilter(@NotNull FrameworkLibraryVersionFilter versionFilter) {
        if (versionFilter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings", "setVersionFilter"));
        }
        this.myVersionFilter = versionFilter;
        if (this.myDownloadSettings == null || !versionFilter.isAccepted(this.myDownloadSettings.getVersion())) {
            FrameworkLibraryVersion newLibraryVersion = (FrameworkLibraryVersion)ContainerUtil.getFirstItem(this.getCompatibleVersions());
            this.myDownloadSettings = newLibraryVersion != null ? this.createDownloadSettings(newLibraryVersion) : null;
        }
    }

    public List<? extends FrameworkLibraryVersion> getCompatibleVersions() {
        ArrayList<FrameworkLibraryVersion> result = new ArrayList<FrameworkLibraryVersion>();
        for (FrameworkLibraryVersion frameworkLibraryVersion : this.myAllVersions) {
            if (!this.myVersionFilter.isAccepted(frameworkLibraryVersion)) continue;
            result.add(frameworkLibraryVersion);
        }
        return result;
    }

    private static String getDefaultDownloadPath(@NotNull String baseDirectoryPath) {
        if (baseDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings", "getDefaultDownloadPath"));
        }
        return baseDirectoryPath.isEmpty() ? "lib" : baseDirectoryPath + "/lib";
    }

    public void setDownloadSettings(LibraryDownloadSettings downloadSettings) {
        this.myDownloadSettings = downloadSettings;
    }

    public ExistingLibraryEditor getOrCreateEditor(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings", "getOrCreateEditor"));
        }
        ExistingLibraryEditor libraryEditor = this.myExistingLibraryEditors.get(library);
        if (libraryEditor == null) {
            libraryEditor = new ExistingLibraryEditor(library, null);
            Disposer.register((Disposable)this, (Disposable)libraryEditor);
            this.myExistingLibraryEditors.put(library, libraryEditor);
        }
        return libraryEditor;
    }

    @NotNull
    public CustomLibraryDescription getLibraryDescription() {
        CustomLibraryDescription customLibraryDescription = this.myLibraryDescription;
        if (customLibraryDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings", "getLibraryDescription"));
        }
        return customLibraryDescription;
    }

    @Nullable
    public LibraryDownloadSettings getDownloadSettings() {
        return this.myDownloadSettings;
    }

    @NotNull
    public String getBaseDirectoryPath() {
        String string = (String)this.myPathProvider.compute();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings", "getBaseDirectoryPath"));
        }
        return string;
    }

    public void setDownloadLibraries(boolean downloadLibraries) {
        this.myDownloadLibraries = downloadLibraries;
    }

    public void setSelectedExistingLibrary(@Nullable Library library) {
        this.mySelectedLibrary = library;
    }

    public void setNewLibraryLevel(LibrariesContainer.LibraryLevel newLibraryLevel) {
        this.myNewLibraryLevel = newLibraryLevel;
    }

    public boolean downloadFiles(@NotNull JComponent parent) {
        NewLibraryEditor libraryEditor;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings", "downloadFiles"));
        }
        if (this.myDownloadLibraries && this.myDownloadSettings != null && (libraryEditor = this.myDownloadSettings.download(parent, this.getBaseDirectoryPath())) != null) {
            this.myNewLibraryEditor = libraryEditor;
        }
        return true;
    }

    @Nullable
    private Library createLibrary(ModifiableRootModel rootModel, @Nullable LibrariesContainer additionalContainer) {
        if (this.myNewLibraryEditor != null) {
            return LibrariesContainerFactory.createLibrary(additionalContainer, LibrariesContainerFactory.createContainer(rootModel), this.myNewLibraryEditor, this.getLibraryLevel());
        }
        return null;
    }

    private LibrariesContainer.LibraryLevel getLibraryLevel() {
        return this.myDownloadLibraries ? this.myDownloadSettings.getLibraryLevel() : this.myNewLibraryLevel;
    }

    public LibrariesContainer.LibraryLevel getNewLibraryLevel() {
        return this.myNewLibraryLevel;
    }

    @Nullable
    public Library addLibraries(@NotNull ModifiableRootModel rootModel, @NotNull List<Library> addedLibraries, @Nullable LibrariesContainer librariesContainer) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings", "addLibraries"));
        }
        if (addedLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings", "addLibraries"));
        }
        Library newLibrary = this.createLibrary(rootModel, librariesContainer);
        if (newLibrary != null) {
            addedLibraries.add(newLibrary);
            DependencyScope scope = LibraryDependencyScopeSuggester.getDefaultScope(newLibrary);
            if (this.getLibraryLevel() != LibrariesContainer.LibraryLevel.MODULE) {
                rootModel.addLibraryEntry(newLibrary).setScope(scope);
            } else {
                LibraryOrderEntry orderEntry = rootModel.findLibraryOrderEntry(newLibrary);
                assert (orderEntry != null);
                orderEntry.setScope(scope);
            }
        }
        if (this.mySelectedLibrary != null) {
            addedLibraries.add(this.mySelectedLibrary);
            rootModel.addLibraryEntry(this.mySelectedLibrary).setScope(LibraryDependencyScopeSuggester.getDefaultScope(this.mySelectedLibrary));
        }
        if (this.myLibraryProvider != null) {
            Library library = this.myLibraryProvider.createLibrary(this.myLibraryDescription.getSuitableLibraryKinds());
            addedLibraries.add(library);
            rootModel.addLibraryEntry(library).setScope(LibraryDependencyScopeSuggester.getDefaultScope(library));
        }
        return newLibrary;
    }

    public void setNewLibraryEditor(@Nullable NewLibraryEditor libraryEditor) {
        this.myNewLibraryEditor = libraryEditor;
    }

    public void setLibraryProvider(FrameworkLibraryProvider libraryProvider) {
        this.myLibraryProvider = libraryProvider;
    }

    public void dispose() {
    }
}

