/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.FacetEditorContextBase;
import com.intellij.facet.impl.ui.libraries.LibrariesValidatorContext;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegatingLibrariesValidatorContext
implements LibrariesValidatorContext {
    private final FacetEditorContext myDelegate;

    public DelegatingLibrariesValidatorContext(@NotNull FacetEditorContext delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/facet/impl/ui/libraries/DelegatingLibrariesValidatorContext", "<init>"));
        }
        this.myDelegate = delegate;
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myDelegate.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/libraries/DelegatingLibrariesValidatorContext", "getModule"));
        }
        return module;
    }

    @Override
    public LibrariesContainer getLibrariesContainer() {
        return ((FacetEditorContextBase)this.myDelegate).getContainer();
    }

    @Override
    @NotNull
    public ModulesProvider getModulesProvider() {
        ModulesProvider modulesProvider = this.myDelegate.getModulesProvider();
        if (modulesProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/libraries/DelegatingLibrariesValidatorContext", "getModulesProvider"));
        }
        return modulesProvider;
    }

    @Override
    @Nullable
    public ModifiableRootModel getModifiableRootModel() {
        return this.myDelegate.getModifiableRootModel();
    }

    @Override
    @NotNull
    public ModuleRootModel getRootModel() {
        ModuleRootModel moduleRootModel = this.myDelegate.getRootModel();
        if (moduleRootModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/libraries/DelegatingLibrariesValidatorContext", "getRootModel"));
        }
        return moduleRootModel;
    }
}

