/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.impl.AbstractTab;
import com.intellij.util.xmlb.XmlSerializer;
import javax.swing.Icon;
import org.jdom.Element;

public class TabImpl
extends AbstractTab
implements Tab {
    public TabImpl(Element element) {
        this.read(element);
    }

    public void read(Element element) {
        XmlSerializer.deserializeInto((Object)this, (Element)element);
    }

    TabImpl() {
    }

    public int getIndex() {
        return this.myIndex;
    }

    public int getDefaultIndex() {
        return this.myDefaultIndex >= 0 ? this.myDefaultIndex : this.myIndex;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIndex(int index) {
        this.myIndex = index;
    }

    public void setDefaultIndex(int index) {
        this.myDefaultIndex = index;
    }

    public void setDisplayName(String displayName) {
        this.myDisplayName = displayName;
    }

    public void write(Element parentNode) {
        Element element = XmlSerializer.serialize((Object)this);
        parentNode.addContent(element);
    }

    public float getLeftProportion() {
        return this.myLeftProportion;
    }

    public void setLeftProportion(float leftProportion) {
        if (leftProportion < 0.0f || (double)leftProportion > 1.0) {
            return;
        }
        this.myLeftProportion = leftProportion;
    }

    public float getRightProportion() {
        return this.myRightProportion;
    }

    public void setRightProportion(float rightProportion) {
        if (rightProportion < 0.0f || (double)rightProportion > 1.0) {
            return;
        }
        this.myRightProportion = rightProportion;
    }

    public float getBottomProportion() {
        return this.myBottomProportion;
    }

    public void setBottomProportion(float bottomProportion) {
        if (bottomProportion < 0.0f || (double)bottomProportion > 1.0) {
            return;
        }
        this.myBottomProportion = bottomProportion;
    }

    public boolean isLeftDetached() {
        return this.myLeftDetached;
    }

    public void setLeftDetached(boolean leftDetached) {
        this.myLeftDetached = leftDetached;
    }

    public boolean isCenterDetached() {
        return this.myCenterDetached;
    }

    public void setCenterDetached(boolean centerDetached) {
        this.myCenterDetached = centerDetached;
    }

    public boolean isRightDetached() {
        return this.myRightDetached;
    }

    public void setRightDetached(boolean rightDetached) {
        this.myRightDetached = rightDetached;
    }

    public boolean isBottomDetached() {
        return this.myBottomDetached;
    }

    public void setBottomDetached(boolean bottomDetached) {
        this.myBottomDetached = bottomDetached;
    }

    public boolean isDefault() {
        return this.myIndex == 0;
    }

    public boolean isDetached(PlaceInGrid place) {
        switch (place) {
            case bottom: {
                return this.isBottomDetached();
            }
            case center: {
                return this.isCenterDetached();
            }
            case left: {
                return this.isLeftDetached();
            }
            case right: {
                return this.isRightDetached();
            }
        }
        return false;
    }

    public void setDetached(PlaceInGrid place, boolean detached) {
        switch (place) {
            case bottom: {
                this.setBottomDetached(detached);
                break;
            }
            case center: {
                this.setCenterDetached(detached);
                break;
            }
            case left: {
                this.setLeftDetached(detached);
                break;
            }
            case right: {
                this.setRightDetached(detached);
            }
        }
    }

    public static class Default
    extends AbstractTab {
        public Default(int index, String displayName, Icon icon) {
            this.myIndex = index;
            this.myDefaultIndex = index;
            this.myDisplayName = displayName;
            this.myIcon = icon;
        }

        public TabImpl createTab() {
            TabImpl tab = new TabImpl();
            tab.copyFrom(this);
            return tab;
        }
    }
}

