/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentListener;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.execution.ui.layout.impl.DockableGridContainerFactory;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentManagerImpl
implements RunContentManager,
Disposable {
    public static final Topic<RunContentWithExecutorListener> RUN_CONTENT_TOPIC = Topic.create((String)"Run Content", RunContentWithExecutorListener.class);
    public static final Key<Boolean> ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY = Key.create((String)"ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.ui.RunContentManagerImpl");
    private static final Key<RunContentDescriptor> DESCRIPTOR_KEY = new Key("Descriptor");
    private final Project myProject;
    private DockableGridContainerFactory myContentFactory;
    private final Map<String, ContentManager> myToolwindowIdToContentManagerMap = new HashMap();
    private final Map<RunContentListener, Disposable> myListeners = new HashMap();
    private final LinkedList<String> myToolwindowIdZbuffer = new LinkedList();

    public RunContentManagerImpl(Project project, DockManager dockManager) {
        this.myProject = project;
        this.myContentFactory = new DockableGridContainerFactory();
        dockManager.register("runner-grid", (DockContainerFactory)this.myContentFactory);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myContentFactory);
    }

    public void init() {
        Executor[] executors;
        for (Executor executor : executors = ExecutorRegistry.getInstance().getRegisteredExecutors()) {
            this.registerToolwindow(executor);
        }
        if (ToolWindowManager.getInstance((Project)this.myProject) == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RunContentManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject)).addToolWindowManagerListener(new ToolWindowManagerAdapter(){

                    @Override
                    public void stateChanged() {
                        if (RunContentManagerImpl.this.myProject.isDisposed()) {
                            return;
                        }
                        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject);
                        HashSet currentWindows = new HashSet();
                        Object[] toolWindowIds = toolWindowManager.getToolWindowIds();
                        ContainerUtil.addAll(currentWindows, (Object[])toolWindowIds);
                        RunContentManagerImpl.this.myToolwindowIdZbuffer.retainAll(currentWindows);
                        String activeToolWindowId = toolWindowManager.getActiveToolWindowId();
                        if (activeToolWindowId != null && RunContentManagerImpl.this.myToolwindowIdZbuffer.remove(activeToolWindowId)) {
                            RunContentManagerImpl.this.myToolwindowIdZbuffer.addFirst(activeToolWindowId);
                        }
                    }
                });
            }
        });
    }

    public void dispose() {
    }

    private void unregisterToolwindow(String id) {
        ContentManager manager = this.myToolwindowIdToContentManagerMap.get(id);
        manager.removeAllContents(true);
        this.myToolwindowIdToContentManagerMap.remove(id);
        this.myToolwindowIdZbuffer.remove(id);
    }

    private void registerToolwindow(final @NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl", "registerToolwindow"));
        }
        final String toolWindowId = executor.getToolWindowId();
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        if (toolWindowManager.getToolWindow(toolWindowId) != null) {
            return;
        }
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(toolWindowId, true, ToolWindowAnchor.BOTTOM, (Disposable)this, true);
        final ContentManager contentManager = toolWindow.getContentManager();
        class MyDataProvider
        implements DataProvider {
            private int myInsideGetData = 0;

            MyDataProvider() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getData(String dataId) {
                ++this.myInsideGetData;
                try {
                    if (PlatformDataKeys.HELP_ID.is(dataId)) {
                        String string = executor.getHelpId();
                        return string;
                    }
                    Object object = this.myInsideGetData == 1 ? DataManager.getInstance().getDataContext((Component)contentManager.getComponent()).getData(dataId) : null;
                    return object;
                }
                finally {
                    --this.myInsideGetData;
                }
            }
        }
        contentManager.addDataProvider((DataProvider)new MyDataProvider());
        toolWindow.setIcon(executor.getToolWindowIcon());
        new ContentManagerWatcher(toolWindow, contentManager);
        contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                Content content = event.getContent();
                RunContentDescriptor descriptor = content != null ? RunContentManagerImpl.getRunContentDescriptorByContent(content) : null;
                RunContentManagerImpl.this.getSyncPublisher().contentSelected(descriptor, executor);
            }
        });
        this.myToolwindowIdToContentManagerMap.put(toolWindowId, contentManager);
        Disposer.register((Disposable)contentManager, (Disposable)new Disposable(){

            public void dispose() {
                RunContentManagerImpl.this.unregisterToolwindow(toolWindowId);
            }
        });
        this.myToolwindowIdZbuffer.addLast(toolWindowId);
    }

    private RunContentWithExecutorListener getSyncPublisher() {
        return (RunContentWithExecutorListener)this.myProject.getMessageBus().syncPublisher(RUN_CONTENT_TOPIC);
    }

    public void toFrontRunContent(Executor requestor, ProcessHandler handler) {
        RunContentDescriptor descriptor = this.getDescriptorBy(handler, requestor);
        if (descriptor == null) {
            return;
        }
        this.toFrontRunContent(requestor, descriptor);
    }

    public void toFrontRunContent(final Executor requestor, final RunContentDescriptor descriptor) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ContentManager contentManager = RunContentManagerImpl.this.getContentManagerForRunner(requestor);
                Content content = RunContentManagerImpl.getRunContentByDescriptor(contentManager, descriptor);
                if (contentManager != null && content != null) {
                    contentManager.setSelectedContent(content);
                    ToolWindow toolWindow = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject).getToolWindow(requestor.getToolWindowId());
                    toolWindow.show(null);
                }
            }
        });
    }

    public void hideRunContent(final @NotNull Executor executor, RunContentDescriptor descriptor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl", "hideRunContent"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!RunContentManagerImpl.this.myProject.isDisposed()) {
                    String toolWindowId = executor.getToolWindowId();
                    ToolWindow toolWindow = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject).getToolWindow(toolWindowId);
                    if (toolWindow != null) {
                        toolWindow.hide(null);
                    }
                }
            }
        });
    }

    @Nullable
    public RunContentDescriptor getSelectedContent(Executor executor) {
        RunContentDescriptor runContentDescriptorByContent;
        Content selectedContent;
        ContentManager contentManager = this.getContentManagerForRunner(executor);
        if (contentManager != null && (selectedContent = contentManager.getSelectedContent()) != null && (runContentDescriptorByContent = RunContentManagerImpl.getRunContentDescriptorByContent(selectedContent)) != null) {
            return runContentDescriptorByContent;
        }
        return null;
    }

    @Nullable
    public RunContentDescriptor getSelectedContent() {
        for (String activeWindow : this.myToolwindowIdZbuffer) {
            ContentManager contentManager = this.myToolwindowIdToContentManagerMap.get(activeWindow);
            if (contentManager == null) continue;
            Content selectedContent = contentManager.getSelectedContent();
            if (selectedContent == null) {
                if (contentManager.getContentCount() != 0) break;
                continue;
            }
            return RunContentManagerImpl.getRunContentDescriptorByContent(selectedContent);
        }
        return null;
    }

    public boolean removeRunContent(@NotNull Executor executor, RunContentDescriptor descriptor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl", "removeRunContent"));
        }
        ContentManager contentManager = this.getContentManagerForRunner(executor);
        Content content = RunContentManagerImpl.getRunContentByDescriptor(contentManager, descriptor);
        return content != null && contentManager.removeContent(content, true);
    }

    public void showRunContent(@NotNull Executor executor, RunContentDescriptor descriptor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl", "showRunContent"));
        }
        this.showRunContent(executor, descriptor, descriptor != null ? descriptor.getExecutionId() : 0L);
    }

    public void showRunContent(final @NotNull Executor executor, final RunContentDescriptor descriptor, long executionId) {
        Content content;
        Content oldAttachedContent;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl", "showRunContent"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ContentManager contentManager = this.getContentManagerForRunner(executor);
        RunContentDescriptor oldDescriptor = RunContentManagerImpl.chooseReuseContentForDescriptor(contentManager, descriptor, executionId, descriptor != null ? descriptor.getDisplayName() : null);
        Content content2 = oldAttachedContent = oldDescriptor != null ? oldDescriptor.getAttachedContent() : null;
        if (oldDescriptor != null) {
            content = oldAttachedContent;
            this.getSyncPublisher().contentRemoved(oldDescriptor, executor);
            Disposer.dispose((Disposable)oldDescriptor);
        } else if (oldAttachedContent == null || !oldAttachedContent.isValid()) {
            content = this.createNewContent(contentManager, descriptor, executor);
            Icon icon = descriptor.getIcon();
            content.setIcon(icon == null ? executor.getToolWindowIcon() : icon);
        } else {
            content = oldAttachedContent;
        }
        content.setExecutionId(executionId);
        content.setComponent(descriptor.getComponent());
        content.setPreferredFocusedComponent(descriptor.getPreferredFocusComputable());
        content.putUserData(DESCRIPTOR_KEY, (Object)descriptor);
        final ProcessHandler processHandler = descriptor.getProcessHandler();
        if (processHandler != null) {
            final ProcessAdapter processAdapter = new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    LaterInvocator.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Icon icon = descriptor.getIcon();
                            content.setIcon(icon == null ? executor.getToolWindowIcon() : icon);
                        }
                    });
                }

                public void processTerminated(ProcessEvent event) {
                    LaterInvocator.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Icon icon = descriptor.getIcon();
                            content.setIcon(icon == null ? executor.getDisabledIcon() : IconLoader.getTransparentIcon((Icon)icon));
                        }
                    });
                }
            };
            processHandler.addProcessListener((ProcessListener)processAdapter);
            Disposable disposer = content.getDisposer();
            if (disposer != null) {
                Disposer.register((Disposable)disposer, (Disposable)new Disposable(){

                    public void dispose() {
                        processHandler.removeProcessListener((ProcessListener)processAdapter);
                    }
                });
            }
        }
        content.setDisplayName(descriptor.getDisplayName());
        descriptor.setAttachedContent(content);
        content.getManager().setSelectedContent(content);
        if (!descriptor.isActivateToolWindowWhenAdded()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RunContentManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindow window = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject).getToolWindow(executor.getToolWindowId());
                descriptor.getPreferredFocusComputable();
                window.activate(null, descriptor.isAutoFocusContent(), descriptor.isAutoFocusContent());
            }
        });
    }

    @Deprecated
    @Nullable
    public RunContentDescriptor getReuseContent(Executor requestor, DataContext dataContext) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return this.getReuseContent(requestor, (RunContentDescriptor)GenericProgramRunner.CONTENT_TO_REUSE_DATA_KEY.getData(dataContext));
    }

    @Deprecated
    @Nullable
    public RunContentDescriptor getReuseContent(Executor requestor, @Nullable RunContentDescriptor contentToReuse) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (contentToReuse != null) {
            return contentToReuse;
        }
        ContentManager contentManager = this.getContentManagerForRunner(requestor);
        return RunContentManagerImpl.chooseReuseContentForDescriptor(contentManager, contentToReuse, 0L, null);
    }

    @Nullable
    public RunContentDescriptor getReuseContent(Executor requestor, @NotNull ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ui/RunContentManagerImpl", "getReuseContent"));
        }
        return this.getReuseContent(executionEnvironment);
    }

    @Nullable
    public RunContentDescriptor getReuseContent(@NotNull ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl", "getReuseContent"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        RunContentDescriptor contentToReuse = executionEnvironment.getContentToReuse();
        if (contentToReuse != null) {
            return contentToReuse;
        }
        ContentManager contentManager = this.getContentManagerForRunner(executionEnvironment.getExecutor());
        return RunContentManagerImpl.chooseReuseContentForDescriptor(contentManager, contentToReuse, executionEnvironment.getExecutionId(), executionEnvironment.toString());
    }

    public RunContentDescriptor findContentDescriptor(Executor requestor, ProcessHandler handler) {
        return this.getDescriptorBy(handler, requestor);
    }

    public void showRunContent(@NotNull Executor info, RunContentDescriptor descriptor, RunContentDescriptor contentToReuse) {
        Content attachedContent;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl", "showRunContent"));
        }
        if (contentToReuse != null && (attachedContent = contentToReuse.getAttachedContent()).getManager() != null) {
            descriptor.setAttachedContent(attachedContent);
        }
        this.showRunContent(info, descriptor, descriptor != null ? descriptor.getExecutionId() : 0L);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static RunContentDescriptor chooseReuseContentForDescriptor(@NotNull ContentManager contentManager, @Nullable RunContentDescriptor descriptor, long executionId, @Nullable String string) {
        if (contentManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl", "chooseReuseContentForDescriptor"));
        }
        Content content = null;
        if (descriptor != null) {
            if (descriptor.isContentReuseProhibited()) {
                return null;
            }
            Content attachedContent = descriptor.getAttachedContent();
            if (attachedContent != null && attachedContent.isValid() && contentManager.getIndexOfContent(attachedContent) != -1) {
                content = attachedContent;
            }
        }
        if (content == null) {
            void preferredName;
            content = RunContentManagerImpl.getContentFromManager(contentManager, (String)preferredName, executionId);
        }
        if (content == null || !RunContentManagerImpl.isTerminated(content) || content.getExecutionId() == executionId && executionId != 0L) {
            return null;
        }
        RunContentDescriptor oldDescriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
        if (oldDescriptor != null && !oldDescriptor.isContentReuseProhibited()) {
            return oldDescriptor;
        }
        return null;
    }

    @Nullable
    private static Content getContentFromManager(ContentManager contentManager, @Nullable String preferredName, long executionId) {
        ArrayList<Content> contents = new ArrayList<Content>(Arrays.asList(contentManager.getContents()));
        Content first = contentManager.getSelectedContent();
        if (first != null && contents.remove(first)) {
            contents.add(0, first);
        }
        if (preferredName != null) {
            for (Content c : contents) {
                if (!RunContentManagerImpl.canReuseContent(c, executionId) || !preferredName.equals(c.getDisplayName())) continue;
                return c;
            }
        }
        for (Content c : contents) {
            if (!RunContentManagerImpl.canReuseContent(c, executionId)) continue;
            return c;
        }
        return null;
    }

    private static boolean canReuseContent(Content c, long executionId) {
        return c != null && !c.isPinned() && RunContentManagerImpl.isTerminated(c) && (c.getExecutionId() != executionId || executionId == 0L);
    }

    @NotNull
    private ContentManager getContentManagerForRunner(Executor executor) {
        ContentManager contentManager = this.myToolwindowIdToContentManagerMap.get(executor.getToolWindowId());
        if (contentManager == null) {
            LOG.error("Runner " + executor.getId() + " is not registered");
        }
        ContentManager contentManager2 = contentManager;
        if (contentManager2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/RunContentManagerImpl", "getContentManagerForRunner"));
        }
        return contentManager2;
    }

    private Content createNewContent(ContentManager contentManager, RunContentDescriptor descriptor, Executor executor) {
        String processDisplayName = descriptor.getDisplayName();
        Content content = ContentFactory.SERVICE.getInstance().createContent(descriptor.getComponent(), processDisplayName, true);
        content.putUserData(DESCRIPTOR_KEY, (Object)descriptor);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        contentManager.addContent(content);
        new CloseListener(content, executor);
        return content;
    }

    private static boolean isTerminated(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl", "isTerminated"));
        }
        RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
        if (descriptor == null) {
            return true;
        }
        ProcessHandler processHandler = descriptor.getProcessHandler();
        return processHandler == null || processHandler.isProcessTerminated();
    }

    @Nullable
    public static RunContentDescriptor getRunContentDescriptorByContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl", "getRunContentDescriptorByContent"));
        }
        return (RunContentDescriptor)content.getUserData(DESCRIPTOR_KEY);
    }

    @Nullable
    public ToolWindow getToolWindowByDescriptor(@NotNull RunContentDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl", "getToolWindowByDescriptor"));
        }
        for (Map.Entry<String, ContentManager> entry : this.myToolwindowIdToContentManagerMap.entrySet()) {
            if (RunContentManagerImpl.getRunContentByDescriptor(entry.getValue(), descriptor) == null) continue;
            return ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(entry.getKey());
        }
        return null;
    }

    @Nullable
    private static Content getRunContentByDescriptor(ContentManager contentManager, RunContentDescriptor descriptor) {
        Content[] contents;
        for (Content content : contents = contentManager.getContents()) {
            if (!descriptor.equals(content.getUserData(DESCRIPTOR_KEY))) continue;
            return content;
        }
        return null;
    }

    public void addRunContentListener(final RunContentListener listener, final Executor executor) {
        Disposable disposable = Disposer.newDisposable();
        this.myProject.getMessageBus().connect(disposable).subscribe(RUN_CONTENT_TOPIC, (Object)new RunContentWithExecutorListener(){

            @Override
            public void contentSelected(RunContentDescriptor descriptor, @NotNull Executor executor2) {
                if (executor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ui/RunContentManagerImpl$9", "contentSelected"));
                }
                if (executor2.equals(executor)) {
                    listener.contentSelected(descriptor);
                }
            }

            @Override
            public void contentRemoved(RunContentDescriptor descriptor, @NotNull Executor executor2) {
                if (executor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ui/RunContentManagerImpl$9", "contentRemoved"));
                }
                if (executor2.equals(executor)) {
                    listener.contentRemoved(descriptor);
                }
            }
        });
        this.myListeners.put(listener, disposable);
    }

    public void addRunContentListener(final RunContentListener listener) {
        Disposable disposable = Disposer.newDisposable();
        this.myProject.getMessageBus().connect(disposable).subscribe(RUN_CONTENT_TOPIC, (Object)new RunContentWithExecutorListener(){

            @Override
            public void contentSelected(RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ui/RunContentManagerImpl$10", "contentSelected"));
                }
                listener.contentSelected(descriptor);
            }

            @Override
            public void contentRemoved(RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ui/RunContentManagerImpl$10", "contentRemoved"));
                }
                listener.contentRemoved(descriptor);
            }
        });
        this.myListeners.put(listener, disposable);
    }

    @NotNull
    public List<RunContentDescriptor> getAllDescriptors() {
        if (this.myToolwindowIdToContentManagerMap.isEmpty()) {
            List<RunContentDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/RunContentManagerImpl", "getAllDescriptors"));
            }
            return list;
        }
        String[] ids = this.myToolwindowIdToContentManagerMap.keySet().toArray(new String[this.myToolwindowIdToContentManagerMap.size()]);
        ArrayList<RunContentDescriptor> descriptors = new ArrayList<RunContentDescriptor>();
        for (String id : ids) {
            ContentManager contentManager = this.myToolwindowIdToContentManagerMap.get(id);
            for (Content content : contentManager.getContents()) {
                RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
                if (descriptor == null) continue;
                descriptors.add(descriptor);
            }
        }
        ArrayList<RunContentDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/RunContentManagerImpl", "getAllDescriptors"));
        }
        return arrayList;
    }

    public void removeRunContentListener(RunContentListener listener) {
        Disposable disposable = this.myListeners.remove(listener);
        if (disposable != null) {
            Disposer.dispose((Disposable)disposable);
        }
    }

    @Nullable
    private RunContentDescriptor getDescriptorBy(ProcessHandler handler, Executor runnerInfo) {
        Content[] contents;
        ContentManager contentManager = this.getContentManagerForRunner(runnerInfo);
        for (Content content : contents = contentManager.getContents()) {
            RunContentDescriptor runContentDescriptor = (RunContentDescriptor)content.getUserData(DESCRIPTOR_KEY);
            if (runContentDescriptor.getProcessHandler() != handler) continue;
            return runContentDescriptor;
        }
        return null;
    }

    private void waitForProcess(final RunContentDescriptor descriptor, final boolean modal) {
        final ProcessHandler processHandler = descriptor.getProcessHandler();
        final boolean killable = !modal && processHandler instanceof KillableProcess && ((KillableProcess)processHandler).canKillProcess();
        String title = ExecutionBundle.message((String)"terminating.process.progress.title", (Object[])new Object[]{descriptor.getDisplayName()});
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title, true){
            {
                super(x0, x1, x2);
                if (killable) {
                    String cancelText = ExecutionBundle.message((String)"terminating.process.progress.kill", (Object[])new Object[0]);
                    this.setCancelText(cancelText);
                    this.setCancelTooltipText(cancelText);
                }
            }

            public boolean isConditionalModal() {
                return modal;
            }

            public boolean shouldStartInBackground() {
                return !modal;
            }

            public void run(final @NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl$11", "run"));
                }
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProcessHandler processHandler = descriptor.getProcessHandler();
                        try {
                            if (processHandler != null) {
                                processHandler.waitFor();
                            }
                        }
                        finally {
                            semaphore.up();
                        }
                    }
                });
                progressIndicator.setText(ExecutionBundle.message((String)"waiting.for.vm.detach.progress.text", (Object[])new Object[0]));
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            if (progressIndicator.isCanceled() || !progressIndicator.isRunning()) break;
                            try {
                                2 var1_1 = this;
                                synchronized (var1_1) {
                                    this.wait(2000L);
                                    continue;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                        semaphore.up();
                    }
                });
                semaphore.waitFor();
            }

            public void onCancel() {
                if (killable && !processHandler.isProcessTerminated()) {
                    ((KillableProcess)processHandler).killProcess();
                }
            }
        });
    }

    private class CloseListener
    extends ContentManagerAdapter
    implements ProjectManagerListener {
        private Content myContent;
        private final Executor myExecutor;

        private CloseListener(@NotNull Content content, Executor executor) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/RunContentManagerImpl$CloseListener", "<init>"));
            }
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ui/RunContentManagerImpl$CloseListener", "<init>"));
            }
            this.myContent = content;
            content.getManager().addContentManagerListener((ContentManagerListener)this);
            ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)this);
            this.myExecutor = executor;
        }

        public void contentRemoved(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content == this.myContent) {
                this.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            if (this.myContent == null) {
                return;
            }
            Content content = this.myContent;
            try {
                RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
                RunContentManagerImpl.this.getSyncPublisher().contentRemoved(descriptor, this.myExecutor);
                if (descriptor != null) {
                    Disposer.dispose((Disposable)descriptor);
                }
            }
            finally {
                content.getManager().removeContentManagerListener((ContentManagerListener)this);
                ProjectManager.getInstance().removeProjectManagerListener((ProjectManagerListener)this);
                content.release();
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            boolean canClose;
            if (event.getContent() == this.myContent && !(canClose = this.closeQuery(false))) {
                event.consume();
            }
        }

        public void projectOpened(Project project) {
        }

        public void projectClosed(Project project) {
            if (this.myContent != null && project == RunContentManagerImpl.this.myProject) {
                this.myContent.getManager().removeContent(this.myContent, true);
                this.dispose();
            }
        }

        public boolean canCloseProject(Project project) {
            if (project != RunContentManagerImpl.this.myProject) {
                return true;
            }
            if (this.myContent == null) {
                return true;
            }
            boolean canClose = this.closeQuery(true);
            if (canClose) {
                this.myContent.getManager().removeContent(this.myContent, true);
                this.myContent = null;
            }
            return canClose;
        }

        public void projectClosing(Project project) {
        }

        private boolean closeQuery(boolean modal) {
            boolean destroyProcess;
            RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(this.myContent);
            if (descriptor == null) {
                return true;
            }
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler == null || processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) {
                return true;
            }
            if (processHandler.isSilentlyDestroyOnClose() || Boolean.TRUE.equals(processHandler.getUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE))) {
                destroyProcess = true;
            } else {
                boolean useDefault = Boolean.TRUE.equals(processHandler.getUserData(ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY));
                TerminateRemoteProcessDialog.TerminateOption option = new TerminateRemoteProcessDialog.TerminateOption(processHandler.detachIsDefault(), useDefault);
                int rc = TerminateRemoteProcessDialog.show(RunContentManagerImpl.this.myProject, descriptor.getDisplayName(), option);
                if (rc != 0) {
                    return false;
                }
                boolean bl = destroyProcess = !option.isToBeShown();
            }
            if (destroyProcess) {
                processHandler.destroyProcess();
            } else {
                processHandler.detachProcess();
            }
            RunContentManagerImpl.this.waitForProcess(descriptor, modal);
            return true;
        }
    }
}

