/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.MacroAwareTextBrowseFolderListener;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonProgramParametersPanel
extends JPanel
implements PanelWithAnchor {
    private LabeledComponent<RawCommandLineEditor> myProgramParametersComponent;
    private LabeledComponent<JComponent> myWorkingDirectoryComponent;
    protected TextFieldWithBrowseButton myWorkingDirectoryField;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    protected JComponent myAnchor;
    private Module myModuleContext = null;

    public CommonProgramParametersPanel() {
        this(true);
    }

    public CommonProgramParametersPanel(boolean init) {
        this.setLayout((LayoutManager)new VerticalFlowLayout(1, 0, 5, true, false));
        if (init) {
            this.init();
        }
    }

    protected void init() {
        this.initComponents();
        this.copyDialogCaption(this.myProgramParametersComponent);
        this.updateUI();
    }

    @Nullable
    protected Project getProject() {
        return this.myModuleContext != null ? this.myModuleContext.getProject() : null;
    }

    protected void initComponents() {
        this.myProgramParametersComponent = LabeledComponent.create((JComponent)new RawCommandLineEditor(), (String)ExecutionBundle.message((String)"run.configuration.program.parameters", (Object[])new Object[0]));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fileChooserDescriptor.setTitle(ExecutionBundle.message((String)"select.working.directory.message", (Object[])new Object[0]));
        this.myWorkingDirectoryField = new TextFieldWithBrowseButton();
        this.myWorkingDirectoryField.addBrowseFolderListener((TextBrowseFolderListener)new MacroAwareTextBrowseFolderListener(fileChooserDescriptor, this.getProject()){

            public void actionPerformed(ActionEvent e) {
                this.myFileChooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)CommonProgramParametersPanel.this.myModuleContext);
                this.setProject(this.getProject());
                super.actionPerformed(e);
            }
        });
        this.myWorkingDirectoryComponent = LabeledComponent.create((JComponent)this.createComponentWithMacroBrowse(this.myWorkingDirectoryField), (String)ExecutionBundle.message((String)"run.configuration.working.directory.label", (Object[])new Object[0]));
        this.myEnvVariablesComponent = new EnvironmentVariablesComponent();
        this.myEnvVariablesComponent.setLabelLocation("West");
        this.myProgramParametersComponent.setLabelLocation("West");
        this.myWorkingDirectoryComponent.setLabelLocation("West");
        this.addComponents();
        this.setPreferredSize(new Dimension(10, 10));
        this.setAnchor((JComponent)this.myEnvVariablesComponent.getLabel());
    }

    protected JComponent createComponentWithMacroBrowse(final @NotNull TextFieldWithBrowseButton textAccessor) {
        if (textAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/CommonProgramParametersPanel", "createComponentWithMacroBrowse"));
        }
        final FixedSizeButton button = new FixedSizeButton((JComponent)textAccessor);
        button.setIcon(AllIcons.RunConfigurations.Variables);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmartList macros = new SmartList((Collection)PathMacros.getInstance().getUserMacroNames());
                if (CommonProgramParametersPanel.this.myModuleContext != null) {
                    macros.add("MODULE_DIR");
                }
                JBList list = new JBList((Object[])ArrayUtil.toStringArray((Collection)macros));
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setItemChoosenCallback(new Runnable((JList)list){
                    final /* synthetic */ JList val$list;
                    {
                        this.val$list = jList;
                    }

                    @Override
                    public void run() {
                        Object value = this.val$list.getSelectedValue();
                        if (value instanceof String) {
                            textAccessor.setText('$' + (String)value + '$');
                        }
                    }
                }).setMovable(false).setResizable(false).createPopup().showUnderneathOf((Component)button);
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)textAccessor, "Center");
        panel.add((Component)button, "East");
        return panel;
    }

    protected void addComponents() {
        this.add((Component)this.myProgramParametersComponent);
        this.add((Component)this.myWorkingDirectoryComponent);
        this.add((Component)this.myEnvVariablesComponent);
    }

    protected void copyDialogCaption(LabeledComponent<RawCommandLineEditor> component) {
        RawCommandLineEditor rawCommandLineEditor = (RawCommandLineEditor)component.getComponent();
        rawCommandLineEditor.setDialogCaption(component.getRawText());
        component.getLabel().setLabelFor((Component)rawCommandLineEditor.getTextField());
    }

    public void setProgramParametersLabel(String textWithMnemonic) {
        this.myProgramParametersComponent.setText(textWithMnemonic);
        this.copyDialogCaption(this.myProgramParametersComponent);
    }

    public void setProgramParameters(String params) {
        ((RawCommandLineEditor)this.myProgramParametersComponent.getComponent()).setText(params);
    }

    public void setWorkingDirectory(String dir) {
        this.myWorkingDirectoryField.setText(dir);
    }

    public void setModuleContext(Module moduleContext) {
        this.myModuleContext = moduleContext;
    }

    public LabeledComponent<RawCommandLineEditor> getProgramParametersComponent() {
        return this.myProgramParametersComponent;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myProgramParametersComponent.setAnchor(anchor);
        this.myWorkingDirectoryComponent.setAnchor(anchor);
        this.myEnvVariablesComponent.setAnchor(anchor);
    }

    public void applyTo(CommonProgramRunConfigurationParameters configuration) {
        configuration.setProgramParameters(this.fromTextField((TextAccessor)this.myProgramParametersComponent.getComponent(), configuration));
        configuration.setWorkingDirectory(this.fromTextField((TextAccessor)this.myWorkingDirectoryField, configuration));
        configuration.setEnvs(this.myEnvVariablesComponent.getEnvs());
        configuration.setPassParentEnvs(this.myEnvVariablesComponent.isPassParentEnvs());
    }

    @Nullable
    protected String fromTextField(@NotNull TextAccessor textAccessor, @NotNull CommonProgramRunConfigurationParameters configuration) {
        if (textAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/ui/CommonProgramParametersPanel", "fromTextField"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/ui/CommonProgramParametersPanel", "fromTextField"));
        }
        return textAccessor.getText();
    }

    public void reset(CommonProgramRunConfigurationParameters configuration) {
        this.setProgramParameters(configuration.getProgramParameters());
        this.setWorkingDirectory(PathUtil.toSystemDependentName((String)configuration.getWorkingDirectory()));
        this.myEnvVariablesComponent.setEnvs(configuration.getEnvs());
        this.myEnvVariablesComponent.setPassParentEnvs(configuration.isPassParentEnvs());
    }
}

