/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerNodeDescriptor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMRootTestProxyFormatter;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TestTreeRenderer
extends ColoredTreeCellRenderer {
    @NonNls
    private static final String SPACE_STRING = " ";
    private final TestConsoleProperties myConsoleProperties;
    private SMRootTestProxyFormatter myAdditionalRootFormatter;

    public TestTreeRenderer(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObj = node.getUserObject();
        if (userObj instanceof SMTRunnerNodeDescriptor) {
            SMTRunnerNodeDescriptor desc = (SMTRunnerNodeDescriptor)((Object)userObj);
            SMTestProxy testProxy = (SMTestProxy)desc.getElement();
            if (testProxy instanceof SMTestProxy.SMRootTestProxy) {
                SMTestProxy.SMRootTestProxy rootTestProxy = (SMTestProxy.SMRootTestProxy)testProxy;
                if (rootTestProxy.isLeaf()) {
                    TestsPresentationUtil.formatRootNodeWithoutChildren(rootTestProxy, this);
                } else {
                    TestsPresentationUtil.formatRootNodeWithChildren(rootTestProxy, this);
                }
                if (this.myAdditionalRootFormatter != null) {
                    this.myAdditionalRootFormatter.format(rootTestProxy, this);
                }
            } else {
                TestsPresentationUtil.formatTestProxy(testProxy, this);
            }
            return;
        }
        String text = node.toString();
        this.append(text != null ? text : SPACE_STRING, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    public TestConsoleProperties getConsoleProperties() {
        return this.myConsoleProperties;
    }

    public void setAdditionalRootFormatter(@NotNull SMRootTestProxyFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/ui/TestTreeRenderer", "setAdditionalRootFormatter"));
        }
        this.myAdditionalRootFormatter = formatter;
    }

    public void removeAdditionalRootFormatter() {
        this.myAdditionalRootFormatter = null;
    }
}

