/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;

public class TestIgnoredState
extends AbstractState {
    private final String myText;
    private final String myStacktrace;

    public TestIgnoredState(@Nullable String ignoredMsg, @Nullable String stackTrace) {
        this.myText = StringUtil.isEmpty((String)ignoredMsg) ? null : "\n" + ignoredMsg;
        this.myStacktrace = stackTrace == null ? null : stackTrace + "\n";
    }

    @Override
    public boolean isInProgress() {
        return false;
    }

    @Override
    public boolean isDefect() {
        return true;
    }

    @Override
    public boolean wasLaunched() {
        return true;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean wasTerminated() {
        return false;
    }

    @Override
    public TestStateInfo.Magnitude getMagnitude() {
        return TestStateInfo.Magnitude.IGNORED_INDEX;
    }

    @Override
    public void printOn(Printer printer) {
        super.printOn(printer);
        if (this.myText != null) {
            printer.print(this.myText, ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myStacktrace)) {
            printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
            printer.mark();
            printer.print(this.myStacktrace, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    public String toString() {
        return "TEST IGNORED";
    }
}

