/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeNodeEvent {
    private final String myName;
    private final int myId;

    public TreeNodeEvent(@Nullable String name, int id) {
        this.myName = name;
        this.myId = id;
        this.validate();
    }

    private void validate() {
        if (this.myId < -1) {
            this.fail("id should be greater than -2");
        }
    }

    protected void fail(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/events/TreeNodeEvent", "fail"));
        }
        throw new IllegalStateException(message + ", " + this.toString());
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public int getId() {
        return this.myId;
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName() + "{");
        TreeNodeEvent.append(buf, "name", this.myName);
        TreeNodeEvent.append(buf, "id", this.myId);
        this.appendToStringInfo(buf);
        buf.setLength(buf.length() - 2);
        buf.append("}");
        return buf.toString();
    }

    protected abstract void appendToStringInfo(@NotNull StringBuilder var1);

    protected static void append(@NotNull StringBuilder buffer, @NotNull String key, @Nullable Object value) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/events/TreeNodeEvent", "append"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/runner/events/TreeNodeEvent", "append"));
        }
        if (value != null) {
            buffer.append(key).append("=");
            if (value instanceof String) {
                buffer.append("'").append(value).append("'");
            } else {
                buffer.append(String.valueOf(value));
            }
            buffer.append(", ");
        }
    }

    public static int getNodeId(@NotNull ServiceMessage message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/events/TreeNodeEvent", "getNodeId"));
        }
        return TreeNodeEvent.getIntAttribute(message, "nodeId");
    }

    public static int getIntAttribute(@NotNull ServiceMessage message, @NotNull String key) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/events/TreeNodeEvent", "getIntAttribute"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/runner/events/TreeNodeEvent", "getIntAttribute"));
        }
        String value = (String)message.getAttributes().get(key);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }
}

