/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.GeneralToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.OutputLineSplitter;
import com.intellij.execution.testframework.sm.runner.ProcessOutputConsumer;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.BaseTestMessage;
import jetbrains.buildServer.messages.serviceMessages.BuildNumber;
import jetbrains.buildServer.messages.serviceMessages.BuildStatisticValue;
import jetbrains.buildServer.messages.serviceMessages.BuildStatus;
import jetbrains.buildServer.messages.serviceMessages.DefaultServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.Message;
import jetbrains.buildServer.messages.serviceMessages.ProgressFinish;
import jetbrains.buildServer.messages.serviceMessages.ProgressMessage;
import jetbrains.buildServer.messages.serviceMessages.ProgressStart;
import jetbrains.buildServer.messages.serviceMessages.PublishArtifacts;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import jetbrains.buildServer.messages.serviceMessages.TestStdOut;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputToGeneralTestEventsConverter
implements ProcessOutputConsumer {
    private static final Logger LOG = Logger.getInstance((String)OutputToGeneralTestEventsConverter.class.getName());
    private GeneralTestEventsProcessor myProcessor;
    private final MyServiceMessageVisitor myServiceMessageVisitor;
    private final String myTestFrameworkName;
    private final OutputLineSplitter mySplitter;
    private boolean myPendingLineBreakFlag;

    public OutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter", "<init>"));
        }
        if (consoleProperties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter", "<init>"));
        }
        this.myTestFrameworkName = testFrameworkName;
        this.myServiceMessageVisitor = new MyServiceMessageVisitor();
        this.mySplitter = new OutputLineSplitter(consoleProperties.isEditable()){

            @Override
            protected void onLineAvailable(@NotNull String text, @NotNull Key outputType, boolean tcLikeFakeOutput) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$1", "onLineAvailable"));
                }
                if (outputType == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$1", "onLineAvailable"));
                }
                OutputToGeneralTestEventsConverter.this.processConsistentText(text, outputType, tcLikeFakeOutput);
            }
        };
    }

    @Override
    public void setProcessor(@Nullable GeneralTestEventsProcessor processor) {
        this.myProcessor = processor;
    }

    public void dispose() {
        this.setProcessor(null);
    }

    @Override
    public void process(String text, Key outputType) {
        this.mySplitter.process(text, outputType);
    }

    @Override
    public void flushBufferBeforeTerminating() {
        this.mySplitter.flush();
        if (this.myPendingLineBreakFlag) {
            this.fireOnUncapturedLineBreak();
        }
    }

    private void fireOnUncapturedLineBreak() {
        this.fireOnUncapturedOutput("\n", ProcessOutputTypes.STDOUT);
    }

    private void processConsistentText(String text, Key outputType, boolean tcLikeFakeOutput) {
        try {
            if (!this.processServiceMessages(text, outputType, (ServiceMessageVisitor)this.myServiceMessageVisitor)) {
                if (this.myPendingLineBreakFlag) {
                    this.fireOnUncapturedLineBreak();
                    this.myPendingLineBreakFlag = false;
                }
                String outputToProcess = text;
                if (tcLikeFakeOutput && text.endsWith("\n")) {
                    this.myPendingLineBreakFlag = true;
                    outputToProcess = outputToProcess.substring(0, outputToProcess.length() - 1);
                }
                this.fireOnUncapturedOutput(outputToProcess, outputType);
            } else {
                this.myPendingLineBreakFlag = false;
            }
        }
        catch (ParseException e) {
            LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(this.myTestFrameworkName) + "Error parsing text: [" + text + "]", (Throwable)e);
        }
    }

    protected boolean processServiceMessages(String text, Key outputType, ServiceMessageVisitor visitor) throws ParseException {
        ServiceMessage message = ServiceMessage.parse((String)text.trim());
        if (message != null) {
            message.visit(visitor);
        }
        return message != null;
    }

    private void fireOnTestStarted(@NotNull TestStartedEvent testStartedEvent) {
        if (testStartedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter", "fireOnTestStarted"));
        }
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestStarted(testStartedEvent);
        }
    }

    private void fireOnTestFailure(@NotNull TestFailedEvent testFailedEvent) {
        if (testFailedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter", "fireOnTestFailure"));
        }
        this.assertNotNull(testFailedEvent.getLocalizedFailureMessage());
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestFailure(testFailedEvent);
        }
    }

    private void fireOnTestIgnored(@NotNull TestIgnoredEvent testIgnoredEvent) {
        if (testIgnoredEvent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter", "fireOnTestIgnored"));
        }
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestIgnored(testIgnoredEvent);
        }
    }

    private void fireOnTestFinished(@NotNull TestFinishedEvent testFinishedEvent) {
        if (testFinishedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter", "fireOnTestFinished"));
        }
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestFinished(testFinishedEvent);
        }
    }

    private void fireOnCustomProgressTestsCategory(String categoryName, int testsCount) {
        this.assertNotNull(categoryName);
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            boolean disableCustomMode = StringUtil.isEmpty((String)categoryName);
            processor.onCustomProgressTestsCategory(disableCustomMode ? null : categoryName, disableCustomMode ? 0 : testsCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onCustomProgressTestFailed();
        }
    }

    private void fireOnTestFrameworkAttached() {
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestsReporterAttached();
        }
    }

    private void fireOnTestOutput(@NotNull TestOutputEvent testOutputEvent) {
        if (testOutputEvent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter", "fireOnTestOutput"));
        }
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestOutput(testOutputEvent);
        }
    }

    private void fireOnUncapturedOutput(String text, Key outputType) {
        this.assertNotNull(text);
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onUncapturedOutput(text, outputType);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestsCountInSuite(count);
        }
    }

    private void fireOnSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        if (suiteStartedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter", "fireOnSuiteStarted"));
        }
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onSuiteStarted(suiteStartedEvent);
        }
    }

    private void fireOnSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        if (suiteFinishedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter", "fireOnSuiteFinished"));
        }
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onSuiteFinished(suiteFinishedEvent);
        }
    }

    protected void fireOnErrorMsg(String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        this.assertNotNull(localizedMessage);
        GeneralTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onError(localizedMessage, stackTrace, isCritical);
        }
    }

    private void assertNotNull(String s) {
        if (s == null) {
            LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(this.myTestFrameworkName) + " @NotNull value is expected.");
        }
    }

    private class MyServiceMessageVisitor
    extends DefaultServiceMessageVisitor {
        @NonNls
        public static final String KEY_TESTS_COUNT = "testCount";
        @NonNls
        private static final String ATTR_KEY_TEST_ERROR = "error";
        @NonNls
        private static final String ATTR_KEY_TEST_COUNT = "count";
        @NonNls
        private static final String ATTR_KEY_TEST_DURATION = "duration";
        @NonNls
        private static final String ATTR_KEY_LOCATION_URL = "locationHint";
        @NonNls
        private static final String ATTR_KEY_LOCATION_URL_OLD = "location";
        @NonNls
        private static final String ATTR_KEY_STACKTRACE_DETAILS = "details";
        @NonNls
        private static final String ATTR_KEY_DIAGNOSTIC = "diagnosticInfo";
        @NonNls
        private static final String MESSAGE = "message";
        @NonNls
        private static final String TEST_REPORTER_ATTACHED = "enteredTheMatrix";
        @NonNls
        private static final String ATTR_KEY_STATUS = "status";
        @NonNls
        private static final String ATTR_VALUE_STATUS_ERROR = "ERROR";
        @NonNls
        private static final String ATTR_VALUE_STATUS_WARNING = "WARNING";
        @NonNls
        private static final String ATTR_KEY_TEXT = "text";
        @NonNls
        private static final String ATTR_KEY_ERROR_DETAILS = "errorDetails";
        @NonNls
        public static final String CUSTOM_STATUS = "customProgressStatus";
        @NonNls
        private static final String ATTR_KEY_TEST_TYPE = "type";
        @NonNls
        private static final String ATTR_KEY_TESTS_CATEGORY = "testsCategory";
        @NonNls
        private static final String ATTR_VAL_TEST_STARTED = "testStarted";
        @NonNls
        private static final String ATTR_VAL_TEST_FAILED = "testFailed";

        private MyServiceMessageVisitor() {
        }

        public void visitTestSuiteStarted(@NotNull TestSuiteStarted suiteStarted) {
            if (suiteStarted == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitTestSuiteStarted"));
            }
            String locationUrl = this.fetchTestLocation(suiteStarted);
            TestSuiteStartedEvent suiteStartedEvent = new TestSuiteStartedEvent(suiteStarted, locationUrl);
            OutputToGeneralTestEventsConverter.this.fireOnSuiteStarted(suiteStartedEvent);
        }

        @Nullable
        private String fetchTestLocation(TestSuiteStarted suiteStarted) {
            Map attrs = suiteStarted.getAttributes();
            String location = (String)attrs.get(ATTR_KEY_LOCATION_URL);
            if (location == null) {
                String oldLocation = (String)attrs.get(ATTR_KEY_LOCATION_URL_OLD);
                if (oldLocation != null) {
                    LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(OutputToGeneralTestEventsConverter.this.myTestFrameworkName) + "Test Runner API was changed for TeamCity 5.0 compatibility. Please use 'locationHint' attribute instead of 'location'.");
                    return oldLocation;
                }
                return null;
            }
            return location;
        }

        public void visitTestSuiteFinished(@NotNull TestSuiteFinished suiteFinished) {
            if (suiteFinished == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitTestSuiteFinished"));
            }
            TestSuiteFinishedEvent finishedEvent = new TestSuiteFinishedEvent(suiteFinished);
            OutputToGeneralTestEventsConverter.this.fireOnSuiteFinished(finishedEvent);
        }

        public void visitTestStarted(@NotNull TestStarted testStarted) {
            if (testStarted == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitTestStarted"));
            }
            String locationUrl = (String)testStarted.getAttributes().get(ATTR_KEY_LOCATION_URL);
            TestStartedEvent testStartedEvent = new TestStartedEvent(testStarted, locationUrl);
            OutputToGeneralTestEventsConverter.this.fireOnTestStarted(testStartedEvent);
        }

        public void visitTestFinished(@NotNull TestFinished testFinished) {
            if (testFinished == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitTestFinished"));
            }
            String durationStr = (String)testFinished.getAttributes().get(ATTR_KEY_TEST_DURATION);
            long duration = 0L;
            if (!StringUtil.isEmptyOrSpaces((String)durationStr)) {
                duration = this.convertToLong(durationStr, (ServiceMessage)testFinished);
            }
            TestFinishedEvent testFinishedEvent = new TestFinishedEvent(testFinished, duration);
            OutputToGeneralTestEventsConverter.this.fireOnTestFinished(testFinishedEvent);
        }

        public void visitTestIgnored(@NotNull TestIgnored testIgnored) {
            if (testIgnored == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitTestIgnored"));
            }
            String stacktrace = (String)testIgnored.getAttributes().get(ATTR_KEY_STACKTRACE_DETAILS);
            OutputToGeneralTestEventsConverter.this.fireOnTestIgnored(new TestIgnoredEvent(testIgnored, stacktrace));
        }

        public void visitTestStdOut(@NotNull TestStdOut testStdOut) {
            if (testStdOut == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitTestStdOut"));
            }
            OutputToGeneralTestEventsConverter.this.fireOnTestOutput(new TestOutputEvent((BaseTestMessage)testStdOut, testStdOut.getStdOut(), true));
        }

        public void visitTestStdErr(@NotNull TestStdErr testStdErr) {
            if (testStdErr == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitTestStdErr"));
            }
            OutputToGeneralTestEventsConverter.this.fireOnTestOutput(new TestOutputEvent((BaseTestMessage)testStdErr, testStdErr.getStdErr(), false));
        }

        public void visitTestFailed(@NotNull TestFailed testFailed) {
            if (testFailed == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitTestFailed"));
            }
            boolean testError = testFailed.getAttributes().get(ATTR_KEY_TEST_ERROR) != null;
            TestFailedEvent testFailedEvent = new TestFailedEvent(testFailed, testError);
            OutputToGeneralTestEventsConverter.this.fireOnTestFailure(testFailedEvent);
        }

        public void visitPublishArtifacts(@NotNull PublishArtifacts publishArtifacts) {
            if (publishArtifacts == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitPublishArtifacts"));
            }
        }

        public void visitProgressMessage(@NotNull ProgressMessage progressMessage) {
            if (progressMessage == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitProgressMessage"));
            }
        }

        public void visitProgressStart(@NotNull ProgressStart progressStart) {
            if (progressStart == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitProgressStart"));
            }
        }

        public void visitProgressFinish(@NotNull ProgressFinish progressFinish) {
            if (progressFinish == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitProgressFinish"));
            }
        }

        public void visitBuildStatus(@NotNull BuildStatus buildStatus) {
            if (buildStatus == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitBuildStatus"));
            }
        }

        public void visitBuildNumber(@NotNull BuildNumber buildNumber) {
            if (buildNumber == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitBuildNumber"));
            }
        }

        public void visitBuildStatisticValue(@NotNull BuildStatisticValue buildStatsValue) {
            if (buildStatsValue == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitBuildStatisticValue"));
            }
        }

        public void visitMessageWithStatus(@NotNull Message msg) {
            if (msg == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitMessageWithStatus"));
            }
            Map msgAttrs = msg.getAttributes();
            String text = (String)msgAttrs.get(ATTR_KEY_TEXT);
            if (!StringUtil.isEmpty((String)text)) {
                String status = (String)msgAttrs.get(ATTR_KEY_STATUS);
                if (status.equals(ATTR_VALUE_STATUS_ERROR)) {
                    String stackTrace = (String)msgAttrs.get(ATTR_KEY_ERROR_DETAILS);
                    OutputToGeneralTestEventsConverter.this.fireOnErrorMsg(text, stackTrace, true);
                } else if (status.equals(ATTR_VALUE_STATUS_WARNING)) {
                    String stackTrace = (String)msgAttrs.get(ATTR_KEY_ERROR_DETAILS);
                    OutputToGeneralTestEventsConverter.this.fireOnErrorMsg(text, stackTrace, false);
                } else {
                    OutputToGeneralTestEventsConverter.this.fireOnUncapturedOutput(text, ProcessOutputTypes.STDOUT);
                }
            }
        }

        public void visitServiceMessage(@NotNull ServiceMessage msg) {
            if (msg == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "visitServiceMessage"));
            }
            String name = msg.getMessageName();
            if (KEY_TESTS_COUNT.equals(name)) {
                this.processTestCountInSuite(msg);
            } else if (CUSTOM_STATUS.equals(name)) {
                this.processCustomStatus(msg);
            } else if (MESSAGE.equals(name)) {
                Map msgAttrs = msg.getAttributes();
                String text = (String)msgAttrs.get(ATTR_KEY_TEXT);
                if (!StringUtil.isEmpty((String)text)) {
                    OutputToGeneralTestEventsConverter.this.fireOnUncapturedOutput(text, ProcessOutputTypes.STDOUT);
                }
            } else if (TEST_REPORTER_ATTACHED.equals(name)) {
                OutputToGeneralTestEventsConverter.this.fireOnTestFrameworkAttached();
            } else {
                GeneralToSMTRunnerEventsConvertor.logProblem(LOG, "Unexpected service message:" + name, OutputToGeneralTestEventsConverter.this.myTestFrameworkName);
            }
        }

        private void processTestCountInSuite(ServiceMessage msg) {
            String countStr = (String)msg.getAttributes().get(ATTR_KEY_TEST_COUNT);
            OutputToGeneralTestEventsConverter.this.fireOnTestsCountInSuite(this.convertToInt(countStr, msg));
        }

        private int convertToInt(String countStr, ServiceMessage msg) {
            int count = 0;
            try {
                count = Integer.parseInt(countStr);
            }
            catch (NumberFormatException ex) {
                String diagnosticInfo = (String)msg.getAttributes().get(ATTR_KEY_DIAGNOSTIC);
                LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(OutputToGeneralTestEventsConverter.this.myTestFrameworkName) + "Parse integer error." + (diagnosticInfo == null ? "" : " " + diagnosticInfo), (Throwable)ex);
            }
            return count;
        }

        private long convertToLong(String countStr, @NotNull ServiceMessage msg) {
            if (msg == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor", "convertToLong"));
            }
            long count = 0L;
            try {
                count = Long.parseLong(countStr);
            }
            catch (NumberFormatException ex) {
                String diagnosticInfo = (String)msg.getAttributes().get(ATTR_KEY_DIAGNOSTIC);
                LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(OutputToGeneralTestEventsConverter.this.myTestFrameworkName) + "Parse long error." + (diagnosticInfo == null ? "" : " " + diagnosticInfo), (Throwable)ex);
            }
            return count;
        }

        private void processCustomStatus(ServiceMessage msg) {
            Map attrs = msg.getAttributes();
            String msgType = (String)attrs.get(ATTR_KEY_TEST_TYPE);
            if (msgType != null) {
                if (msgType.equals(ATTR_VAL_TEST_STARTED)) {
                    OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestStarted();
                } else if (msgType.equals(ATTR_VAL_TEST_FAILED)) {
                    OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestFailed();
                }
                return;
            }
            String testsCategory = (String)attrs.get(ATTR_KEY_TESTS_CATEGORY);
            if (testsCategory != null) {
                String countStr = (String)msg.getAttributes().get(ATTR_KEY_TEST_COUNT);
                OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestsCategory(testsCategory, this.convertToInt(countStr, msg));
                return;
            }
        }
    }
}

