/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.testIntegration.TestLocationProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUrlProvider
implements TestLocationProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)FileUrlProvider.class.getName());
    @NonNls
    private static final String FILE_PROTOCOL_ID = "file";

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocolId, @NotNull String path, Project project) {
        int lineNumber;
        String filePath;
        if (protocolId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        if (!FILE_PROTOCOL_ID.equals(protocolId)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
            }
            return list;
        }
        String normalizedPath = path.replace(File.separatorChar, '/');
        int lineNoSeparatorIndex = normalizedPath.lastIndexOf(58);
        if (lineNoSeparatorIndex > 3) {
            String lineNumStr = normalizedPath.substring(lineNoSeparatorIndex + 1);
            int lineNum = 0;
            try {
                lineNum = Integer.parseInt(lineNumStr);
            }
            catch (NumberFormatException e) {
                LOG.warn(protocolId + ": Malformed location path: " + path, (Throwable)e);
            }
            filePath = normalizedPath.substring(0, lineNoSeparatorIndex);
            lineNumber = lineNum;
        } else {
            lineNumber = 1;
            filePath = normalizedPath;
        }
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)filePath);
        List<VirtualFile> virtualFiles = TestsLocationProviderUtil.findSuitableFilesFor(systemIndependentPath, project);
        if (virtualFiles.isEmpty()) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
            }
            return list;
        }
        if (lineNumber < 0) {
            LOG.warn("Tests location provider: line number should be >= 1. Path: " + path);
        }
        ArrayList<Location> locations = new ArrayList<Location>(2);
        for (VirtualFile file : virtualFiles) {
            locations.add(FileUrlProvider.createLocationFor(project, file, lineNumber < 1 ? 1 : lineNumber));
        }
        ArrayList<Location> arrayList = locations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        return arrayList;
    }

    @Nullable
    public static Location createLocationFor(Project project, @NotNull VirtualFile virtualFile, int lineNum) {
        int length;
        int endOffset;
        int lineStartOffset;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/testframework/sm/FileUrlProvider", "createLocationFor"));
        }
        assert (lineNum > 0);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (doc == null) {
            return null;
        }
        int lineCount = doc.getLineCount();
        if (lineNum <= lineCount) {
            lineStartOffset = doc.getLineStartOffset(lineNum - 1);
            endOffset = doc.getLineEndOffset(lineNum - 1);
        } else {
            lineStartOffset = 0;
            endOffset = doc.getTextLength();
        }
        PsiElement elementAtLine = null;
        for (int offset = lineStartOffset; offset <= endOffset && (elementAtLine = psiFile.findElementAt(offset)) instanceof PsiWhiteSpace; offset += (length = elementAtLine.getTextLength()) > 1 ? length - 1 : 1) {
        }
        return PsiLocation.fromPsiElement((Project)project, (PsiElement)(elementAtLine != null ? elementAtLine : psiFile));
    }
}

