/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractRerunFailedTestsAction
extends AnAction
implements AnAction.TransparentUpdate,
Disposable {
    private static final List<AbstractRerunFailedTestsAction> registry = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.ui.actions.RerunFailedTestsAction");
    private TestFrameworkRunningModel myModel;
    private Getter<TestFrameworkRunningModel> myModelProvider;
    protected TestConsoleProperties myConsoleProperties;
    protected ExecutionEnvironment myEnvironment;
    private final JComponent myParent;

    public AbstractRerunFailedTestsAction() {
        this.myParent = null;
    }

    protected AbstractRerunFailedTestsAction(@NotNull ComponentContainer componentContainer) {
        if (componentContainer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "<init>"));
        }
        this.myParent = componentContainer.getComponent();
        registry.add(this);
        Disposer.register((Disposable)componentContainer, (Disposable)this);
        this.copyFrom(ActionManager.getInstance().getAction("RerunFailedTests"));
        this.registerCustomShortcutSet(this.getShortcutSet(), this.myParent);
    }

    public void dispose() {
        registry.remove((Object)this);
    }

    public void init(TestConsoleProperties consoleProperties, ExecutionEnvironment environment) {
        this.myEnvironment = environment;
        this.myConsoleProperties = consoleProperties;
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
    }

    public void setModelProvider(Getter<TestFrameworkRunningModel> modelProvider) {
        this.myModelProvider = modelProvider;
    }

    @NotNull
    private AbstractRerunFailedTestsAction findActualAction() {
        if (this.myParent != null || registry.isEmpty()) {
            AbstractRerunFailedTestsAction abstractRerunFailedTestsAction = this;
            if (abstractRerunFailedTestsAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "findActualAction"));
            }
            return abstractRerunFailedTestsAction;
        }
        ArrayList<AbstractRerunFailedTestsAction> candidates = new ArrayList<AbstractRerunFailedTestsAction>(registry);
        Collections.sort(candidates, new Comparator<AbstractRerunFailedTestsAction>(){

            @Override
            public int compare(AbstractRerunFailedTestsAction action1, AbstractRerunFailedTestsAction action2) {
                Window window1 = SwingUtilities.windowForComponent(action1.myParent);
                Window window2 = SwingUtilities.windowForComponent(action2.myParent);
                if (window1 == null) {
                    return 1;
                }
                if (window2 == null) {
                    return -1;
                }
                boolean showing1 = action1.myParent.isShowing();
                boolean showing2 = action2.myParent.isShowing();
                if (showing1 && !showing2) {
                    return -1;
                }
                if (showing2 && !showing1) {
                    return 1;
                }
                return window1.isActive() ? -1 : 1;
            }
        });
        AbstractRerunFailedTestsAction abstractRerunFailedTestsAction = (AbstractRerunFailedTestsAction)((Object)candidates.get(0));
        if (abstractRerunFailedTestsAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "findActualAction"));
        }
        return abstractRerunFailedTestsAction;
    }

    public final void update(AnActionEvent e) {
        AbstractRerunFailedTestsAction action = this.findActualAction();
        e.getPresentation().setEnabled(action.isActive(e));
    }

    private boolean isActive(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        TestFrameworkRunningModel model = this.getModel();
        if (model == null || model.getRoot() == null) {
            return false;
        }
        List<? extends AbstractTestProxy> myAllTests = model.getRoot().getAllTests();
        GlobalSearchScope searchScope = model.getProperties().getScope();
        for (AbstractTestProxy abstractTestProxy : myAllTests) {
            if (!this.getFilter(project, searchScope).shouldAccept(abstractTestProxy)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<AbstractTestProxy> getFailedTests(Project project) {
        TestFrameworkRunningModel model = this.getModel();
        List myAllTests = model != null ? model.getRoot().getAllTests() : Collections.emptyList();
        List<AbstractTestProxy> list = this.getFilter(project, model != null ? model.getProperties().getScope() : GlobalSearchScope.allScope((Project)project)).select(myAllTests);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "getFailedTests"));
        }
        return list;
    }

    @NotNull
    protected Filter getFilter(Project project, GlobalSearchScope searchScope) {
        if (TestConsoleProperties.INCLUDE_NON_STARTED_IN_RERUN_FAILED.value((AbstractProperty.AbstractPropertyContainer)this.myConsoleProperties)) {
            Filter filter = Filter.NOT_PASSED.or(Filter.FAILED_OR_INTERRUPTED);
            if (filter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "getFilter"));
            }
            return filter;
        }
        Filter filter = Filter.FAILED_OR_INTERRUPTED;
        if (filter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "getFilter"));
        }
        return filter;
    }

    public void actionPerformed(AnActionEvent e) {
        this.findActualAction().performAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAction() {
        boolean isDebug = this.myConsoleProperties.isDebug();
        MyRunProfile profile = this.getRunProfile();
        if (profile == null) {
            return;
        }
        try {
            Executor executor = isDebug ? DefaultDebugExecutor.getDebugExecutorInstance() : DefaultRunExecutor.getRunExecutorInstance();
            ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)profile);
            assert (runner != null);
            runner.execute(new ExecutionEnvironmentBuilder(this.myEnvironment).setRunProfile((RunProfile)profile).build());
        }
        catch (ExecutionException e1) {
            LOG.error((Throwable)e1);
        }
        finally {
            profile.clear();
        }
    }

    @Nullable
    public MyRunProfile getRunProfile() {
        return null;
    }

    @Nullable
    public TestFrameworkRunningModel getModel() {
        if (this.myModel != null) {
            return this.myModel;
        }
        if (this.myModelProvider != null) {
            return (TestFrameworkRunningModel)this.myModelProvider.get();
        }
        return null;
    }

    protected static abstract class MyRunProfile
    extends RunConfigurationBase
    implements ModuleRunProfile,
    WrappingRunConfiguration<RunConfigurationBase> {
        private final RunConfigurationBase myConfiguration;

        @Deprecated
        public RunConfigurationBase getConfiguration() {
            return this.getPeer();
        }

        public RunConfigurationBase getPeer() {
            return this.myConfiguration;
        }

        public MyRunProfile(RunConfigurationBase configuration) {
            super(configuration.getProject(), configuration.getFactory(), ActionsBundle.message((String)"action.RerunFailedTests.text", (Object[])new Object[0]));
            this.myConfiguration = configuration;
        }

        public void clear() {
        }

        public void checkConfiguration() throws RuntimeConfigurationException {
        }

        public void readExternal(Element element) throws InvalidDataException {
            this.myConfiguration.readExternal(element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            this.myConfiguration.writeExternal(element);
        }

        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            SettingsEditor settingsEditor = this.myConfiguration.getConfigurationEditor();
            if (settingsEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile", "getConfigurationEditor"));
            }
            return settingsEditor;
        }

        @NotNull
        public ConfigurationType getType() {
            ConfigurationType configurationType = this.myConfiguration.getType();
            if (configurationType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile", "getType"));
            }
            return configurationType;
        }

        public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
            return this.myConfiguration.createRunnerSettings(provider);
        }

        public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
            return this.myConfiguration.getRunnerSettingsEditor(runner);
        }

        public RunConfiguration clone() {
            return this.myConfiguration.clone();
        }

        public int getUniqueID() {
            return this.myConfiguration.getUniqueID();
        }

        public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
            return this.myConfiguration.getOptionsForPredefinedLogFile(predefinedLogFile);
        }

        public ArrayList<PredefinedLogFile> getPredefinedLogFiles() {
            return this.myConfiguration.getPredefinedLogFiles();
        }

        public ArrayList<LogFileOptions> getAllLogFiles() {
            return this.myConfiguration.getAllLogFiles();
        }

        public ArrayList<LogFileOptions> getLogFiles() {
            return this.myConfiguration.getLogFiles();
        }
    }
}

