/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Alarm;
import com.intellij.util.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositePrintable
implements Printable,
Disposable {
    public static final String NEW_LINE = "\n";
    protected final List<Printable> myNestedPrintables = new ArrayList<Printable>();
    private final PrintablesWrapper myWrapper = new PrintablesWrapper();
    protected int myExceptionMark;
    private int myCurrentSize = 0;
    private String myOutputFile = null;
    private static final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
    private static final Logger LOG = Logger.getInstance((String)("#" + PrintablesWrapper.class.getName()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        List<Printable> list = this.myNestedPrintables;
        synchronized (list) {
            this.myWrapper.flush(this.myNestedPrintables);
            this.clear();
        }
    }

    public static void invokeInAlarm(Runnable runnable) {
        CompositePrintable.invokeInAlarm(runnable, !ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
    }

    public static void invokeInAlarm(Runnable runnable, boolean sync) {
        if (sync) {
            runnable.run();
        } else {
            myAlarm.addRequest(runnable, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printOn(Printer printer) {
        ArrayList<Printable> printables;
        List<Printable> list = this.myNestedPrintables;
        synchronized (list) {
            printables = new ArrayList<Printable>(this.myNestedPrintables);
        }
        this.myWrapper.printOn(printer, printables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(@NotNull Printable printable) {
        if (printable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/CompositePrintable", "addLast"));
        }
        List<Printable> list = this.myNestedPrintables;
        synchronized (list) {
            this.myNestedPrintables.add(printable);
            if (this.myNestedPrintables.size() > 500) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(@NotNull Printable printable, int i) {
        if (printable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/CompositePrintable", "insert"));
        }
        List<Printable> list = this.myNestedPrintables;
        synchronized (list) {
            if (i >= this.myNestedPrintables.size()) {
                this.myNestedPrintables.add(printable);
            } else {
                this.myNestedPrintables.add(i, printable);
            }
            if (this.myNestedPrintables.size() > 500) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        List<Printable> list = this.myNestedPrintables;
        synchronized (list) {
            this.myCurrentSize += this.myNestedPrintables.size();
            this.myNestedPrintables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        List<Printable> list = this.myNestedPrintables;
        synchronized (list) {
            return this.myCurrentSize + this.myNestedPrintables.size();
        }
    }

    public void dispose() {
        this.clear();
        this.myWrapper.dispose();
    }

    public int getExceptionMark() {
        return this.myExceptionMark;
    }

    public void setExceptionMark(int exceptionMark) {
        this.myExceptionMark = exceptionMark;
    }

    public void setOutputFilePath(String outputFile) {
        this.myOutputFile = outputFile;
    }

    private class PrintablesWrapper {
        @NonNls
        private static final String HYPERLINK = "hyperlink";
        private ConsoleViewContentType myLastSelected;
        private File myFile;
        private final MyFlushToFilePrinter myPrinter = new MyFlushToFilePrinter();

        private PrintablesWrapper() {
        }

        @Nullable
        private synchronized File getFile() {
            if (this.myFile == null) {
                try {
                    File tempFile = FileUtil.createTempFile((String)"idea_test_", (String)".out");
                    if (tempFile.exists()) {
                        this.myFile = tempFile;
                        return this.myFile;
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
            return this.myFile;
        }

        public synchronized void dispose() {
            if (this.myFile != null) {
                FileUtil.delete((File)this.myFile);
            }
        }

        public synchronized boolean hasOutput() {
            return this.myFile != null;
        }

        public void flush(List<Printable> printables) {
            if (printables.isEmpty()) {
                return;
            }
            final ArrayList<Printable> currentPrintables = new ArrayList<Printable>(printables);
            Runnable request = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (Printable printable : currentPrintables) {
                        printable.printOn(PrintablesWrapper.this.myPrinter);
                    }
                    PrintablesWrapper.this.myPrinter.close();
                    if (CompositePrintable.this.myOutputFile != null && new File(CompositePrintable.this.myOutputFile).exists()) {
                        PrintStream printStream = null;
                        try {
                            final PrintStream finalPrintStream = printStream = new PrintStream(new FileOutputStream(new File(CompositePrintable.this.myOutputFile), true));
                            for (Printable currentPrintable : currentPrintables) {
                                currentPrintable.printOn(new Printer(){

                                    @Override
                                    public void print(String text, ConsoleViewContentType contentType) {
                                        if (contentType != ConsoleViewContentType.SYSTEM_OUTPUT) {
                                            finalPrintStream.print(text);
                                        }
                                    }

                                    @Override
                                    public void printHyperlink(String text, HyperlinkInfo info) {
                                        finalPrintStream.print(text);
                                    }

                                    @Override
                                    public void onNewAvailable(@NotNull Printable printable) {
                                        if (printable == null) {
                                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/CompositePrintable$PrintablesWrapper$1$1", "onNewAvailable"));
                                        }
                                    }

                                    @Override
                                    public void mark() {
                                    }
                                });
                            }
                        }
                        catch (FileNotFoundException e) {
                            LOG.error((Throwable)e);
                        }
                        finally {
                            if (printStream != null) {
                                printStream.close();
                            }
                        }
                    }
                }
            };
            CompositePrintable.invokeInAlarm(request, ApplicationManager.getApplication().isUnitTestMode());
        }

        public void printOn(final Printer console, final List<Printable> printables) {
            Runnable request = new Runnable(){

                @Override
                public void run() {
                    File file = PrintablesWrapper.this.hasOutput() ? PrintablesWrapper.this.getFile() : null;
                    MyFileContentPrinter printer = new MyFileContentPrinter();
                    printer.printFileContent(console, file, printables);
                }
            };
            CompositePrintable.invokeInAlarm(request);
        }

        private class MyFileContentPrinter {
            private MyFileContentPrinter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void printFileContent(Printer printer, @Nullable File file, List<Printable> nestedPrintables) {
                if (file != null) {
                    FilterInputStream reader = null;
                    try {
                        reader = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                        int lineNum = 0;
                        while (reader.available() > 0 && !this.wasPrintableChanged(printer)) {
                            if (lineNum == CompositePrintable.this.getExceptionMark() && lineNum > 0) {
                                printer.mark();
                            }
                            String line = IOUtil.readString((DataInput)((Object)reader));
                            boolean printed = false;
                            for (ConsoleViewContentType contentType : ConsoleViewContentType.OUTPUT_TYPES) {
                                String prefix = contentType.toString();
                                if (!line.startsWith(prefix)) continue;
                                printer.print(line.substring(prefix.length()), contentType);
                                PrintablesWrapper.this.myLastSelected = contentType;
                                printed = true;
                                break;
                            }
                            if (!printed) {
                                if (line.startsWith(PrintablesWrapper.HYPERLINK)) {
                                    new DiffHyperlink(IOUtil.readString((DataInput)((Object)reader)), IOUtil.readString((DataInput)((Object)reader)), IOUtil.readString((DataInput)((Object)reader)), false).printOn(printer);
                                } else {
                                    printer.print(line, PrintablesWrapper.this.myLastSelected != null ? PrintablesWrapper.this.myLastSelected : ConsoleViewContentType.NORMAL_OUTPUT);
                                }
                            }
                            ++lineNum;
                        }
                    }
                    catch (FileNotFoundException e) {
                        LOG.info((Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (FileNotFoundException e) {
                            LOG.info((Throwable)e);
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                for (int i = 0; i < nestedPrintables.size(); ++i) {
                    if (i == CompositePrintable.this.getExceptionMark() && i > 0) {
                        printer.mark();
                    }
                    nestedPrintables.get(i).printOn(printer);
                }
            }

            private boolean wasPrintableChanged(Printer printer) {
                return printer instanceof TestsOutputConsolePrinter && !((TestsOutputConsolePrinter)printer).isCurrent(CompositePrintable.this);
            }
        }

        private class MyFlushToFilePrinter
        implements Printer {
            private DataOutputStream myFileWriter;

            private MyFlushToFilePrinter() {
            }

            public DataOutputStream getFileWriter() {
                if (this.myFileWriter == null) {
                    try {
                        File file = PrintablesWrapper.this.getFile();
                        LOG.assertTrue(file != null);
                        this.myFileWriter = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file, true)));
                    }
                    catch (FileNotFoundException e) {
                        LOG.info((Throwable)e);
                        return null;
                    }
                }
                return this.myFileWriter;
            }

            public void close() {
                if (this.myFileWriter != null) {
                    try {
                        this.myFileWriter.close();
                    }
                    catch (FileNotFoundException e) {
                        LOG.info((Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                    this.myFileWriter = null;
                }
            }

            @Override
            public void print(String text, ConsoleViewContentType contentType) {
                try {
                    DataOutputStream writer = this.getFileWriter();
                    if (writer != null) {
                        IOUtil.writeString((String)(contentType.toString() + text), (DataOutput)writer);
                    }
                }
                catch (FileNotFoundException e) {
                    LOG.info((Throwable)e);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }

            @Override
            public void printHyperlink(String text, HyperlinkInfo info) {
                if (info instanceof DiffHyperlink.DiffHyperlinkInfo) {
                    DiffHyperlink diffHyperlink = ((DiffHyperlink.DiffHyperlinkInfo)info).getPrintable();
                    try {
                        DataOutputStream fileWriter = this.getFileWriter();
                        if (fileWriter != null) {
                            IOUtil.writeString((String)PrintablesWrapper.HYPERLINK, (DataOutput)fileWriter);
                            IOUtil.writeString((String)diffHyperlink.getLeft(), (DataOutput)fileWriter);
                            IOUtil.writeString((String)diffHyperlink.getRight(), (DataOutput)fileWriter);
                            IOUtil.writeString((String)diffHyperlink.getFilePath(), (DataOutput)fileWriter);
                        }
                    }
                    catch (FileNotFoundException e) {
                        LOG.info((Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                } else {
                    this.print(text, ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }

            @Override
            public void onNewAvailable(@NotNull Printable printable) {
                if (printable == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/testframework/CompositePrintable$PrintablesWrapper$MyFlushToFilePrinter", "onNewAvailable"));
                }
            }

            @Override
            public void mark() {
            }
        }
    }
}

