/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestartAction
extends FakeRerunAction
implements DumbAware,
AnAction.TransparentUpdate,
Disposable {
    private final ProgramRunner myRunner;
    @NotNull
    private final RunContentDescriptor myDescriptor;
    @NotNull
    private final Executor myExecutor;
    private final ExecutionEnvironment myEnvironment;

    public RestartAction(@NotNull Executor executor, ProgramRunner runner, @NotNull RunContentDescriptor descriptor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/RestartAction", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/RestartAction", "<init>"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/runners/RestartAction", "<init>"));
        }
        Disposer.register((Disposable)descriptor, (Disposable)this);
        registry.add(this);
        this.myEnvironment = env;
        this.getTemplatePresentation().setEnabled(false);
        this.myRunner = runner;
        this.myDescriptor = descriptor;
        this.myExecutor = executor;
    }

    public void dispose() {
        registry.remove((Object)this);
    }

    @Nullable
    static RestartAction findActualAction() {
        if (registry.isEmpty()) {
            return null;
        }
        ArrayList candidates = new ArrayList(registry);
        Collections.sort(candidates, new Comparator<RestartAction>(){

            @Override
            public int compare(RestartAction action1, RestartAction action2) {
                boolean isActive2;
                boolean isActive1 = action1.isEnabled();
                if (isActive1 != (isActive2 = action2.isEnabled())) {
                    return isActive1 ? -1 : 1;
                }
                Window window1 = SwingUtilities.windowForComponent(action1.myDescriptor.getComponent());
                Window window2 = SwingUtilities.windowForComponent(action2.myDescriptor.getComponent());
                if (window1 == null) {
                    return 1;
                }
                if (window2 == null) {
                    return -1;
                }
                boolean showing1 = action1.myDescriptor.getComponent().isShowing();
                boolean showing2 = action2.myDescriptor.getComponent().isShowing();
                if (showing1 && !showing2) {
                    return -1;
                }
                if (showing2 && !showing1) {
                    return 1;
                }
                return window1.isActive() ? -1 : 1;
            }
        });
        return (RestartAction)((Object)candidates.get(0));
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        this.restart();
    }

    public void restart() {
        Project project = this.myEnvironment.getProject();
        if (!ExecutorRegistry.getInstance().isStarting(project, this.myExecutor.getId(), this.myRunner.getRunnerId())) {
            ExecutionManager.getInstance((Project)project).restartRunProfile(this.myRunner, this.myEnvironment, this.myDescriptor);
        }
    }

    @Override
    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        String name = this.myEnvironment.getRunProfile().getName();
        ProcessHandler processHandler = this.myDescriptor.getProcessHandler();
        boolean isRunning = processHandler != null && !processHandler.isProcessTerminated();
        presentation.setText(ExecutionBundle.message((String)"rerun.configuration.action.name", (Object[])new Object[]{name}));
        presentation.setIcon(isRunning ? AllIcons.Actions.Restart : this.myExecutor.getIcon());
        presentation.setEnabled(this.isEnabled());
    }

    boolean isEnabled() {
        ProcessHandler processHandler = this.myDescriptor.getProcessHandler();
        boolean isTerminating = processHandler != null && processHandler.isProcessTerminating();
        boolean isStarting = ExecutorRegistry.getInstance().isStarting(this.myEnvironment.getProject(), this.myExecutor.getId(), this.myRunner.getRunnerId());
        return !isStarting && !isTerminating;
    }

    public void registerShortcut(JComponent component) {
        this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("Rerun")), component);
    }
}

