/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.ProjectTopics;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.UnknownBeforeRunTaskProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.WeakHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunManagerImpl
extends RunManagerEx
implements JDOMExternalizable,
ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.RunManagerImpl");
    private final Project myProject;
    private final Map<String, ConfigurationType> myTypesByName = new LinkedHashMap<String, ConfigurationType>();
    private final Map<String, RunnerAndConfigurationSettings> myTemplateConfigurationsMap = new HashMap();
    private final Map<String, RunnerAndConfigurationSettings> myConfigurations = new LinkedHashMap<String, RunnerAndConfigurationSettings>();
    private final Map<String, Boolean> mySharedConfigurations = new TreeMap<String, Boolean>();
    private final Map<RunConfiguration, List<BeforeRunTask>> myConfigurationToBeforeTasksMap = new WeakHashMap();
    @Nullable
    private String myLoadedSelectedConfigurationUniqueName = null;
    @Nullable
    private String mySelectedConfigurationId = null;
    private Map<String, Icon> myIdToIcon = new HashMap();
    private Map<String, Long> myIconCheckTimes = new HashMap();
    private Map<String, Long> myIconCalcTime = Collections.synchronizedMap(new HashMap());
    @NonNls
    protected static final String CONFIGURATION = "configuration";
    protected static final String RECENT = "recent_temporary";
    private ConfigurationType[] myTypes;
    private final RunManagerConfig myConfig;
    @NonNls
    protected static final String NAME_ATTR = "name";
    @NonNls
    protected static final String SELECTED_ATTR = "selected";
    @NonNls
    private static final String METHOD = "method";
    @NonNls
    private static final String OPTION = "option";
    private List<Element> myUnknownElements = null;
    private JDOMExternalizableStringList myOrder = new JDOMExternalizableStringList();
    private final ArrayList<RunConfiguration> myRecentlyUsedTemporaries = new ArrayList();
    private boolean myOrdered = true;
    private final EventDispatcher<RunManagerListener> myDispatcher = EventDispatcher.create(RunManagerListener.class);
    private Map<Key<? extends BeforeRunTask>, BeforeRunTaskProvider> myBeforeStepsMap;
    private Map<String, Key<? extends BeforeRunTask>> myProviderKeysMap;

    public RunManagerImpl(Project project, PropertiesComponent propertiesComponent) {
        this.myConfig = new RunManagerConfig(propertiesComponent, this);
        this.myProject = project;
        this.initConfigurationTypes();
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                RunnerAndConfigurationSettings configuration = RunManagerImpl.this.getSelectedConfiguration();
                if (configuration != null) {
                    RunManagerImpl.this.myIconCheckTimes.remove(configuration.getUniqueID());
                }
            }
        });
    }

    public final void initializeConfigurationTypes(@NotNull ConfigurationType[] factories) {
        if (factories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "initializeConfigurationTypes"));
        }
        Arrays.sort(factories, new Comparator<ConfigurationType>(){

            @Override
            public int compare(ConfigurationType o1, ConfigurationType o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        ArrayList<ConfigurationType> types = new ArrayList<ConfigurationType>(Arrays.asList(factories));
        types.add((ConfigurationType)UnknownConfigurationType.INSTANCE);
        this.myTypes = types.toArray(new ConfigurationType[types.size()]);
        for (ConfigurationType type : factories) {
            this.myTypesByName.put(type.getId(), type);
        }
        UnknownConfigurationType broken = UnknownConfigurationType.INSTANCE;
        this.myTypesByName.put(broken.getId(), (ConfigurationType)broken);
    }

    private void initConfigurationTypes() {
        ConfigurationType[] configurationTypes = (ConfigurationType[])Extensions.getExtensions((ExtensionPointName)ConfigurationType.CONFIGURATION_TYPE_EP);
        this.initializeConfigurationTypes(configurationTypes);
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    public void projectOpened() {
    }

    @Override
    @NotNull
    public RunnerAndConfigurationSettings createConfiguration(@NotNull String name, @NotNull ConfigurationFactory factory) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "createConfiguration"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/RunManagerImpl", "createConfiguration"));
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.createConfiguration(this.doCreateConfiguration(name, factory, true), factory);
        if (runnerAndConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "createConfiguration"));
        }
        return runnerAndConfigurationSettings;
    }

    protected RunConfiguration doCreateConfiguration(@NotNull String name, @NotNull ConfigurationFactory factory, boolean fromTemplate) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "doCreateConfiguration"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/RunManagerImpl", "doCreateConfiguration"));
        }
        if (fromTemplate) {
            return factory.createConfiguration(name, this.getConfigurationTemplate(factory).getConfiguration());
        }
        RunConfiguration configuration = factory.createTemplateConfiguration(this.myProject, (RunManager)this);
        configuration.setName(name);
        return configuration;
    }

    @NotNull
    public RunnerAndConfigurationSettings createConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull ConfigurationFactory factory) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "createConfiguration"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/RunManagerImpl", "createConfiguration"));
        }
        RunnerAndConfigurationSettings template = this.getConfigurationTemplate(factory);
        this.myConfigurationToBeforeTasksMap.put(runConfiguration, this.getBeforeRunTasks(template.getConfiguration()));
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(this, runConfiguration, false);
        settings.importRunnerAndConfigurationSettings((RunnerAndConfigurationSettingsImpl)template);
        if (!this.mySharedConfigurations.containsKey(settings.getUniqueID())) {
            this.shareConfiguration(settings, this.isConfigurationShared(template));
        }
        RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = settings;
        if (runnerAndConfigurationSettingsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "createConfiguration"));
        }
        return runnerAndConfigurationSettingsImpl;
    }

    public void projectClosed() {
        this.myTemplateConfigurationsMap.clear();
    }

    @Override
    public RunManagerConfig getConfig() {
        return this.myConfig;
    }

    @NotNull
    public ConfigurationType[] getConfigurationFactories() {
        ConfigurationType[] configurationTypeArray = (ConfigurationType[])this.myTypes.clone();
        if (configurationTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationFactories"));
        }
        return configurationTypeArray;
    }

    public ConfigurationType[] getConfigurationFactories(boolean includeUnknown) {
        ConfigurationType[] configurationTypes = (ConfigurationType[])this.myTypes.clone();
        if (!includeUnknown) {
            ArrayList<ConfigurationType> types = new ArrayList<ConfigurationType>();
            for (ConfigurationType configurationType : configurationTypes) {
                if (configurationType instanceof UnknownConfigurationType) continue;
                types.add(configurationType);
            }
            return types.toArray(new ConfigurationType[types.size()]);
        }
        return configurationTypes;
    }

    @NotNull
    public List<RunConfiguration> getConfigurationsList(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationsList"));
        }
        ArrayList<RunConfiguration> list = new ArrayList<RunConfiguration>();
        for (RunnerAndConfigurationSettings myConfiguration : this.getSortedConfigurations()) {
            RunConfiguration configuration = myConfiguration.getConfiguration();
            ConfigurationType configurationType = configuration.getType();
            if (!type.getId().equals(configurationType.getId())) continue;
            list.add(configuration);
        }
        List<RunConfiguration> list2 = Collections.unmodifiableList(list);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationsList"));
        }
        return list2;
    }

    @NotNull
    public List<RunConfiguration> getAllConfigurationsList() {
        ArrayList<RunConfiguration> result = new ArrayList<RunConfiguration>(this.myConfigurations.size());
        for (RunnerAndConfigurationSettings settings : this.getSortedConfigurations()) {
            result.add(settings.getConfiguration());
        }
        List<RunConfiguration> list = Collections.unmodifiableList(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getAllConfigurationsList"));
        }
        return list;
    }

    @NotNull
    public RunConfiguration[] getAllConfigurations() {
        List<RunConfiguration> list = this.getAllConfigurationsList();
        RunConfiguration[] runConfigurationArray = list.toArray(new RunConfiguration[list.size()]);
        if (runConfigurationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getAllConfigurations"));
        }
        return runConfigurationArray;
    }

    @NotNull
    public List<RunnerAndConfigurationSettings> getAllSettings() {
        List<RunnerAndConfigurationSettings> list = Collections.unmodifiableList(new ArrayList<RunnerAndConfigurationSettings>(this.getSortedConfigurations()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getAllSettings"));
        }
        return list;
    }

    @Nullable
    public RunnerAndConfigurationSettings getSettings(@Nullable RunConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        for (RunnerAndConfigurationSettings settings : this.getSortedConfigurations()) {
            if (settings.getConfiguration() != configuration) continue;
            return settings;
        }
        return null;
    }

    @NotNull
    public List<RunnerAndConfigurationSettings> getConfigurationSettingsList(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationSettingsList"));
        }
        LinkedHashSet<RunnerAndConfigurationSettings> set = new LinkedHashSet<RunnerAndConfigurationSettings>();
        for (RunnerAndConfigurationSettings configuration : this.getSortedConfigurations()) {
            ConfigurationType configurationType = configuration.getType();
            if (configurationType == null || !type.getId().equals(configurationType.getId())) continue;
            set.add(configuration);
        }
        List<RunnerAndConfigurationSettings> list = Collections.unmodifiableList(new ArrayList(set));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationSettingsList"));
        }
        return list;
    }

    @NotNull
    public RunnerAndConfigurationSettings[] getConfigurationSettings(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationSettings"));
        }
        List<RunnerAndConfigurationSettings> list = this.getConfigurationSettingsList(type);
        RunnerAndConfigurationSettings[] runnerAndConfigurationSettingsArray = list.toArray(new RunnerAndConfigurationSettings[list.size()]);
        if (runnerAndConfigurationSettingsArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationSettings"));
        }
        return runnerAndConfigurationSettingsArray;
    }

    @NotNull
    public RunConfiguration[] getConfigurations(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "getConfigurations"));
        }
        RunnerAndConfigurationSettings[] settings = this.getConfigurationSettings(type);
        RunConfiguration[] result = new RunConfiguration[settings.length];
        for (int i = 0; i < settings.length; ++i) {
            result[i] = settings[i].getConfiguration();
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurations"));
        }
        return result;
    }

    @Override
    @NotNull
    public Map<String, List<RunnerAndConfigurationSettings>> getStructure(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "getStructure"));
        }
        LinkedHashMap<String, ArrayList<RunnerAndConfigurationSettings>> map = new LinkedHashMap<String, ArrayList<RunnerAndConfigurationSettings>>();
        ArrayList<RunnerAndConfigurationSettings> typeList = new ArrayList<RunnerAndConfigurationSettings>();
        List<RunnerAndConfigurationSettings> settings = this.getConfigurationSettingsList(type);
        for (RunnerAndConfigurationSettings setting : settings) {
            String folderName = setting.getFolderName();
            if (folderName == null) {
                typeList.add(setting);
                continue;
            }
            ArrayList<RunnerAndConfigurationSettings> list = (ArrayList<RunnerAndConfigurationSettings>)map.get(folderName);
            if (list == null) {
                list = new ArrayList<RunnerAndConfigurationSettings>();
                map.put(folderName, list);
            }
            list.add(setting);
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        result.put(null, Collections.unmodifiableList(typeList));
        Map<String, List<RunnerAndConfigurationSettings>> map2 = Collections.unmodifiableMap(result);
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getStructure"));
        }
        return map2;
    }

    @NotNull
    public RunnerAndConfigurationSettings getConfigurationTemplate(ConfigurationFactory factory) {
        RunnerAndConfigurationSettings template = this.myTemplateConfigurationsMap.get(factory.getType().getId() + "." + factory.getName());
        if (template == null) {
            template = new RunnerAndConfigurationSettingsImpl(this, factory.createTemplateConfiguration(this.myProject, (RunManager)this), true);
            template.setSingleton(factory.isConfigurationSingletonByDefault());
            if (template.getConfiguration() instanceof UnknownRunConfiguration) {
                ((UnknownRunConfiguration)template.getConfiguration()).setDoNotStore(true);
            }
            this.myTemplateConfigurationsMap.put(factory.getType().getId() + "." + factory.getName(), template);
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = template;
        if (runnerAndConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationTemplate"));
        }
        return runnerAndConfigurationSettings;
    }

    @Override
    public void addConfiguration(RunnerAndConfigurationSettings settings, boolean shared, List<BeforeRunTask> tasks, boolean addEnabledTemplateTasksIfAbsent) {
        RunConfiguration configuration = settings.getConfiguration();
        String existingId = this.findExistingConfigurationId(settings);
        String newId = settings.getUniqueID();
        RunnerAndConfigurationSettings existingSettings = null;
        if (existingId != null) {
            existingSettings = this.myConfigurations.remove(existingId);
            this.mySharedConfigurations.remove(existingId);
        }
        if (this.mySelectedConfigurationId != null && this.mySelectedConfigurationId.equals(existingId)) {
            this.setSelectedConfigurationId(newId);
        }
        this.myConfigurations.put(newId, settings);
        if (existingId == null) {
            this.refreshUsagesList((RunProfile)configuration);
        }
        this.checkRecentsLimit();
        this.mySharedConfigurations.put(newId, shared);
        this.setBeforeRunTasks(configuration, tasks, addEnabledTemplateTasksIfAbsent);
        if (existingSettings == settings) {
            ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationChanged(settings);
        } else {
            ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationAdded(settings);
        }
    }

    public void refreshUsagesList(RunProfile profile) {
        if (!(profile instanceof RunConfiguration)) {
            return;
        }
        RunnerAndConfigurationSettings settings = this.getSettings((RunConfiguration)profile);
        if (settings != null && settings.isTemporary()) {
            this.myRecentlyUsedTemporaries.remove((RunConfiguration)profile);
            this.myRecentlyUsedTemporaries.add(0, (RunConfiguration)profile);
            this.trimUsagesListToLimit();
        }
    }

    private void trimUsagesListToLimit() {
        while (this.myRecentlyUsedTemporaries.size() > this.getConfig().getRecentsLimit()) {
            this.myRecentlyUsedTemporaries.remove(this.myRecentlyUsedTemporaries.size() - 1);
        }
    }

    void checkRecentsLimit() {
        this.trimUsagesListToLimit();
        ArrayList<RunnerAndConfigurationSettings> removed = new ArrayList<RunnerAndConfigurationSettings>();
        block0: while (this.getTempConfigurationsList().size() > this.getConfig().getRecentsLimit()) {
            Iterator<Map.Entry<String, RunnerAndConfigurationSettings>> it = this.myConfigurations.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, RunnerAndConfigurationSettings> entry = it.next();
                if (!entry.getValue().isTemporary() || this.myRecentlyUsedTemporaries.contains(entry.getValue().getConfiguration())) continue;
                removed.add(entry.getValue());
                it.remove();
                continue block0;
            }
        }
        this.fireRunConfigurationsRemoved(removed);
    }

    public void setOrdered(boolean ordered) {
        this.myOrdered = ordered;
    }

    public void saveOrder() {
        this.myOrder.clear();
        for (RunnerAndConfigurationSettings each : this.myConfigurations.values()) {
            if (each.getType() instanceof UnknownConfigurationType) continue;
            this.myOrder.add((Object)each.getUniqueID());
        }
    }

    @Override
    public void removeConfiguration(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            return;
        }
        Iterator<RunnerAndConfigurationSettings> it = this.getSortedConfigurations().iterator();
        while (it.hasNext()) {
            RunnerAndConfigurationSettings configuration = it.next();
            if (!configuration.equals(settings)) continue;
            if (this.mySelectedConfigurationId != null && this.mySelectedConfigurationId == settings.getUniqueID()) {
                this.setSelectedConfiguration(null);
            }
            it.remove();
            this.mySharedConfigurations.remove(settings.getUniqueID());
            this.myConfigurationToBeforeTasksMap.remove(settings.getConfiguration());
            this.myRecentlyUsedTemporaries.remove(settings.getConfiguration());
            ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationRemoved(configuration);
            break;
        }
    }

    @Nullable
    public RunnerAndConfigurationSettings getSelectedConfiguration() {
        if (this.mySelectedConfigurationId == null && this.myLoadedSelectedConfigurationUniqueName != null) {
            this.setSelectedConfigurationId(this.myLoadedSelectedConfigurationUniqueName);
        }
        return this.mySelectedConfigurationId == null ? null : this.myConfigurations.get(this.mySelectedConfigurationId);
    }

    public void setSelectedConfiguration(@Nullable RunnerAndConfigurationSettings settings) {
        this.setSelectedConfigurationId(settings == null ? null : settings.getUniqueID());
        this.fireRunConfigurationSelected();
    }

    private void setSelectedConfigurationId(@Nullable String id) {
        this.mySelectedConfigurationId = id;
        if (this.mySelectedConfigurationId != null) {
            this.myLoadedSelectedConfigurationUniqueName = null;
        }
    }

    @Override
    @NotNull
    public Collection<RunnerAndConfigurationSettings> getSortedConfigurations() {
        if (!this.myOrdered) {
            ArrayList<Pair> order = new ArrayList<Pair>(this.myConfigurations.size());
            final ArrayList<String> folderNames = new ArrayList<String>();
            for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.myConfigurations.values()) {
                order.add(Pair.create((Object)runnerAndConfigurationSettings.getUniqueID(), (Object)runnerAndConfigurationSettings));
                String folderName = runnerAndConfigurationSettings.getFolderName();
                if (folderName == null || folderNames.contains(folderName)) continue;
                folderNames.add(folderName);
            }
            folderNames.add(null);
            this.myConfigurations.clear();
            if (this.myOrder.isEmpty()) {
                Collections.sort(order, new Comparator<Pair<String, RunnerAndConfigurationSettings>>(){

                    @Override
                    public int compare(Pair<String, RunnerAndConfigurationSettings> o1, Pair<String, RunnerAndConfigurationSettings> o2) {
                        boolean temporary2;
                        boolean temporary1 = ((RunnerAndConfigurationSettings)o1.getSecond()).isTemporary();
                        if (temporary1 == (temporary2 = ((RunnerAndConfigurationSettings)o2.getSecond()).isTemporary())) {
                            return ((String)o1.first).compareTo((String)o2.first);
                        }
                        return temporary1 ? 1 : -1;
                    }
                });
            } else {
                Collections.sort(order, new Comparator<Pair<String, RunnerAndConfigurationSettings>>(){

                    @Override
                    public int compare(Pair<String, RunnerAndConfigurationSettings> o1, Pair<String, RunnerAndConfigurationSettings> o2) {
                        boolean temporary2;
                        int i2;
                        int i1 = folderNames.indexOf(((RunnerAndConfigurationSettings)o1.getSecond()).getFolderName());
                        if (i1 != (i2 = folderNames.indexOf(((RunnerAndConfigurationSettings)o2.getSecond()).getFolderName()))) {
                            return i1 - i2;
                        }
                        boolean temporary1 = ((RunnerAndConfigurationSettings)o1.getSecond()).isTemporary();
                        if (temporary1 == (temporary2 = ((RunnerAndConfigurationSettings)o2.getSecond()).isTemporary())) {
                            int index1 = RunManagerImpl.this.myOrder.indexOf(o1.first);
                            int index2 = RunManagerImpl.this.myOrder.indexOf(o2.first);
                            if (index1 == -1 && index2 == -1) {
                                return ((RunnerAndConfigurationSettings)o1.second).getName().compareTo(((RunnerAndConfigurationSettings)o2.second).getName());
                            }
                            return index1 - index2;
                        }
                        return temporary1 ? 1 : -1;
                    }
                });
            }
            for (Pair pair : order) {
                RunnerAndConfigurationSettings setting = (RunnerAndConfigurationSettings)pair.second;
                this.myConfigurations.put(setting.getUniqueID(), setting);
            }
            this.myOrdered = true;
        }
        Collection<RunnerAndConfigurationSettings> collection = this.myConfigurations.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getSortedConfigurations"));
        }
        return collection;
    }

    public static boolean canRunConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "canRunConfiguration"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/RunManagerImpl", "canRunConfiguration"));
        }
        try {
            configuration.checkSettings(executor);
        }
        catch (RuntimeConfigurationError er) {
            return false;
        }
        catch (RuntimeConfigurationException e) {
            return true;
        }
        return true;
    }

    public void writeExternal(@NotNull Element parentNode) throws WriteExternalException {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "writeExternal"));
        }
        this.writeContext(parentNode);
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.myTemplateConfigurationsMap.values()) {
            if (runnerAndConfigurationSettings.getConfiguration() instanceof UnknownRunConfiguration && ((UnknownRunConfiguration)runnerAndConfigurationSettings.getConfiguration()).isDoNotStore()) continue;
            this.addConfigurationElement(parentNode, runnerAndConfigurationSettings);
        }
        Collection<RunnerAndConfigurationSettings> configurations = this.getStableConfigurations();
        for (RunnerAndConfigurationSettings configuration : configurations) {
            if (this.isConfigurationShared(configuration)) continue;
            this.addConfigurationElement(parentNode, configuration);
        }
        JDOMExternalizableStringList order = new JDOMExternalizableStringList();
        for (RunnerAndConfigurationSettings each : this.myConfigurations.values()) {
            if (each.getType() instanceof UnknownConfigurationType) continue;
            order.add((Object)each.getUniqueID());
        }
        order.writeExternal(parentNode);
        JDOMExternalizableStringList recentList = new JDOMExternalizableStringList();
        for (RunConfiguration each : this.myRecentlyUsedTemporaries) {
            RunnerAndConfigurationSettings settings;
            if (each.getType() instanceof UnknownConfigurationType || (settings = this.getSettings(each)) == null) continue;
            recentList.add((Object)settings.getUniqueID());
        }
        if (!recentList.isEmpty()) {
            Element recent = new Element(RECENT);
            parentNode.addContent(recent);
            recentList.writeExternal(recent);
        }
        if (this.myUnknownElements != null) {
            for (Element unloadedElement : this.myUnknownElements) {
                parentNode.addContent(unloadedElement.clone());
            }
        }
    }

    public void writeContext(Element parentNode) throws WriteExternalException {
        for (RunnerAndConfigurationSettings configurationSettings : this.myConfigurations.values()) {
            if (!configurationSettings.isTemporary()) continue;
            this.addConfigurationElement(parentNode, configurationSettings, CONFIGURATION);
        }
        RunnerAndConfigurationSettings selected = this.getSelectedConfiguration();
        if (selected != null) {
            parentNode.setAttribute(SELECTED_ATTR, selected.getUniqueID());
        }
    }

    void addConfigurationElement(Element parentNode, RunnerAndConfigurationSettings template) throws WriteExternalException {
        this.addConfigurationElement(parentNode, template, CONFIGURATION);
    }

    private void addConfigurationElement(Element parentNode, RunnerAndConfigurationSettings settings, String elementType) throws WriteExternalException {
        Element configurationElement = new Element(elementType);
        parentNode.addContent(configurationElement);
        ((RunnerAndConfigurationSettingsImpl)settings).writeExternal(configurationElement);
        if (!(settings.getConfiguration() instanceof UnknownRunConfiguration)) {
            List tasks = ContainerUtil.createLockFreeCopyOnWriteList(this.getBeforeRunTasks(settings.getConfiguration()));
            Element methodsElement = new Element(METHOD);
            HashMap templateTasks = new HashMap();
            List<BeforeRunTask> beforeRunTasks = settings.isTemplate() ? this.getHardcodedBeforeRunTasks(settings.getConfiguration()) : this.getBeforeRunTasks(this.getConfigurationTemplate(settings.getFactory()).getConfiguration());
            for (BeforeRunTask templateTask : beforeRunTasks) {
                templateTasks.put(templateTask.getProviderId(), templateTask);
                if (!templateTask.isEnabled()) continue;
                boolean found = false;
                for (BeforeRunTask realTask : tasks) {
                    if (realTask.getProviderId() != templateTask.getProviderId()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                BeforeRunTask clone = templateTask.clone();
                clone.setEnabled(false);
                tasks.add(0, clone);
            }
            int size = tasks.size();
            for (int i = 0; i < size; ++i) {
                BeforeRunTask task = (BeforeRunTask)tasks.get(i);
                int j = 0;
                BeforeRunTask templateTask = null;
                for (Map.Entry entry : templateTasks.entrySet()) {
                    if (entry.getKey() == task.getProviderId()) {
                        templateTask = (BeforeRunTask)entry.getValue();
                        break;
                    }
                    ++j;
                }
                if (task.equals(templateTask) && i == j) continue;
                Element child = new Element(OPTION);
                child.setAttribute(NAME_ATTR, task.getProviderId().toString());
                task.writeExternal(child);
                methodsElement.addContent(child);
            }
            configurationElement.addContent(methodsElement);
        }
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        this.clear();
        Comparator<Element> comparator = new Comparator<Element>(){

            @Override
            public int compare(Element a, Element b) {
                boolean bDefault;
                boolean aDefault = Boolean.valueOf(a.getAttributeValue("default", "false"));
                return aDefault == (bDefault = Boolean.valueOf(b.getAttributeValue("default", "false")).booleanValue()) ? 0 : (aDefault ? -1 : 1);
            }
        };
        List children = parentNode.getChildren();
        ArrayList<Element> sortedElements = new ArrayList<Element>();
        for (Object aChildren : children) {
            Element element = (Element)aChildren;
            if (!Comparing.strEqual((String)element.getName(), (String)CONFIGURATION)) continue;
            sortedElements.add(element);
        }
        Collections.sort(sortedElements, comparator);
        for (Element element : sortedElements) {
            RunnerAndConfigurationSettings configurationSettings = null;
            try {
                configurationSettings = this.loadConfiguration(element, false);
            }
            catch (Throwable e) {
                LOG.error(e);
                continue;
            }
            if (configurationSettings != null) continue;
            if (this.myUnknownElements == null) {
                this.myUnknownElements = new ArrayList<Element>(2);
            }
            this.myUnknownElements.add(element);
        }
        this.myOrder.readExternal(parentNode);
        block4: for (int i = 0; i < this.myOrder.size(); ++i) {
            String id = (String)this.myOrder.get(i);
            for (RunnerAndConfigurationSettings settings : this.myConfigurations.values()) {
                RunConfiguration configuration = settings.getConfiguration();
                if (configuration == null || !id.equals(configuration.getType().getDisplayName() + "." + configuration.getName() + (configuration instanceof UnknownRunConfiguration ? Integer.valueOf(configuration.getUniqueID()) : ""))) continue;
                this.myOrder.set(i, (Object)settings.getUniqueID());
                continue block4;
            }
        }
        this.myRecentlyUsedTemporaries.clear();
        Element recentNode = parentNode.getChild(RECENT);
        if (recentNode != null) {
            JDOMExternalizableStringList list = new JDOMExternalizableStringList();
            list.readExternal(recentNode);
            block6: for (int i = 0; i < list.size(); ++i) {
                String id = (String)list.get(i);
                for (RunnerAndConfigurationSettings settings : this.myConfigurations.values()) {
                    RunConfiguration configuration = settings.getConfiguration();
                    if (configuration == null || !id.equals(configuration.getType().getDisplayName() + "." + configuration.getName() + (configuration instanceof UnknownRunConfiguration ? Integer.valueOf(configuration.getUniqueID()) : ""))) continue;
                    list.set(i, (Object)settings.getUniqueID());
                    continue block6;
                }
            }
            for (String name : list) {
                RunnerAndConfigurationSettings settings = this.myConfigurations.get(name);
                if (settings == null) continue;
                this.myRecentlyUsedTemporaries.add(settings.getConfiguration());
            }
        }
        this.myOrdered = false;
        this.myLoadedSelectedConfigurationUniqueName = parentNode.getAttributeValue(SELECTED_ATTR);
        this.setSelectedConfigurationId(this.myLoadedSelectedConfigurationUniqueName);
        this.fireBeforeRunTasksUpdated();
        this.fireRunConfigurationSelected();
    }

    public void readContext(Element parentNode) throws InvalidDataException {
        this.myLoadedSelectedConfigurationUniqueName = parentNode.getAttributeValue(SELECTED_ATTR);
        Iterator i$ = parentNode.getChildren().iterator();
        while (i$.hasNext()) {
            Element aChildren;
            Element element = aChildren = (Element)i$.next();
            RunnerAndConfigurationSettings config = this.loadConfiguration(element, false);
            if (this.myLoadedSelectedConfigurationUniqueName != null || config == null || !Boolean.valueOf(element.getAttributeValue(SELECTED_ATTR)).booleanValue()) continue;
            this.myLoadedSelectedConfigurationUniqueName = config.getUniqueID();
        }
        this.setSelectedConfigurationId(this.myLoadedSelectedConfigurationUniqueName);
        this.fireRunConfigurationSelected();
    }

    @Nullable
    private String findExistingConfigurationId(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings != null) {
            for (Map.Entry<String, RunnerAndConfigurationSettings> entry : this.myConfigurations.entrySet()) {
                if (entry.getValue() != settings) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void clearAll() {
        this.clear();
        this.myTypesByName.clear();
        this.initializeConfigurationTypes(new ConfigurationType[0]);
    }

    private void clear() {
        ArrayList<RunnerAndConfigurationSettings> configurations = new ArrayList<RunnerAndConfigurationSettings>(this.myConfigurations.values());
        this.myConfigurations.clear();
        this.myUnknownElements = null;
        this.myConfigurationToBeforeTasksMap.clear();
        this.mySharedConfigurations.clear();
        this.myTemplateConfigurationsMap.clear();
        this.mySelectedConfigurationId = null;
        this.myLoadedSelectedConfigurationUniqueName = null;
        this.myIdToIcon.clear();
        this.myIconCheckTimes.clear();
        this.myIconCalcTime.clear();
        this.myRecentlyUsedTemporaries.clear();
        this.fireRunConfigurationsRemoved(configurations);
    }

    @Nullable
    public RunnerAndConfigurationSettings loadConfiguration(Element element, boolean isShared) throws InvalidDataException {
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(this);
        settings.readExternal(element);
        ConfigurationFactory factory = settings.getFactory();
        if (factory == null) {
            return null;
        }
        Element methodsElement = element.getChild(METHOD);
        List<BeforeRunTask> tasks = this.readStepsBeforeRun(methodsElement, settings);
        if (settings.isTemplate()) {
            this.myTemplateConfigurationsMap.put(factory.getType().getId() + "." + factory.getName(), settings);
            this.setBeforeRunTasks(settings.getConfiguration(), tasks, true);
        } else {
            this.addConfiguration(settings, isShared, tasks, true);
            if (Boolean.valueOf(element.getAttributeValue(SELECTED_ATTR)).booleanValue()) {
                this.setSelectedConfiguration(settings);
            }
        }
        return settings;
    }

    @NotNull
    private List<BeforeRunTask> readStepsBeforeRun(Element child, RunnerAndConfigurationSettings settings) {
        ArrayList<BeforeRunTask> result = new ArrayList<BeforeRunTask>();
        if (child != null) {
            for (Element o : child.getChildren(OPTION)) {
                Element methodElement = o;
                String providerName = methodElement.getAttributeValue(NAME_ATTR);
                Key<? extends BeforeRunTask> id = this.getProviderKey(providerName);
                BeforeRunTaskProvider provider = this.getProvider(id);
                BeforeRunTask beforeRunTask = provider.createTask(settings.getConfiguration());
                if (beforeRunTask == null) continue;
                beforeRunTask.readExternal(methodElement);
                result.add(beforeRunTask);
            }
        }
        ArrayList<BeforeRunTask> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "readStepsBeforeRun"));
        }
        return arrayList;
    }

    @Nullable
    public ConfigurationType getConfigurationType(String typeName) {
        return this.myTypesByName.get(typeName);
    }

    @Nullable
    public ConfigurationFactory getFactory(String typeName, String factoryName) {
        return this.getFactory(typeName, factoryName, false);
    }

    @Nullable
    public ConfigurationFactory getFactory(String typeName, String factoryName, boolean checkUnknown) {
        ConfigurationType type = this.myTypesByName.get(typeName);
        if (type == null && checkUnknown && typeName != null) {
            UnknownFeaturesCollector.getInstance(this.myProject).registerUnknownRunConfiguration(typeName);
        }
        if (factoryName == null) {
            factoryName = type != null ? type.getConfigurationFactories()[0].getName() : null;
        }
        return this.findFactoryOfTypeNameByName(typeName, factoryName);
    }

    @Nullable
    private ConfigurationFactory findFactoryOfTypeNameByName(String typeName, String factoryName) {
        ConfigurationType type = this.myTypesByName.get(typeName);
        if (type == null) {
            type = this.myTypesByName.get("Unknown");
        }
        return RunManagerImpl.findFactoryOfTypeByName(type, factoryName);
    }

    @Nullable
    private static ConfigurationFactory findFactoryOfTypeByName(ConfigurationType type, String factoryName) {
        ConfigurationFactory[] factories;
        if (factoryName == null) {
            return null;
        }
        if (type instanceof UnknownConfigurationType) {
            return type.getConfigurationFactories()[0];
        }
        for (ConfigurationFactory factory : factories = type.getConfigurationFactories()) {
            if (!factoryName.equals(factory.getName())) continue;
            return factory;
        }
        return null;
    }

    @NotNull
    public String getComponentName() {
        if ("RunManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getComponentName"));
        }
        return "RunManager";
    }

    @Override
    public void setTemporaryConfiguration(@Nullable RunnerAndConfigurationSettings tempConfiguration) {
        if (tempConfiguration == null) {
            return;
        }
        tempConfiguration.setTemporary(true);
        this.addConfiguration(tempConfiguration, this.isConfigurationShared(tempConfiguration), this.getBeforeRunTasks(tempConfiguration.getConfiguration()), false);
        this.setSelectedConfiguration(tempConfiguration);
    }

    Collection<RunnerAndConfigurationSettings> getStableConfigurations() {
        LinkedHashMap<String, RunnerAndConfigurationSettings> result = new LinkedHashMap<String, RunnerAndConfigurationSettings>(this.myConfigurations);
        Iterator it = result.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!((RunnerAndConfigurationSettings)entry.getValue()).isTemporary()) continue;
            it.remove();
        }
        return result.values();
    }

    @NotNull
    Collection<? extends RunnerAndConfigurationSettings> getConfigurationSettings() {
        Collection<RunnerAndConfigurationSettings> collection = this.myConfigurations.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationSettings"));
        }
        return collection;
    }

    public boolean isTemporary(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "isTemporary"));
        }
        return Arrays.asList(this.getTempConfigurations()).contains(configuration);
    }

    @NotNull
    public List<RunnerAndConfigurationSettings> getTempConfigurationsList() {
        List configurations = ContainerUtil.filter(this.myConfigurations.values(), (Condition)new Condition<RunnerAndConfigurationSettings>(){

            public boolean value(RunnerAndConfigurationSettings settings) {
                return settings.isTemporary();
            }
        });
        List<RunnerAndConfigurationSettings> list = Collections.unmodifiableList(configurations);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getTempConfigurationsList"));
        }
        return list;
    }

    @NotNull
    public RunConfiguration[] getTempConfigurations() {
        List<RunnerAndConfigurationSettings> list = this.getTempConfigurationsList();
        RunConfiguration[] result = new RunConfiguration[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).getConfiguration();
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getTempConfigurations"));
        }
        return result;
    }

    public void makeStable(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "makeStable"));
        }
        settings.setTemporary(false);
        this.myRecentlyUsedTemporaries.remove(settings.getConfiguration());
        if (!this.myOrder.isEmpty()) {
            this.setOrdered(false);
        }
        this.fireRunConfigurationChanged(settings);
    }

    public void makeStable(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "makeStable"));
        }
        RunnerAndConfigurationSettings settings = this.getSettings(configuration);
        if (settings != null) {
            this.makeStable(settings);
        }
    }

    @NotNull
    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull String name, @NotNull ConfigurationFactory type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "createRunConfiguration"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/RunManagerImpl", "createRunConfiguration"));
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.createConfiguration(name, type);
        if (runnerAndConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "createRunConfiguration"));
        }
        return runnerAndConfigurationSettings;
    }

    @Override
    public boolean isConfigurationShared(RunnerAndConfigurationSettings settings) {
        Boolean shared = this.mySharedConfigurations.get(settings.getUniqueID());
        if (shared == null) {
            RunnerAndConfigurationSettings template = this.getConfigurationTemplate(settings.getFactory());
            shared = this.mySharedConfigurations.get(template.getUniqueID());
        }
        return shared != null && shared != false;
    }

    @Override
    @NotNull
    public <T extends BeforeRunTask> List<T> getBeforeRunTasks(Key<T> taskProviderID) {
        ArrayList<BeforeRunTask> tasks = new ArrayList<BeforeRunTask>();
        ArrayList<RunnerAndConfigurationSettings> checkedTemplates = new ArrayList<RunnerAndConfigurationSettings>();
        ArrayList<RunnerAndConfigurationSettings> settingsList = new ArrayList<RunnerAndConfigurationSettings>(this.myConfigurations.values());
        for (RunnerAndConfigurationSettings settings : settingsList) {
            List<BeforeRunTask> runTasks = this.getBeforeRunTasks(settings.getConfiguration());
            for (BeforeRunTask task : runTasks) {
                if (task != null && task.isEnabled() && task.getProviderId() == taskProviderID) {
                    tasks.add(task);
                    continue;
                }
                RunnerAndConfigurationSettings template = this.getConfigurationTemplate(settings.getFactory());
                if (checkedTemplates.contains(template)) continue;
                checkedTemplates.add(template);
                List<BeforeRunTask> templateTasks = this.getBeforeRunTasks(template.getConfiguration());
                for (BeforeRunTask templateTask : templateTasks) {
                    if (templateTask == null || !templateTask.isEnabled() || templateTask.getProviderId() != taskProviderID) continue;
                    tasks.add(templateTask);
                }
            }
        }
        ArrayList<BeforeRunTask> arrayList = tasks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getBeforeRunTasks"));
        }
        return arrayList;
    }

    @Override
    public Icon getConfigurationIcon(final @NotNull RunnerAndConfigurationSettings settings) {
        Icon icon;
        String selectedId;
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "getConfigurationIcon"));
        }
        final String uniqueID = settings.getUniqueID();
        RunnerAndConfigurationSettings selectedConfiguration = this.getSelectedConfiguration();
        String string = selectedId = selectedConfiguration != null ? selectedConfiguration.getUniqueID() : "";
        if (selectedId.equals(uniqueID)) {
            Long lastCheckTime = this.myIconCheckTimes.get(uniqueID);
            Long calcTime = this.myIconCalcTime.get(uniqueID);
            if (calcTime == null || calcTime < 150L) {
                calcTime = 150L;
            }
            if (lastCheckTime == null || System.currentTimeMillis() - lastCheckTime > calcTime * 10L) {
                this.myIdToIcon.remove(uniqueID);
            }
        }
        if ((icon = this.myIdToIcon.get(uniqueID)) == null) {
            icon = IconDeferrer.getInstance().deferAutoUpdatable(settings.getConfiguration().getIcon(), (Object)(this.myProject.hashCode() ^ settings.hashCode()), (Function)new Function<Integer, Icon>(){

                public Icon fun(Integer param) {
                    Icon icon;
                    if (RunManagerImpl.this.myProject.isDisposed()) {
                        return null;
                    }
                    RunManagerImpl.this.myIconCalcTime.remove(uniqueID);
                    long startTime = System.currentTimeMillis();
                    try {
                        settings.checkSettings();
                        icon = ProgramRunnerUtil.getConfigurationIcon(settings, false);
                    }
                    catch (RuntimeConfigurationException e) {
                        icon = ProgramRunnerUtil.getConfigurationIcon(settings, true);
                    }
                    RunManagerImpl.this.myIconCalcTime.put(uniqueID, System.currentTimeMillis() - startTime);
                    return icon;
                }
            });
            this.myIdToIcon.put(uniqueID, icon);
            this.myIconCheckTimes.put(uniqueID, System.currentTimeMillis());
        }
        return icon;
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettings findConfigurationByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (RunnerAndConfigurationSettings each : this.myConfigurations.values()) {
            if (!name.equals(each.getName())) continue;
            return each;
        }
        return null;
    }

    @Override
    @NotNull
    public <T extends BeforeRunTask> List<T> getBeforeRunTasks(RunConfiguration settings, Key<T> taskProviderID) {
        if (settings instanceof WrappingRunConfiguration) {
            List<T> list = this.getBeforeRunTasks(((WrappingRunConfiguration)settings).getPeer(), taskProviderID);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getBeforeRunTasks"));
            }
            return list;
        }
        List<BeforeRunTask> tasks = this.myConfigurationToBeforeTasksMap.get(settings);
        if (tasks == null) {
            tasks = this.getBeforeRunTasks(settings);
            this.myConfigurationToBeforeTasksMap.put(settings, tasks);
        }
        ArrayList<BeforeRunTask> result = new ArrayList<BeforeRunTask>();
        for (BeforeRunTask task : tasks) {
            if (task.getProviderId() != taskProviderID) continue;
            result.add(task);
        }
        ArrayList<BeforeRunTask> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getBeforeRunTasks"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<BeforeRunTask> getBeforeRunTasks(RunConfiguration settings) {
        if (settings instanceof WrappingRunConfiguration) {
            List<BeforeRunTask> list = this.getBeforeRunTasks(((WrappingRunConfiguration)settings).getPeer());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getBeforeRunTasks"));
            }
            return list;
        }
        List<BeforeRunTask> tasks = this.myConfigurationToBeforeTasksMap.get(settings);
        if (tasks != null) {
            List<BeforeRunTask> list = RunManagerImpl.getCopies(tasks);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getBeforeRunTasks"));
            }
            return list;
        }
        List<BeforeRunTask> list = this.getTemplateBeforeRunTasks(settings);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getBeforeRunTasks"));
        }
        return list;
    }

    private List<BeforeRunTask> getTemplateBeforeRunTasks(RunConfiguration settings) {
        RunnerAndConfigurationSettings template = this.getConfigurationTemplate(settings.getFactory());
        List<BeforeRunTask> templateTasks = this.myConfigurationToBeforeTasksMap.get(template.getConfiguration());
        return templateTasks != null ? RunManagerImpl.getCopies(templateTasks) : this.getHardcodedBeforeRunTasks(settings);
    }

    private List<BeforeRunTask> getHardcodedBeforeRunTasks(RunConfiguration settings) {
        ArrayList<BeforeRunTask> _tasks = new ArrayList<BeforeRunTask>();
        for (BeforeRunTaskProvider provider : (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject)) {
            BeforeRunTask task = provider.createTask(settings);
            if (task == null || !task.isEnabled()) continue;
            Key providerID = provider.getId();
            settings.getFactory().configureBeforeRunTaskDefaults(providerID, task);
            if (!task.isEnabled()) continue;
            _tasks.add(task);
        }
        return _tasks;
    }

    @NotNull
    private static List<BeforeRunTask> getCopies(List<BeforeRunTask> original) {
        ArrayList<BeforeRunTask> result = new ArrayList<BeforeRunTask>();
        if (original != null) {
            for (BeforeRunTask task : original) {
                if (!task.isEnabled()) continue;
                result.add(task.clone());
            }
        }
        ArrayList<BeforeRunTask> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getCopies"));
        }
        return arrayList;
    }

    public void shareConfiguration(RunnerAndConfigurationSettings settings, boolean shareConfiguration) {
        boolean shouldFire;
        boolean bl = shouldFire = settings != null && this.isConfigurationShared(settings) != shareConfiguration;
        if (shareConfiguration && settings.isTemporary()) {
            this.makeStable(settings);
        }
        this.mySharedConfigurations.put(settings.getUniqueID(), shareConfiguration);
        if (shouldFire) {
            this.fireRunConfigurationChanged(settings);
        }
    }

    @Override
    public final void setBeforeRunTasks(RunConfiguration runConfiguration, @NotNull List<BeforeRunTask> tasks, boolean addEnabledTemplateTasksIfAbsent) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/impl/RunManagerImpl", "setBeforeRunTasks"));
        }
        ArrayList<BeforeRunTask> result = new ArrayList<BeforeRunTask>(tasks);
        if (addEnabledTemplateTasksIfAbsent) {
            List<BeforeRunTask> templates = this.getTemplateBeforeRunTasks(runConfiguration);
            HashSet<Key> idsToSet = new HashSet<Key>();
            for (BeforeRunTask task : tasks) {
                idsToSet.add(task.getProviderId());
            }
            int i = 0;
            for (BeforeRunTask template : templates) {
                if (idsToSet.contains(template.getProviderId())) continue;
                result.add(i, template);
                ++i;
            }
        }
        this.myConfigurationToBeforeTasksMap.put(runConfiguration, result.isEmpty() ? Collections.emptyList() : result);
        this.fireBeforeRunTasksUpdated();
    }

    public final void resetBeforeRunTasks(RunConfiguration runConfiguration) {
        this.myConfigurationToBeforeTasksMap.remove(runConfiguration);
        this.fireBeforeRunTasksUpdated();
    }

    public void addConfiguration(RunnerAndConfigurationSettings settings, boolean isShared) {
        this.addConfiguration(settings, isShared, this.getTemplateBeforeRunTasks(settings.getConfiguration()), false);
    }

    public static RunManagerImpl getInstanceImpl(Project project) {
        return (RunManagerImpl)RunManager.getInstance((Project)project);
    }

    void removeNotExistingSharedConfigurations(Set<String> existing) {
        ArrayList<RunnerAndConfigurationSettings> removed = new ArrayList<RunnerAndConfigurationSettings>();
        Iterator<Map.Entry<String, RunnerAndConfigurationSettings>> it = this.myConfigurations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, RunnerAndConfigurationSettings> entry = it.next();
            RunnerAndConfigurationSettings settings = entry.getValue();
            if (settings.isTemplate() || !this.isConfigurationShared(settings) || existing.contains(settings.getUniqueID())) continue;
            removed.add(settings);
            it.remove();
        }
        this.fireRunConfigurationsRemoved(removed);
    }

    public void fireRunConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "fireRunConfigurationChanged"));
        }
        ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationChanged(settings);
    }

    private void fireRunConfigurationsRemoved(@NotNull List<RunnerAndConfigurationSettings> removed) {
        if (removed == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/impl/RunManagerImpl", "fireRunConfigurationsRemoved"));
        }
        this.myRecentlyUsedTemporaries.removeAll(removed);
        for (RunnerAndConfigurationSettings settings : removed) {
            ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationRemoved(settings);
        }
    }

    private void fireRunConfigurationSelected() {
        ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationSelected();
    }

    @Override
    public void addRunManagerListener(RunManagerListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeRunManagerListener(RunManagerListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void fireBeforeRunTasksUpdated() {
        ((RunManagerListener)this.myDispatcher.getMulticaster()).beforeRunTasksChanged();
    }

    @NotNull
    private synchronized BeforeRunTaskProvider getProvider(Key<? extends BeforeRunTask> providerId) {
        if (this.myBeforeStepsMap == null) {
            this.initProviderMaps();
        }
        BeforeRunTaskProvider beforeRunTaskProvider = this.myBeforeStepsMap.get(providerId);
        if (beforeRunTaskProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getProvider"));
        }
        return beforeRunTaskProvider;
    }

    @NotNull
    private synchronized Key<? extends BeforeRunTask> getProviderKey(String keyString) {
        Key<? extends BeforeRunTask> id;
        if (this.myProviderKeysMap == null) {
            this.initProviderMaps();
        }
        if ((id = this.myProviderKeysMap.get(keyString)) == null) {
            UnknownBeforeRunTaskProvider provider = new UnknownBeforeRunTaskProvider(keyString);
            id = provider.getId();
            this.myProviderKeysMap.put(keyString, id);
            this.myBeforeStepsMap.put(id, provider);
        }
        Key<? extends BeforeRunTask> key = id;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunManagerImpl", "getProviderKey"));
        }
        return key;
    }

    private void initProviderMaps() {
        this.myBeforeStepsMap = new LinkedHashMap<Key<? extends BeforeRunTask>, BeforeRunTaskProvider>();
        this.myProviderKeysMap = new LinkedHashMap<String, Key<? extends BeforeRunTask>>();
        for (BeforeRunTaskProvider provider : (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject)) {
            Key id = provider.getId();
            this.myBeforeStepsMap.put((Key<? extends BeforeRunTask>)id, provider);
            this.myProviderKeysMap.put(id.toString(), (Key<? extends BeforeRunTask>)id);
        }
    }
}

