/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.GutterContentProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Getter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LineSeparatorPainter
extends RangeMarkerImpl
implements RangeHighlighterEx,
Getter<RangeHighlighterEx> {
    private final GutterContentProvider gutterContentProvider;
    private final CustomHighlighterRenderer renderer;
    private final MarkupModelEx markupModel;

    public LineSeparatorPainter(GutterContentProvider gutterContentProvider, @NotNull EditorEx editor, int endOffset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LineSeparatorPainter", "<init>"));
        }
        super(editor.getDocument(), 0, endOffset, false);
        this.renderer = new CustomHighlighterRenderer(){

            public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
                int endLine;
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LineSeparatorPainter$1", "paint"));
                }
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LineSeparatorPainter$1", "paint"));
                }
                if (g == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/LineSeparatorPainter$1", "paint"));
                }
                Rectangle clip = g.getClipBounds();
                int lineHeight = editor.getLineHeight();
                int startLine = clip.y / lineHeight;
                if (startLine >= (endLine = Math.min((clip.y + clip.height) / lineHeight + 1, ((EditorImpl)editor).getVisibleLineCount()))) {
                    return;
                }
                int actualStartLine = startLine == 0 ? 0 : startLine - 1;
                int y = (actualStartLine + 1) * lineHeight;
                g.setColor(editor.getColorsScheme().getColor(EditorColors.INDENT_GUIDE_COLOR));
                for (int visualLine = actualStartLine; visualLine < endLine; ++visualLine) {
                    if (LineSeparatorPainter.this.gutterContentProvider.isShowSeparatorLine(editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLine, (int)0)).line, editor)) {
                        g.drawLine(clip.x, y, clip.x + clip.width, y);
                    }
                    y += lineHeight;
                }
            }
        };
        this.gutterContentProvider = gutterContentProvider;
        this.markupModel = editor.getMarkupModel();
        this.registerInTree(0, endOffset, false, false, 3000);
    }

    @Override
    protected void changedUpdateImpl(DocumentEvent e) {
        this.setIntervalEnd(this.myDocument.getTextLength());
    }

    @Override
    public boolean setValid(boolean value) {
        return super.setValid(value);
    }

    @Override
    public boolean isAfterEndOfLine() {
        return false;
    }

    @Override
    public void setAfterEndOfLine(boolean value) {
    }

    @Override
    public int getAffectedAreaStartOffset() {
        return 0;
    }

    @Override
    public int getAffectedAreaEndOffset() {
        return this.myDocument.getTextLength();
    }

    @Override
    public void setTextAttributes(@NotNull TextAttributes textAttributes) {
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LineSeparatorPainter", "setTextAttributes"));
        }
    }

    @NotNull
    public HighlighterTargetArea getTargetArea() {
        HighlighterTargetArea highlighterTargetArea = HighlighterTargetArea.EXACT_RANGE;
        if (highlighterTargetArea == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LineSeparatorPainter", "getTargetArea"));
        }
        return highlighterTargetArea;
    }

    @Nullable
    public TextAttributes getTextAttributes() {
        return null;
    }

    @Nullable
    public LineMarkerRenderer getLineMarkerRenderer() {
        return null;
    }

    public void setLineMarkerRenderer(@Nullable LineMarkerRenderer renderer) {
    }

    @Nullable
    public CustomHighlighterRenderer getCustomRenderer() {
        return this.renderer;
    }

    public void setCustomRenderer(CustomHighlighterRenderer renderer) {
    }

    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return null;
    }

    public void setGutterIconRenderer(@Nullable GutterIconRenderer renderer) {
    }

    @Nullable
    public Color getErrorStripeMarkColor() {
        return null;
    }

    public void setErrorStripeMarkColor(@Nullable Color color) {
    }

    @Nullable
    public Object getErrorStripeTooltip() {
        return null;
    }

    public void setErrorStripeTooltip(@Nullable Object tooltipObject) {
    }

    public boolean isThinErrorStripeMark() {
        return false;
    }

    public void setThinErrorStripeMark(boolean value) {
    }

    @Nullable
    public Color getLineSeparatorColor() {
        return null;
    }

    public void setLineSeparatorColor(@Nullable Color color) {
    }

    public void setLineSeparatorRenderer(LineSeparatorRenderer renderer) {
    }

    public LineSeparatorRenderer getLineSeparatorRenderer() {
        return null;
    }

    @Nullable
    public SeparatorPlacement getLineSeparatorPlacement() {
        return null;
    }

    public void setLineSeparatorPlacement(@Nullable SeparatorPlacement placement) {
    }

    public void setEditorFilter(@NotNull MarkupEditorFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LineSeparatorPainter", "setEditorFilter"));
        }
    }

    @NotNull
    public MarkupEditorFilter getEditorFilter() {
        MarkupEditorFilter markupEditorFilter = MarkupEditorFilter.EMPTY;
        if (markupEditorFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LineSeparatorPainter", "getEditorFilter"));
        }
        return markupEditorFilter;
    }

    public RangeHighlighterEx get() {
        return this;
    }

    @Override
    protected void registerInTree(int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        this.markupModel.addRangeHighlighter(this, start, end, greedyToLeft, greedyToRight, layer);
    }

    @Override
    protected boolean unregisterInTree() {
        if (!this.isValid()) {
            return false;
        }
        this.markupModel.removeHighlighter(this);
        return true;
    }
}

