/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.util.DocumentUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageConsoleImpl
implements Disposable,
TypeSafeDataProvider {
    private static final int SEPARATOR_THICKNESS = 1;
    private final Project myProject;
    private final EditorEx myConsoleEditor;
    private final EditorEx myHistoryViewer;
    private final Document myEditorDocument;
    private final LightVirtualFile myVirtualFile;
    protected PsiFile myFile;
    private final JPanel myPanel;
    private String myTitle;
    @Nullable
    private String myPrompt;
    private TextAttributes myPromptAttributes;
    private final LightVirtualFile myHistoryFile;
    private Editor myCurrentEditor;
    private final AtomicBoolean myForceScrollToEnd;
    private final SingleAlarm myUpdateQueue;
    private Runnable myUiUpdateRunnable;
    private boolean myShowSeparatorLine;
    private final FocusChangeListener myFocusListener;

    public LanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        this(project, title, language, true);
    }

    public LanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull Language language, boolean initComponents) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        this(project, title, new LightVirtualFile(title, language, (CharSequence)""), initComponents);
    }

    public LanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull LightVirtualFile lightFile, boolean initComponents) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (lightFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        this(project, title, lightFile, initComponents, null);
    }

    LanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull LightVirtualFile lightFile, boolean initComponents, @Nullable PairFunction<VirtualFile, Project, PsiFile> psiFileFactory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (lightFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        this.myPanel = new JPanel((LayoutManager)((Object)new MyLayout()));
        this.myPrompt = "> ";
        this.myPromptAttributes = ConsoleViewContentType.USER_INPUT.getAttributes();
        this.myForceScrollToEnd = new AtomicBoolean(false);
        this.myShowSeparatorLine = true;
        this.myFocusListener = new FocusChangeListener(){

            @Override
            public void focusGained(Editor editor) {
                LanguageConsoleImpl.this.myCurrentEditor = editor;
            }

            @Override
            public void focusLost(Editor editor) {
            }
        };
        this.myProject = project;
        this.myTitle = title;
        this.myVirtualFile = lightFile;
        EditorFactory editorFactory = EditorFactory.getInstance();
        this.myHistoryFile = new LightVirtualFile(this.getTitle() + ".history.txt", (FileType)FileTypes.PLAIN_TEXT, (CharSequence)"");
        this.myEditorDocument = FileDocumentManager.getInstance().getDocument((VirtualFile)lightFile);
        assert (this.myEditorDocument != null);
        this.myFile = psiFileFactory == null ? this.createFile(this.myVirtualFile, this.myEditorDocument, this.myProject) : (PsiFile)psiFileFactory.fun((Object)this.myVirtualFile, (Object)this.myProject);
        this.myConsoleEditor = (EditorEx)editorFactory.createEditor(this.myEditorDocument, this.myProject);
        this.myConsoleEditor.addFocusListener(this.myFocusListener);
        this.myCurrentEditor = this.myConsoleEditor;
        this.myHistoryViewer = (EditorEx)editorFactory.createViewer(((EditorFactoryImpl)editorFactory).createDocument(true), this.myProject);
        this.myUpdateQueue = new SingleAlarm(new Runnable(){

            @Override
            public void run() {
                if (LanguageConsoleImpl.this.isConsoleEditorEnabled()) {
                    LanguageConsoleImpl.this.myPanel.revalidate();
                    LanguageConsoleImpl.this.myPanel.repaint();
                }
                if (LanguageConsoleImpl.this.myUiUpdateRunnable != null) {
                    LanguageConsoleImpl.this.myUiUpdateRunnable.run();
                }
            }
        }, 300, this);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                LanguageConsoleImpl.this.installEditorFactoryListener();
            }
        }, this.myProject.getDisposed());
        if (initComponents) {
            this.initComponents();
        }
    }

    public void initComponents() {
        this.setupComponents();
        this.myPanel.add(this.myHistoryViewer.getComponent());
        this.myPanel.add(this.myConsoleEditor.getComponent());
        DataManager.registerDataProvider((JComponent)this.myPanel, (DataProvider)new TypeSafeDataProviderAdapter(this));
        this.myHistoryViewer.getComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (LanguageConsoleImpl.this.myForceScrollToEnd.compareAndSet(true, false)) {
                    LanguageConsoleImpl.this.scrollHistoryToEnd();
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.componentResized(e);
            }
        });
        this.setPromptInner(this.myPrompt);
    }

    public void setConsoleEditorEnabled(boolean consoleEditorEnabled) {
        if (this.isConsoleEditorEnabled() == consoleEditorEnabled) {
            return;
        }
        if (consoleEditorEnabled) {
            FileEditorManager.getInstance((Project)this.getProject()).closeFile((VirtualFile)this.myVirtualFile);
            this.myPanel.removeAll();
            this.myPanel.add(this.myHistoryViewer.getComponent());
            this.myPanel.add(this.myConsoleEditor.getComponent());
            this.myHistoryViewer.setHorizontalScrollbarVisible(false);
            this.myCurrentEditor = this.myConsoleEditor;
        } else {
            this.myPanel.removeAll();
            this.myPanel.add((Component)this.myHistoryViewer.getComponent(), "Center");
            this.myHistoryViewer.setHorizontalScrollbarVisible(true);
        }
    }

    public void setShowSeparatorLine(boolean showSeparatorLine) {
        this.myShowSeparatorLine = showSeparatorLine;
    }

    private void setupComponents() {
        this.setupEditorDefault(this.myConsoleEditor);
        this.setupEditorDefault(this.myHistoryViewer);
        if (this.myShowSeparatorLine) {
            this.myHistoryViewer.getComponent().setBorder((Border)new SideBorder((Color)JBColor.LIGHT_GRAY, 8));
        }
        this.myHistoryViewer.getComponent().setMinimumSize(new Dimension(0, 0));
        this.myHistoryViewer.getComponent().setPreferredSize(new Dimension(0, 0));
        this.myHistoryViewer.setCaretEnabled(false);
        this.myConsoleEditor.setHorizontalScrollbarVisible(true);
        this.myConsoleEditor.addEditorMouseListener((EditorMouseListener)EditorActionUtil.createEditorPopupHandler("ConsoleEditorPopupMenu"));
        this.myConsoleEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter((VirtualFile)this.myVirtualFile, this.myConsoleEditor.getColorsScheme(), this.myProject));
        this.myConsoleEditor.getScrollingModel().addVisibleAreaListener(new VisibleAreaListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visibleAreaChanged(VisibleAreaEvent e) {
                int offset = LanguageConsoleImpl.this.myConsoleEditor.getScrollingModel().getHorizontalScrollOffset();
                ScrollingModelEx model = LanguageConsoleImpl.this.myHistoryViewer.getScrollingModel();
                int historyOffset = model.getHorizontalScrollOffset();
                if (historyOffset != offset) {
                    try {
                        model.disableAnimation();
                        model.scrollHorizontally(offset);
                    }
                    finally {
                        model.enableAnimation();
                    }
                }
            }
        });
        DocumentAdapter docListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                LanguageConsoleImpl.this.queueUiUpdate(false);
            }
        };
        this.myEditorDocument.addDocumentListener((DocumentListener)docListener, (Disposable)this);
        this.myHistoryViewer.getDocument().addDocumentListener((DocumentListener)docListener, this);
        this.myHistoryViewer.getContentComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                if (LanguageConsoleImpl.this.isConsoleEditorEnabled() && UIUtil.isReallyTypedEvent((KeyEvent)event)) {
                    LanguageConsoleImpl.this.myConsoleEditor.getContentComponent().requestFocus();
                    LanguageConsoleImpl.this.myConsoleEditor.processKeyTyped(event);
                }
            }
        });
        for (AnAction action : this.createActions()) {
            action.registerCustomShortcutSet(action.getShortcutSet(), this.myConsoleEditor.getComponent());
        }
        EmptyAction.registerActionShortcuts((JComponent)this.myHistoryViewer.getComponent(), (JComponent)this.myConsoleEditor.getComponent());
    }

    public boolean isConsoleEditorEnabled() {
        return this.myPanel.getComponentCount() > 1;
    }

    @Deprecated
    @NotNull
    protected AnAction[] createActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "createActions"));
        }
        return AnAction.EMPTY_ARRAY;
    }

    @Deprecated
    public void setTextToEditor(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "setTextToEditor"));
        }
        this.setInputText(text);
    }

    protected void setupEditorDefault(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "setupEditorDefault"));
        }
        ConsoleViewUtil.setupConsoleEditor(editor, false, false);
        editor.getContentComponent().setFocusCycleRoot(false);
        editor.setHorizontalScrollbarVisible(false);
        editor.setVerticalScrollbarVisible(true);
        editor.setBorder(null);
        EditorSettings editorSettings = editor.getSettings();
        if (this.myHistoryViewer != editor) {
            editorSettings.setAdditionalLinesCount(1);
        }
        editorSettings.setAdditionalColumnsCount(1);
    }

    public void setUiUpdateRunnable(Runnable uiUpdateRunnable) {
        assert (this.myUiUpdateRunnable == null) : "can be set only once";
        this.myUiUpdateRunnable = uiUpdateRunnable;
    }

    public void flushAllUiUpdates() {
        this.myUpdateQueue.flush();
    }

    @Deprecated
    @NotNull
    public LightVirtualFile getHistoryFile() {
        LightVirtualFile lightVirtualFile = this.myHistoryFile;
        if (lightVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getHistoryFile"));
        }
        return lightVirtualFile;
    }

    @Nullable
    public String getPrompt() {
        return this.myPrompt;
    }

    public void setPromptAttributes(@NotNull TextAttributes textAttributes) {
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "setPromptAttributes"));
        }
        this.myPromptAttributes = textAttributes;
    }

    public void setPrompt(@Nullable String prompt) {
        this.myPrompt = prompt != null && !prompt.endsWith(" ") ? prompt + " " : prompt;
        this.setPromptInner(this.myPrompt);
    }

    private void setPromptInner(final @Nullable String prompt) {
        this.myUpdateQueue.checkDisposed();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                LanguageConsoleImpl.this.myConsoleEditor.setPrefixTextAndAttributes(prompt, LanguageConsoleImpl.this.myPromptAttributes);
                if (LanguageConsoleImpl.this.myPanel.isVisible()) {
                    LanguageConsoleImpl.this.queueUiUpdate(false);
                }
            }
        });
    }

    public void setEditable(boolean editable) {
        this.myConsoleEditor.setRendererMode(!editable);
        this.setPromptInner(editable ? this.myPrompt : "");
    }

    public boolean isEditable() {
        return !this.myConsoleEditor.isRendererMode();
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getFile"));
        }
        return psiFile;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        LightVirtualFile lightVirtualFile = this.myVirtualFile;
        if (lightVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getVirtualFile"));
        }
        return lightVirtualFile;
    }

    @NotNull
    public EditorEx getHistoryViewer() {
        EditorEx editorEx = this.myHistoryViewer;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getHistoryViewer"));
        }
        return editorEx;
    }

    @NotNull
    public Document getEditorDocument() {
        Document document = this.myEditorDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getEditorDocument"));
        }
        return document;
    }

    @NotNull
    public EditorEx getConsoleEditor() {
        EditorEx editorEx = this.myConsoleEditor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getConsoleEditor"));
        }
        return editorEx;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getTitle"));
        }
        return string;
    }

    public void setTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "setTitle"));
        }
        this.myTitle = title;
    }

    public void printToHistory(@NotNull CharSequence text, @NotNull TextAttributes attributes) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "printToHistory"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl", "printToHistory"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        text = StringUtilRt.unifyLineSeparators((CharSequence)text);
        boolean scrollToEnd = this.shouldScrollHistoryToEnd();
        this.addTextToHistory(text, attributes);
        if (scrollToEnd) {
            this.scrollHistoryToEnd();
        }
        this.queueUiUpdate(scrollToEnd);
    }

    protected void addTextToHistory(@Nullable CharSequence text, @Nullable TextAttributes attributes) {
        if (StringUtil.isEmpty((CharSequence)text) || attributes == null) {
            return;
        }
        DocumentEx history = this.myHistoryViewer.getDocument();
        int offset = this.appendToHistoryDocument(history, text);
        DocumentMarkupModel.forDocument(history, this.myProject, true).addRangeHighlighter(offset, offset + text.length(), 2000, attributes, HighlighterTargetArea.EXACT_RANGE);
    }

    @Deprecated
    public String addCurrentToHistory(@NotNull TextRange textRange, boolean erase, boolean preserveMarkup) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "addCurrentToHistory"));
        }
        return this.addToHistoryInner(textRange, this.myConsoleEditor, erase, preserveMarkup);
    }

    public String addToHistory(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean preserveMarkup) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistory"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistory"));
        }
        return this.addToHistoryInner(textRange, editor, false, preserveMarkup);
    }

    @NotNull
    public String prepareExecuteAction(boolean addToHistory, boolean preserveMarkup, boolean clearInput) {
        Editor editor = this.getCurrentEditor();
        Document document = editor.getDocument();
        String text = document.getText();
        TextRange range = new TextRange(0, document.getTextLength());
        if (!clearInput) {
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
        if (addToHistory) {
            this.addToHistoryInner(range, this.myConsoleEditor, clearInput, preserveMarkup);
        } else if (clearInput) {
            this.setInputText("");
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "prepareExecuteAction"));
        }
        return string;
    }

    @NotNull
    protected String addToHistoryInner(final @NotNull TextRange textRange, final @NotNull EditorEx editor, boolean erase, boolean preserveMarkup) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistoryInner"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistoryInner"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String result = this.addTextRangeToHistory(textRange, editor, preserveMarkup);
        if (erase) {
            DocumentUtil.writeInRunUndoTransparentAction(new Runnable(){

                @Override
                public void run() {
                    editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
                }
            });
        }
        this.scrollHistoryToEnd();
        this.queueUiUpdate(true);
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistoryInner"));
        }
        return string;
    }

    public boolean shouldScrollHistoryToEnd() {
        Rectangle visibleArea = this.myHistoryViewer.getScrollingModel().getVisibleArea();
        Dimension contentSize = this.myHistoryViewer.getContentSize();
        return contentSize.getHeight() - visibleArea.getMaxY() < (double)(this.getMinHistoryLineCount() * this.myHistoryViewer.getLineHeight());
    }

    private void scrollHistoryToEnd() {
        if (this.myHistoryViewer.getDocument().getTextLength() != 0) {
            EditorUtil.scrollToTheEnd(this.myHistoryViewer);
        }
    }

    @NotNull
    protected String addTextRangeToHistory(@NotNull TextRange textRange, @NotNull EditorEx inputEditor, boolean preserveMarkup) {
        int itStart;
        String text;
        EditorHighlighter highlighter;
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "addTextRangeToHistory"));
        }
        if (inputEditor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl", "addTextRangeToHistory"));
        }
        this.doAddPromptToHistory();
        DocumentEx history = this.myHistoryViewer.getDocument();
        MarkupModel markupModel = DocumentMarkupModel.forDocument(history, this.myProject, true);
        int localStartOffset = textRange.getStartOffset();
        if (inputEditor instanceof EditorWindow) {
            PsiFile file = ((EditorWindow)((Object)inputEditor)).getInjectedFile();
            highlighter = HighlighterFactory.createHighlighter((VirtualFile)file.getVirtualFile(), (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), (Project)this.getProject());
            String fullText = InjectedLanguageUtil.getUnescapedText(file, null, null);
            highlighter.setText((CharSequence)fullText);
            text = textRange.substring(fullText);
        } else {
            text = inputEditor.getDocument().getText(textRange);
            highlighter = inputEditor.getHighlighter();
        }
        int offset = this.appendToHistoryDocument(history, text);
        HighlighterIterator iterator = highlighter.createIterator(localStartOffset);
        int localEndOffset = textRange.getEndOffset();
        while (!iterator.atEnd() && (itStart = iterator.getStart()) <= localEndOffset) {
            int itEnd = iterator.getEnd();
            if (itEnd >= localStartOffset) {
                int start = Math.max(itStart, localStartOffset) - localStartOffset + offset;
                int end = Math.min(itEnd, localEndOffset) - localStartOffset + offset;
                markupModel.addRangeHighlighter(start, end, 2000, iterator.getTextAttributes(), HighlighterTargetArea.EXACT_RANGE);
            }
            iterator.advance();
        }
        if (preserveMarkup) {
            LanguageConsoleImpl.duplicateHighlighters(markupModel, DocumentMarkupModel.forDocument(inputEditor.getDocument(), this.myProject, true), offset, textRange);
        }
        if (!text.endsWith("\n")) {
            this.appendToHistoryDocument(history, "\n");
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "addTextRangeToHistory"));
        }
        return string;
    }

    protected void doAddPromptToHistory() {
        this.addTextToHistory(this.myPrompt, this.myPromptAttributes);
    }

    protected int appendToHistoryDocument(@NotNull Document history, @NotNull CharSequence text) {
        if (history == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "appendToHistoryDocument"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl", "appendToHistoryDocument"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        history.insertString(history.getTextLength(), text);
        return history.getTextLength() - text.length();
    }

    private static void duplicateHighlighters(@NotNull MarkupModel to, @NotNull MarkupModel from, int offset, @NotNull TextRange textRange) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "duplicateHighlighters"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl", "duplicateHighlighters"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/console/LanguageConsoleImpl", "duplicateHighlighters"));
        }
        for (RangeHighlighter rangeHighlighter : from.getAllHighlighters()) {
            int end;
            HighlightInfo highlightInfo;
            if (!rangeHighlighter.isValid()) continue;
            Object tooltip = rangeHighlighter.getErrorStripeTooltip();
            HighlightInfo highlightInfo2 = highlightInfo = tooltip instanceof HighlightInfo ? (HighlightInfo)tooltip : null;
            if (highlightInfo != null && (highlightInfo.getSeverity() != HighlightSeverity.INFORMATION || highlightInfo.type.getAttributesKey() == EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES)) continue;
            int localOffset = textRange.getStartOffset();
            int start = Math.max(rangeHighlighter.getStartOffset(), localOffset) - localOffset;
            if (start > (end = Math.min(rangeHighlighter.getEndOffset(), textRange.getEndOffset()) - localOffset)) continue;
            RangeHighlighter h = to.addRangeHighlighter(start + offset, end + offset, rangeHighlighter.getLayer(), rangeHighlighter.getTextAttributes(), rangeHighlighter.getTargetArea());
            ((RangeHighlighterEx)h).setAfterEndOfLine(((RangeHighlighterEx)rangeHighlighter).isAfterEndOfLine());
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getComponent"));
        }
        return jPanel;
    }

    public void queueUiUpdate(boolean forceScrollToEnd) {
        this.myForceScrollToEnd.compareAndSet(false, forceScrollToEnd);
        this.myUpdateQueue.request();
    }

    public void dispose() {
        FileEditorManager editorManager;
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myConsoleEditor);
        editorFactory.releaseEditor((Editor)this.myHistoryViewer);
        if (this.getProject().isOpen() && (editorManager = FileEditorManager.getInstance((Project)this.getProject())).isFileOpen((VirtualFile)this.myVirtualFile)) {
            editorManager.closeFile((VirtualFile)this.myVirtualFile);
        }
    }

    public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "calcData"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl", "calcData"));
        }
        if (OpenFileDescriptor.NAVIGATE_IN_EDITOR == key) {
            sink.put(OpenFileDescriptor.NAVIGATE_IN_EDITOR, (Object)this.myConsoleEditor);
        } else if (this.getProject().isInitialized()) {
            sink.put(key, FileEditorManagerEx.getInstanceEx(this.getProject()).getData(key.getName(), this.myConsoleEditor, (VirtualFile)this.myVirtualFile));
        }
    }

    private void installEditorFactoryListener() {
        FileEditorManagerAdapter fileEditorListener = new FileEditorManagerAdapter(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl$10", "fileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl$10", "fileOpened"));
                }
                if (LanguageConsoleImpl.this.myConsoleEditor == null || !Comparing.equal((Object)file, (Object)LanguageConsoleImpl.this.myVirtualFile)) {
                    return;
                }
                Editor selectedTextEditor = source.getSelectedTextEditor();
                for (FileEditor fileEditor : source.getAllEditors(file)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    EditorEx editor = (EditorEx)((TextEditor)fileEditor).getEditor();
                    editor.addFocusListener(LanguageConsoleImpl.this.myFocusListener);
                    if (selectedTextEditor == editor) {
                        LanguageConsoleImpl.this.myCurrentEditor = editor;
                    }
                    EmptyAction.registerActionShortcuts((JComponent)editor.getComponent(), (JComponent)LanguageConsoleImpl.this.myConsoleEditor.getComponent());
                    editor.getCaretModel().addCaretListener((CaretListener)new CaretAdapter(){

                        public void caretPositionChanged(CaretEvent e) {
                            LanguageConsoleImpl.this.queueUiUpdate(false);
                        }
                    });
                }
                LanguageConsoleImpl.this.queueUiUpdate(false);
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl$10", "fileClosed"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl$10", "fileClosed"));
                }
                if (!Comparing.equal((Object)file, (Object)LanguageConsoleImpl.this.myVirtualFile)) {
                    return;
                }
                if (LanguageConsoleImpl.this.myUiUpdateRunnable != null && !Boolean.TRUE.equals(file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
                    if (LanguageConsoleImpl.this.myCurrentEditor != null && LanguageConsoleImpl.this.myCurrentEditor.isDisposed()) {
                        LanguageConsoleImpl.this.myCurrentEditor = null;
                    }
                    ApplicationManager.getApplication().runReadAction(LanguageConsoleImpl.this.myUiUpdateRunnable);
                }
            }
        };
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)fileEditorListener);
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.getProject());
        if (editorManager.isFileOpen((VirtualFile)this.myVirtualFile)) {
            fileEditorListener.fileOpened(editorManager, (VirtualFile)this.myVirtualFile);
        }
    }

    public Editor getCurrentEditor() {
        return (Editor)ObjectUtils.chooseNotNull((Object)this.myCurrentEditor, (Object)this.myConsoleEditor);
    }

    public Language getLanguage() {
        return this.myVirtualFile.getLanguage();
    }

    public void setLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "setLanguage"));
        }
        this.myVirtualFile.setLanguage(language);
        this.myVirtualFile.setContent((Object)this.myEditorDocument, (CharSequence)this.myEditorDocument.getText(), false);
        FileContentUtil.reparseFiles((Project)this.myProject, Collections.singletonList(this.myVirtualFile), (boolean)false);
        this.myFile = this.createFile(this.myVirtualFile, this.myEditorDocument, this.myProject);
    }

    public void setInputText(final @NotNull String query) {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "setInputText"));
        }
        DocumentUtil.writeInRunUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                LanguageConsoleImpl.this.myConsoleEditor.getDocument().setText(query);
            }
        });
    }

    @NotNull
    protected PsiFile createFile(@NotNull LightVirtualFile virtualFile, @NotNull Document document, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl", "createFile"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleImpl", "createFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/LanguageConsoleImpl", "createFile"));
        }
        PsiFile psiFile = (PsiFile)ObjectUtils.assertNotNull((Object)PsiManager.getInstance((Project)project).findFile((VirtualFile)virtualFile));
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "createFile"));
        }
        return psiFile;
    }

    boolean isHistoryViewerForceAdditionalColumnsUsage() {
        return true;
    }

    int getMinHistoryLineCount() {
        return 2;
    }

    private class MyLayout
    extends AbstractLayoutManager {
        private MyLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        public void layoutContainer(@NotNull Container parent) {
            EditorEx input;
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleImpl$MyLayout", "layoutContainer"));
            }
            int componentCount = parent.getComponentCount();
            if (componentCount == 0) {
                return;
            }
            EditorEx history = LanguageConsoleImpl.this.myHistoryViewer;
            EditorEx editorEx = input = componentCount == 2 ? LanguageConsoleImpl.this.myConsoleEditor : null;
            if (input == null) {
                parent.getComponent(0).setBounds(parent.getBounds());
                return;
            }
            Dimension panelSize = parent.getSize();
            if (panelSize.getHeight() <= 0.0) {
                return;
            }
            Dimension historySize = history.getContentSize();
            Dimension inputSize = input.getContentSize();
            int width = Math.max(inputSize.width, historySize.width);
            if (LanguageConsoleImpl.this.isHistoryViewerForceAdditionalColumnsUsage()) {
                history.getSoftWrapModel().forceAdditionalColumnsUsage();
                input.getSettings().setAdditionalColumnsCount(2 + (width - inputSize.width) / EditorUtil.getSpaceWidth(0, input));
                history.getSettings().setAdditionalColumnsCount(2 + (width - historySize.width) / EditorUtil.getSpaceWidth(0, history));
            }
            if (history.getDocument().getLineCount() == 0) {
                historySize.height = 0;
            }
            int minHistoryHeight = historySize.height > 0 ? LanguageConsoleImpl.this.getMinHistoryLineCount() * history.getLineHeight() + (LanguageConsoleImpl.this.myShowSeparatorLine ? 1 : 0) : 0;
            int minInputHeight = input.isViewer() ? 0 : input.getLineHeight();
            int inputPreferredHeight = input.isViewer() ? 0 : Math.max(minInputHeight, inputSize.height);
            int historyPreferredHeight = Math.max(minHistoryHeight, historySize.height);
            int newInputHeight = panelSize.height < minInputHeight ? panelSize.height : (panelSize.height < inputPreferredHeight ? panelSize.height - minHistoryHeight : (panelSize.height < inputPreferredHeight + historyPreferredHeight || inputPreferredHeight == 0 ? inputPreferredHeight : panelSize.height - historyPreferredHeight));
            int newHistoryHeight = panelSize.height - newInputHeight;
            input.getComponent().setBounds(0, newHistoryHeight, panelSize.width, newInputHeight);
            LanguageConsoleImpl.this.myForceScrollToEnd.compareAndSet(false, LanguageConsoleImpl.this.shouldScrollHistoryToEnd());
            history.getComponent().setBounds(0, 0, panelSize.width, newHistoryHeight);
        }
    }
}

