/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.BasicGutterContentProvider;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.ConsoleGutterComponent;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.GutterContentProvider;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.LanguageConsoleViewImpl;
import com.intellij.execution.console.LineSeparatorPainter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.Consumer;
import com.intellij.util.PairFunction;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageConsoleBuilder {
    @Nullable
    private LanguageConsoleView consoleView;
    @Nullable
    private Condition<LanguageConsoleImpl> executionEnabled;
    @Nullable
    private PairFunction<VirtualFile, Project, PsiFile> psiFileFactory;
    @Nullable
    private BaseConsoleExecuteActionHandler executeActionHandler;
    @Nullable
    private String historyType;
    @Nullable
    private GutterContentProvider gutterContentProvider;
    private boolean oneLineInput;

    public LanguageConsoleBuilder(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder", "<init>"));
        }
        this.executionEnabled = Conditions.alwaysTrue();
        this.consoleView = consoleView;
    }

    public LanguageConsoleBuilder() {
        this.executionEnabled = Conditions.alwaysTrue();
    }

    public LanguageConsoleBuilder processHandler(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder", "processHandler"));
        }
        this.executionEnabled = new ProcessBackedExecutionEnabledCondition(processHandler);
        return this;
    }

    public LanguageConsoleBuilder executionEnabled(@NotNull Condition<LanguageConsoleImpl> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder", "executionEnabled"));
        }
        this.executionEnabled = condition;
        return this;
    }

    public LanguageConsoleBuilder psiFileFactory(@NotNull PairFunction<VirtualFile, Project, PsiFile> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder", "psiFileFactory"));
        }
        this.psiFileFactory = value;
        return this;
    }

    public LanguageConsoleBuilder initActions(@NotNull BaseConsoleExecuteActionHandler executeActionHandler, @NotNull String historyType) {
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder", "initActions"));
        }
        if (historyType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleBuilder", "initActions"));
        }
        if (this.consoleView == null) {
            this.executeActionHandler = executeActionHandler;
            this.historyType = historyType;
        } else {
            this.doInitAction(this.consoleView, executeActionHandler, historyType);
        }
        return this;
    }

    private void doInitAction(@NotNull LanguageConsoleView consoleView, @NotNull BaseConsoleExecuteActionHandler executeActionHandler, @NotNull String historyType) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder", "doInitAction"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleBuilder", "doInitAction"));
        }
        if (historyType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/LanguageConsoleBuilder", "doInitAction"));
        }
        ConsoleExecuteAction action = new ConsoleExecuteAction(consoleView, executeActionHandler, this.executionEnabled);
        action.registerCustomShortcutSet(action.getShortcutSet(), consoleView.getConsole().getConsoleEditor().getComponent());
        new ConsoleHistoryController(historyType, null, consoleView.getConsole(), executeActionHandler.getConsoleHistoryModel()).install();
    }

    public static Pair<AnAction, ConsoleHistoryController> registerExecuteAction(@NotNull LanguageConsoleImpl console, final @NotNull Consumer<String> executeActionHandler, @NotNull String historyType, @Nullable String historyPersistenceId, @Nullable Condition<LanguageConsoleImpl> enabledCondition) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder", "registerExecuteAction"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleBuilder", "registerExecuteAction"));
        }
        if (historyType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/LanguageConsoleBuilder", "registerExecuteAction"));
        }
        ConsoleExecuteAction.ConsoleExecuteActionHandler handler = new ConsoleExecuteAction.ConsoleExecuteActionHandler(true){

            @Override
            void doExecute(@NotNull String text, @NotNull LanguageConsoleImpl console, @Nullable LanguageConsoleView consoleView) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder$1", "doExecute"));
                }
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleBuilder$1", "doExecute"));
                }
                executeActionHandler.consume((Object)text);
            }
        };
        ConsoleExecuteAction action = new ConsoleExecuteAction(console, handler, enabledCondition);
        action.registerCustomShortcutSet(action.getShortcutSet(), console.getConsoleEditor().getComponent());
        ConsoleHistoryController historyController = new ConsoleHistoryController(historyType, historyPersistenceId, console, handler.getConsoleHistoryModel());
        historyController.install();
        return new Pair((Object)action, (Object)historyController);
    }

    public LanguageConsoleBuilder gutterContentProvider(@Nullable GutterContentProvider value) {
        this.gutterContentProvider = value;
        return this;
    }

    public LanguageConsoleBuilder oneLineInput() {
        this.oneLineInput(true);
        return this;
    }

    public LanguageConsoleBuilder oneLineInput(boolean value) {
        this.oneLineInput = value;
        return this;
    }

    public LanguageConsoleView build(@NotNull Project project, @NotNull Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder", "build"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleBuilder", "build"));
        }
        GutteredLanguageConsole console = new GutteredLanguageConsole(language.getDisplayName() + " Console", project, language, this.gutterContentProvider, this.psiFileFactory);
        if (this.oneLineInput) {
            console.getConsoleEditor().setOneLineMode(true);
        }
        LanguageConsoleViewImpl consoleView = new LanguageConsoleViewImpl(console, true);
        if (this.executeActionHandler != null) {
            assert (this.historyType != null);
            this.doInitAction(consoleView, this.executeActionHandler, this.historyType);
        }
        console.initComponents();
        return consoleView;
    }

    private static final class GutteredLanguageConsole
    extends LanguageConsoleImpl {
        private final GutterContentProvider gutterContentProvider;
        @Nullable
        private final PairFunction<VirtualFile, Project, PsiFile> psiFileFactory;

        public GutteredLanguageConsole(@NotNull String title, @NotNull Project project, @NotNull Language language, @Nullable GutterContentProvider gutterContentProvider, @Nullable PairFunction<VirtualFile, Project, PsiFile> psiFileFactory) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole", "<init>"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole", "<init>"));
            }
            super(project, title, new LightVirtualFile(title, language, (CharSequence)""), false, psiFileFactory);
            this.setShowSeparatorLine(false);
            this.gutterContentProvider = gutterContentProvider == null ? new BasicGutterContentProvider() : gutterContentProvider;
            this.psiFileFactory = psiFileFactory;
        }

        @Override
        boolean isHistoryViewerForceAdditionalColumnsUsage() {
            return false;
        }

        @Override
        int getMinHistoryLineCount() {
            return 1;
        }

        @Override
        @NotNull
        protected PsiFile createFile(@NotNull LightVirtualFile virtualFile, @NotNull Document document, @NotNull Project project) {
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole", "createFile"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole", "createFile"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole", "createFile"));
            }
            if (this.psiFileFactory == null) {
                PsiFile psiFile = super.createFile(virtualFile, document, project);
                if (psiFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole", "createFile"));
                }
                return psiFile;
            }
            PsiFile psiFile = (PsiFile)this.psiFileFactory.fun((Object)virtualFile, (Object)project);
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole", "createFile"));
            }
            return psiFile;
        }

        @Override
        protected void setupEditorDefault(@NotNull EditorEx editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole", "setupEditorDefault"));
            }
            super.setupEditorDefault(editor);
            if (editor == this.getConsoleEditor()) {
                return;
            }
            final ConsoleGutterComponent lineStartGutter = new ConsoleGutterComponent(editor, this.gutterContentProvider, true);
            final ConsoleGutterComponent lineEndGutter = new ConsoleGutterComponent(editor, this.gutterContentProvider, false);
            JBLayeredPane layeredPane = new JBLayeredPane(){

                public Dimension getPreferredSize() {
                    Dimension editorSize = this.getEditorComponent().getPreferredSize();
                    return new Dimension(lineStartGutter.getPreferredSize().width + editorSize.width, editorSize.height);
                }

                public Dimension getMinimumSize() {
                    Dimension editorSize = this.getEditorComponent().getMinimumSize();
                    return new Dimension(lineStartGutter.getPreferredSize().width + editorSize.width, editorSize.height);
                }

                public void doLayout() {
                    EditorComponentImpl editor = this.getEditorComponent();
                    int w = this.getWidth();
                    int h = this.getHeight();
                    int lineStartGutterWidth = lineStartGutter.getPreferredSize().width;
                    lineStartGutter.setBounds(0, 0, lineStartGutterWidth + GutteredLanguageConsole.this.gutterContentProvider.getLineStartGutterOverlap(editor.getEditor()), h);
                    editor.setBounds(lineStartGutterWidth, 0, w - lineStartGutterWidth, h);
                    int lineEndGutterWidth = lineEndGutter.getPreferredSize().width;
                    lineEndGutter.setBounds(lineStartGutterWidth + (w - lineEndGutterWidth - editor.getEditor().getScrollPane().getVerticalScrollBar().getWidth()), 0, lineEndGutterWidth, h);
                }

                @NotNull
                private EditorComponentImpl getEditorComponent() {
                    for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                        Component component = this.getComponent(i);
                        if (!(component instanceof EditorComponentImpl)) continue;
                        EditorComponentImpl editorComponentImpl = (EditorComponentImpl)component;
                        if (editorComponentImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$1", "getEditorComponent"));
                        }
                        return editorComponentImpl;
                    }
                    throw new IllegalStateException();
                }
            };
            layeredPane.add((Component)lineStartGutter, JLayeredPane.PALETTE_LAYER);
            JScrollPane scrollPane = editor.getScrollPane();
            layeredPane.add(scrollPane.getViewport().getView(), JLayeredPane.DEFAULT_LAYER);
            layeredPane.add((Component)lineEndGutter, JLayeredPane.PALETTE_LAYER);
            scrollPane.setViewportView((Component)layeredPane);
            GutterUpdateScheduler gutterUpdateScheduler = new GutterUpdateScheduler(lineStartGutter, lineEndGutter);
            this.getProject().getMessageBus().connect((Disposable)this).subscribe(DocumentBulkUpdateListener.TOPIC, (Object)gutterUpdateScheduler);
            editor.getDocument().addDocumentListener((DocumentListener)gutterUpdateScheduler);
        }

        @Override
        protected void doAddPromptToHistory() {
            this.gutterContentProvider.beforeEvaluate(this.getHistoryViewer());
        }

        private final class GutterUpdateScheduler
        extends DocumentAdapter
        implements DocumentBulkUpdateListener {
            private final ConsoleGutterComponent lineStartGutter;
            private final ConsoleGutterComponent lineEndGutter;
            private Task gutterSizeUpdater;
            private RangeHighlighterEx lineSeparatorPainter;

            public GutterUpdateScheduler(@NotNull ConsoleGutterComponent lineStartGutter, ConsoleGutterComponent lineEndGutter) {
                if (lineStartGutter == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler", "<init>"));
                }
                if (lineEndGutter == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler", "<init>"));
                }
                this.lineStartGutter = lineStartGutter;
                this.lineEndGutter = lineEndGutter;
                GutteredLanguageConsole.this.getHistoryViewer().getMarkupModel().addMarkupModelListener(GutteredLanguageConsole.this, new MarkupModelListener.Adapter(){

                    @Override
                    public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                        if (highlighter == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler$1", "beforeRemoved"));
                        }
                        if (GutterUpdateScheduler.this.lineSeparatorPainter == highlighter) {
                            GutterUpdateScheduler.this.lineSeparatorPainter = null;
                        }
                    }
                });
            }

            private void addLineSeparatorPainterIfNeed() {
                if (this.lineSeparatorPainter != null) {
                    return;
                }
                EditorEx editor = GutteredLanguageConsole.this.getHistoryViewer();
                int endOffset = this.getDocument().getTextLength();
                this.lineSeparatorPainter = new LineSeparatorPainter(GutteredLanguageConsole.this.gutterContentProvider, editor, endOffset);
            }

            private DocumentEx getDocument() {
                return GutteredLanguageConsole.this.getHistoryViewer().getDocument();
            }

            public void documentChanged(DocumentEvent event) {
                DocumentEx document = this.getDocument();
                if (document.isInBulkUpdate()) {
                    return;
                }
                if (document.getTextLength() > 0) {
                    this.addLineSeparatorPainterIfNeed();
                    int startDocLine = document.getLineNumber(event.getOffset());
                    int endDocLine = document.getLineNumber(event.getOffset() + event.getNewLength());
                    if (event.getOldLength() > event.getNewLength() || startDocLine != endDocLine || StringUtil.indexOf((CharSequence)event.getOldFragment(), (char)'\n') != -1) {
                        this.updateGutterSize(startDocLine, endDocLine);
                    }
                } else if (event.getOldLength() > 0) {
                    this.documentCleared();
                }
            }

            private void documentCleared() {
                this.gutterSizeUpdater = null;
                this.lineEndGutter.documentCleared();
                GutteredLanguageConsole.this.gutterContentProvider.documentCleared(GutteredLanguageConsole.this.getHistoryViewer());
            }

            @Override
            public void updateStarted(@NotNull Document document) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler", "updateStarted"));
                }
            }

            @Override
            public void updateFinished(@NotNull Document document) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler", "updateFinished"));
                }
                if (this.getDocument().getTextLength() == 0) {
                    this.documentCleared();
                } else {
                    this.addLineSeparatorPainterIfNeed();
                    this.updateGutterSize(0, Integer.MAX_VALUE);
                }
            }

            private void updateGutterSize(int start, int end) {
                if (this.gutterSizeUpdater != null) {
                    this.gutterSizeUpdater.start = Math.min(start, this.gutterSizeUpdater.start);
                    this.gutterSizeUpdater.end = Math.max(end, this.gutterSizeUpdater.end);
                    return;
                }
                this.gutterSizeUpdater = new Task(start, end);
                SwingUtilities.invokeLater(this.gutterSizeUpdater);
            }

            private final class Task
            implements Runnable {
                private int start;
                private int end;

                public Task(int start, int end) {
                    this.start = start;
                    this.end = end;
                }

                @Override
                public void run() {
                    if (!GutteredLanguageConsole.this.getHistoryViewer().isDisposed()) {
                        GutterUpdateScheduler.this.lineStartGutter.updateSize(this.start, this.end);
                        GutterUpdateScheduler.this.lineEndGutter.updateSize(this.start, this.end);
                    }
                    GutterUpdateScheduler.this.gutterSizeUpdater = null;
                }
            }
        }
    }

    @Deprecated
    public static class ProcessBackedExecutionEnabledCondition
    implements Condition<LanguageConsoleImpl> {
        private final ProcessHandler myProcessHandler;

        public ProcessBackedExecutionEnabledCondition(ProcessHandler myProcessHandler) {
            this.myProcessHandler = myProcessHandler;
        }

        public boolean value(LanguageConsoleImpl console) {
            return !this.myProcessHandler.isProcessTerminated();
        }
    }
}

