/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.applet;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.applet.AppletConfiguration;
import com.intellij.execution.applet.AppletConfigurationType;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppletConfigurationProducer
extends JavaRuntimeConfigurationProducerBase {
    private PsiClass myPsiClass;

    protected AppletConfigurationProducer() {
        super(AppletConfigurationType.getInstance());
    }

    public PsiElement getSourceElement() {
        return this.myPsiClass;
    }

    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context) {
        if ((location = JavaExecutionUtil.stepIntoSingleClass((Location)location)) == null) {
            return null;
        }
        Project project = location.getProject();
        PsiElement element = location.getPsiElement();
        this.myPsiClass = AppletConfigurationProducer.getAppletClass(element, PsiManager.getInstance((Project)project));
        if (this.myPsiClass == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(project, context);
        AppletConfiguration configuration = (AppletConfiguration)settings.getConfiguration();
        configuration.MAIN_CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)this.myPsiClass);
        configuration.setModule(this.myPsiClass.isValid() ? ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPsiClass) : null);
        configuration.setGeneratedName();
        return settings;
    }

    public int compareTo(Object o) {
        return -1;
    }

    @Nullable
    private static PsiClass getAppletClass(PsiElement element, PsiManager manager) {
        while (element != null) {
            PsiClass aClass;
            if (element instanceof PsiClass && AppletConfigurationProducer.isAppletClass(aClass = (PsiClass)element, manager)) {
                return aClass;
            }
            element = element.getParent();
        }
        return null;
    }

    private static boolean isAppletClass(PsiClass aClass, PsiManager manager) {
        if (!PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)true)) {
            return false;
        }
        Module module = JavaExecutionUtil.findModule((PsiClass)aClass);
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithLibrariesScope((Module)module) : GlobalSearchScope.projectScope((Project)manager.getProject());
        PsiClass appletClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.applet.Applet", scope);
        if (appletClass != null && aClass.isInheritor(appletClass, true)) {
            return true;
        }
        appletClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("javax.swing.JApplet", scope);
        return appletClass != null && aClass.isInheritor(appletClass, true);
    }

    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurations, ConfigurationContext context) {
        if (existingConfigurations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/applet/AppletConfigurationProducer", "findExistingByElement"));
        }
        PsiClass aClass = AppletConfigurationProducer.getAppletClass(location.getPsiElement(), PsiManager.getInstance((Project)location.getProject()));
        if (aClass != null) {
            for (RunnerAndConfigurationSettings existingConfiguration : existingConfigurations) {
                if (!Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), (String)((AppletConfiguration)existingConfiguration.getConfiguration()).MAIN_CLASS_NAME)) continue;
                return existingConfiguration;
            }
        }
        return null;
    }
}

