/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContextAction
extends BaseRunConfigurationAction {
    private final Executor myExecutor;

    public RunContextAction(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/actions/RunContextAction", "<init>"));
        }
        super(ExecutionBundle.message((String)"perform.action.with.context.configuration.action.name", (Object[])new Object[]{executor.getStartActionText()}), null, executor.getIcon());
        this.myExecutor = executor;
    }

    @Override
    protected void perform(ConfigurationContext context) {
        RunnerAndConfigurationSettings configuration = context.findExisting();
        RunManagerEx runManager = (RunManagerEx)context.getRunManager();
        if (configuration == null) {
            configuration = context.getConfiguration();
            if (configuration == null) {
                return;
            }
            runManager.setTemporaryConfiguration(configuration);
        }
        runManager.setSelectedConfiguration(configuration);
        Project project = context.getProject();
        ExecutionManager.getInstance((Project)project).restartRunProfile(project, this.myExecutor, ExecutionTargetManager.getActiveTarget((Project)project), configuration, (RunContentDescriptor)null);
    }

    @Override
    protected boolean isEnabledFor(RunConfiguration configuration) {
        return this.getRunner(configuration) != null;
    }

    @Nullable
    private ProgramRunner getRunner(RunConfiguration configuration) {
        return RunnerRegistry.getInstance().getRunner(this.myExecutor.getId(), (RunProfile)configuration);
    }

    @Override
    protected void updatePresentation(Presentation presentation, @NotNull String actionText, ConfigurationContext context) {
        if (actionText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/actions/RunContextAction", "updatePresentation"));
        }
        presentation.setText(this.myExecutor.getStartActionText(actionText), true);
        Pair<Boolean, Boolean> b = this.isEnabledAndVisible(context);
        presentation.setEnabled(((Boolean)b.first).booleanValue());
        presentation.setVisible(((Boolean)b.second).booleanValue());
    }

    private Pair<Boolean, Boolean> isEnabledAndVisible(ConfigurationContext context) {
        RunnerAndConfigurationSettings configuration = context.findExisting();
        if (configuration == null) {
            configuration = context.getConfiguration();
        }
        if (configuration == null) {
            return Pair.create((Object)false, (Object)false);
        }
        ProgramRunner runner = this.getRunner(configuration.getConfiguration());
        if (runner == null) {
            return Pair.create((Object)false, (Object)false);
        }
        return Pair.create((Object)(!ExecutorRegistry.getInstance().isStarting(context.getProject(), this.myExecutor.getId(), runner.getRunnerId()) ? 1 : 0), (Object)true);
    }
}

