/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.errorreport.itn;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.errorreport.error.InternalEAPException;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.errorreport.error.UpdateAvailableException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class ITNProxy {
    @NonNls
    public static final String ENCODING = "UTF8";
    public static final String POST_DELIMITER = "&";
    @NonNls
    public static final String NEW_THREAD_URL = "http://www.intellij.net/trackerRpc/idea/createScr";
    @NonNls
    private static final String HTTP_CONTENT_LENGTH = "Content-Length";
    @NonNls
    private static final String HTTP_CONTENT_TYPE = "Content-Type";
    @NonNls
    private static final String HTTP_WWW_FORM = "application/x-www-form-urlencoded";
    @NonNls
    private static final String HTTP_POST = "POST";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int postNewThread(String login, String password, ErrorBean error, String compilationTimestamp) throws IOException, NoSuchEAPUserException, InternalEAPException, UpdateAvailableException {
        String reply;
        List<Pair<String, String>> params = ITNProxy.createParametersFor(login, password, error, compilationTimestamp, ApplicationManager.getApplication(), (ApplicationInfoEx)ApplicationInfo.getInstance(), ApplicationNamesInfo.getInstance(), UpdateSettings.getInstance());
        HttpURLConnection connection = ITNProxy.post(new URL(NEW_THREAD_URL), ITNProxy.join(params));
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new InternalEAPException(DiagnosticBundle.message("error.http.result.code", responseCode));
        }
        BufferedInputStream is = new BufferedInputStream(connection.getInputStream());
        try {
            reply = ITNProxy.readFrom(is);
        }
        finally {
            ((InputStream)is).close();
        }
        if ("unauthorized".equals(reply)) {
            throw new NoSuchEAPUserException(login);
        }
        if (reply.startsWith("update ")) {
            throw new UpdateAvailableException(reply.substring(7));
        }
        if (reply.startsWith("message ")) {
            throw new InternalEAPException(reply.substring(8));
        }
        try {
            return Integer.valueOf(reply.trim());
        }
        catch (NumberFormatException ex) {
            throw new InternalEAPException(DiagnosticBundle.message("error.itn.returns.wrong.data", new Object[0]));
        }
    }

    private static List<Pair<String, String>> createParametersFor(String login, String password, ErrorBean error, String compilationTimestamp, Application application, ApplicationInfoEx appInfo, ApplicationNamesInfo namesInfo, UpdateSettings updateSettings) {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(Pair.create((Object)"protocol.version", (Object)"1"));
        params.add(Pair.create((Object)"user.login", (Object)login));
        params.add(Pair.create((Object)"user.password", (Object)password));
        params.add(Pair.create((Object)"os.name", (Object)SystemProperties.getOsName()));
        params.add(Pair.create((Object)"java.version", (Object)SystemProperties.getJavaVersion()));
        params.add(Pair.create((Object)"java.vm.vendor", (Object)SystemProperties.getJavaVmVendor()));
        params.add(Pair.create((Object)"app.name", (Object)namesInfo.getProductName()));
        params.add(Pair.create((Object)"app.name.full", (Object)namesInfo.getFullProductName()));
        params.add(Pair.create((Object)"app.name.version", (Object)appInfo.getVersionName()));
        params.add(Pair.create((Object)"app.eap", (Object)Boolean.toString(appInfo.isEAP())));
        params.add(Pair.create((Object)"app.internal", (Object)Boolean.toString(application.isInternal())));
        params.add(Pair.create((Object)"app.build", (Object)appInfo.getBuild().asString()));
        params.add(Pair.create((Object)"app.version.major", (Object)appInfo.getMajorVersion()));
        params.add(Pair.create((Object)"app.version.minor", (Object)appInfo.getMinorVersion()));
        params.add(Pair.create((Object)"app.build.date", (Object)ITNProxy.format(appInfo.getBuildDate())));
        params.add(Pair.create((Object)"app.build.date.release", (Object)ITNProxy.format(appInfo.getMajorReleaseBuildDate())));
        params.add(Pair.create((Object)"app.compilation.timestamp", (Object)compilationTimestamp));
        params.add(Pair.create((Object)"update.channel.status", (Object)updateSettings.getSelectedChannelStatus().getCode()));
        params.add(Pair.create((Object)"update.ignored.builds", (Object)StringUtil.join(updateSettings.getIgnoredBuildNumbers(), (String)",")));
        params.add(Pair.create((Object)"plugin.name", (Object)error.getPluginName()));
        params.add(Pair.create((Object)"plugin.version", (Object)error.getPluginVersion()));
        params.add(Pair.create((Object)"last.action", (Object)error.getLastAction()));
        params.add(Pair.create((Object)"previous.exception", error.getPreviousException() == null ? null : Integer.toString(error.getPreviousException())));
        params.add(Pair.create((Object)"error.message", (Object)error.getMessage()));
        params.add(Pair.create((Object)"error.stacktrace", (Object)error.getStackTrace()));
        params.add(Pair.create((Object)"error.description", (Object)error.getDescription()));
        params.add(Pair.create((Object)"assignee.id", error.getAssigneeId() == null ? null : Integer.toString(error.getAssigneeId())));
        for (Attachment attachment : error.getAttachments()) {
            params.add((Pair<String, String>)Pair.create((Object)"attachment.name", (Object)attachment.getName()));
            params.add((Pair<String, String>)Pair.create((Object)"attachment.value", (Object)attachment.getEncodedBytes()));
        }
        return params;
    }

    private static String readFrom(InputStream is) throws IOException {
        int c;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((c = is.read()) != -1) {
            out.write(c);
        }
        String s = out.toString();
        out.close();
        return s;
    }

    private static String format(Calendar calendar) {
        return calendar == null ? null : Long.toString(calendar.getTime().getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection post(URL url, byte[] bytes) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)HttpConfigurable.getInstance().openConnection(url.toString());
        connection.setReadTimeout(10000);
        connection.setConnectTimeout(10000);
        connection.setRequestMethod(HTTP_POST);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty(HTTP_CONTENT_TYPE, String.format("%s; charset=%s", HTTP_WWW_FORM, ENCODING));
        connection.setRequestProperty(HTTP_CONTENT_LENGTH, Integer.toString(bytes.length));
        BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());
        try {
            ((OutputStream)out).write(bytes);
            ((OutputStream)out).flush();
        }
        finally {
            ((OutputStream)out).close();
        }
        return connection;
    }

    private static byte[] join(List<Pair<String, String>> params) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        Iterator<Pair<String, String>> it = params.iterator();
        while (it.hasNext()) {
            Pair<String, String> param = it.next();
            if (StringUtil.isEmpty((String)((String)param.first))) {
                throw new IllegalArgumentException(param.toString());
            }
            if (StringUtil.isNotEmpty((String)((String)param.second))) {
                builder.append((String)param.first).append("=").append(URLEncoder.encode((String)param.second, ENCODING));
            }
            if (!it.hasNext()) continue;
            builder.append(POST_DELIMITER);
        }
        return builder.toString().getBytes();
    }
}

