/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.errorreport;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.errorreport.itn.ITNProxy;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.net.HttpConfigurable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ErrorReportSender {
    @NonNls
    public static final String PREPARE_URL = "http://www.intellij.net/";

    private ErrorReportSender() {
    }

    public static void sendError(Project project, String login, String password, ErrorBean error, Consumer<Integer> callback, Consumer<Exception> errback) {
        SendTask sendTask = new SendTask(project, error);
        sendTask.setCredentials(login, password);
        sendTask.sendReport(callback, errback);
    }

    static class SendTask {
        private final Project myProject;
        private String myLogin;
        private String myPassword;
        private ErrorBean errorBean;

        public SendTask(Project project, ErrorBean errorBean) {
            this.myProject = project;
            this.errorBean = errorBean;
        }

        public void setCredentials(String login, String password) {
            this.myLogin = login;
            this.myPassword = password;
        }

        public void sendReport(final Consumer<Integer> callback, final Consumer<Exception> errback) {
            Task.Backgroundable task = new Task.Backgroundable(this.myProject, DiagnosticBundle.message("title.submitting.error.report", new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/errorreport/ErrorReportSender$SendTask$1", "run"));
                    }
                    try {
                        HttpConfigurable.getInstance().prepareURL(ErrorReportSender.PREPARE_URL);
                        if (!StringUtil.isEmpty((String)SendTask.this.myLogin)) {
                            int threadId = ITNProxy.postNewThread(SendTask.this.myLogin, SendTask.this.myPassword, SendTask.this.errorBean, IdeaLogger.getOurCompilationTimestamp());
                            callback.consume((Object)threadId);
                        }
                    }
                    catch (Exception ex) {
                        errback.consume((Object)ex);
                    }
                }
            };
            if (this.myProject == null) {
                task.run((ProgressIndicator)new EmptyProgressIndicator());
            } else {
                ProgressManager.getInstance().run((Task)task);
            }
        }
    }
}

