/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.IconUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class NewBranchAction<T extends Repository>
extends DumbAwareAction {
    protected final List<T> myRepositories;
    protected Project myProject;

    public NewBranchAction(@NotNull Project project, @NotNull List<T> repositories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/dvcs/ui/NewBranchAction", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/dvcs/ui/NewBranchAction", "<init>"));
        }
        super("New Branch", "Create and checkout new branch", IconUtil.getAddIcon());
        this.myRepositories = repositories;
        this.myProject = project;
    }

    public void update(AnActionEvent e) {
        if (DvcsUtil.anyRepositoryIsFresh(this.myRepositories)) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setDescription("Checkout of a new branch is not possible before the first commit.");
        }
    }

    public abstract void actionPerformed(AnActionEvent var1);
}

