/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryUtil {
    private static final Logger LOGGER = Logger.getInstance(RepositoryUtil.class);
    private static final int IO_RETRIES = 3;

    public static void assertFileExists(File file, String message) {
        if (!file.exists()) {
            throw new RepoStateException(message);
        }
    }

    @NotNull
    public static String tryLoadFile(final @NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/dvcs/repo/RepositoryUtil", "tryLoadFile"));
        }
        String string = RepositoryUtil.tryOrThrow(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)file).trim());
            }
        }, file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/RepositoryUtil", "tryLoadFile"));
        }
        return string;
    }

    public static String tryOrThrow(Callable<String> actionToTry, File fileToLoad) {
        IOException cause = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return actionToTry.call();
            }
            catch (IOException e) {
                LOGGER.info("IOException while loading " + fileToLoad, (Throwable)e);
                cause = e;
                continue;
            }
            catch (Exception e) {
                throw new RepoStateException("Couldn't load file " + fileToLoad, e);
            }
        }
        throw new RepoStateException("Couldn't load file " + fileToLoad, cause);
    }

    public static void visitVcsDirVfs(@NotNull VirtualFile gitDir, @NotNull Collection<String> subDirs) {
        if (gitDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/dvcs/repo/RepositoryUtil", "visitVcsDirVfs"));
        }
        if (subDirs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/dvcs/repo/RepositoryUtil", "visitVcsDirVfs"));
        }
        gitDir.getChildren();
        for (String subdir : subDirs) {
            VirtualFile dir = gitDir.findFileByRelativePath(subdir);
            RepositoryUtil.visitAllChildrenRecursively(dir);
        }
    }

    public static void visitAllChildrenRecursively(@Nullable VirtualFile dir) {
        if (dir == null) {
            return;
        }
        VfsUtil.processFilesRecursively((VirtualFile)dir, (Processor)new Processor<VirtualFile>(){

            public boolean process(VirtualFile virtualFile) {
                return true;
            }
        });
    }

    public static <T extends Repository> List<T> sortRepositories(@NotNull Collection<T> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/dvcs/repo/RepositoryUtil", "sortRepositories"));
        }
        List repos = ContainerUtil.filter(repositories, (Condition)new Condition<T>(){

            public boolean value(T t) {
                return t.getRoot().isValid();
            }
        });
        Collections.sort(repos, new Comparator<Repository>(){

            @Override
            public int compare(Repository o1, Repository o2) {
                return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
            }
        });
        return repos;
    }

    public static class Updater
    implements Consumer<Object> {
        private final Repository myRepository;

        public Updater(Repository repository) {
            this.myRepository = repository;
        }

        public void consume(Object dummy) {
            this.myRepository.update();
        }
    }
}

