/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.repo.RepositoryUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRepositoryManager<T extends Repository>
extends AbstractProjectComponent
implements Disposable,
RepositoryManager<T>,
VcsListener {
    private static final Logger LOG = Logger.getInstance(RepositoryManager.class);
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final AbstractVcs myVcs;
    @NotNull
    private final String myRepoDirName;
    @NotNull
    protected final Map<VirtualFile, T> myRepositories;
    @NotNull
    protected final ReentrantReadWriteLock REPO_LOCK;
    @NotNull
    private final CountDownLatch myInitializationWaiter;

    protected AbstractRepositoryManager(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager, @NotNull AbstractVcs vcs, @NotNull String repoDirName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/dvcs/repo/AbstractRepositoryManager", "<init>"));
        }
        if (vcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/dvcs/repo/AbstractRepositoryManager", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/dvcs/repo/AbstractRepositoryManager", "<init>"));
        }
        if (repoDirName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/dvcs/repo/AbstractRepositoryManager", "<init>"));
        }
        super(project);
        this.myRepositories = new HashMap<VirtualFile, T>();
        this.REPO_LOCK = new ReentrantReadWriteLock();
        this.myInitializationWaiter = new CountDownLatch(1);
        this.myVcsManager = vcsManager;
        this.myVcs = vcs;
        this.myRepoDirName = repoDirName;
    }

    public void initComponent() {
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.REPO_LOCK.writeLock().lock();
            this.myRepositories.clear();
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public void directoryMappingChanged() {
        this.updateRepositoriesCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T getRepositoryForRoot(@Nullable VirtualFile root) {
        if (root == null) {
            return null;
        }
        try {
            this.REPO_LOCK.readLock().lock();
            Repository repository = (Repository)this.myRepositories.get(root);
            return (T)repository;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    @Override
    @Nullable
    public T getRepositoryForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/dvcs/repo/AbstractRepositoryManager", "getRepositoryForFile"));
        }
        VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(file);
        return this.getRepositoryForVcsRoot(vcsRoot, file.getPath());
    }

    @Override
    public T getRepositoryForFile(@NotNull FilePath file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/dvcs/repo/AbstractRepositoryManager", "getRepositoryForFile"));
        }
        VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(file);
        return this.getRepositoryForVcsRoot(vcsRoot, file.getPath());
    }

    @Nullable
    private T getRepositoryForVcsRoot(@Nullable VcsRoot vcsRoot, @NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/dvcs/repo/AbstractRepositoryManager", "getRepositoryForVcsRoot"));
        }
        if (vcsRoot == null) {
            return null;
        }
        AbstractVcs vcs = vcsRoot.getVcs();
        if (!this.myVcs.equals((Object)vcs)) {
            if (vcs != null) {
                LOG.debug(String.format("getRepositoryForFile returned non-(%s) root for file %s", this.myVcs.getDisplayName(), filePath));
            }
            return null;
        }
        return this.getRepositoryForRoot(vcsRoot.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<T> getRepositories() {
        this.REPO_LOCK.readLock().lock();
        List<T> list = RepositoryUtil.sortRepositories(this.myRepositories.values());
        List<T> list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/AbstractRepositoryManager", "getRepositories"));
        }
        return list2;
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    @Override
    public boolean moreThanOneRoot() {
        return this.myRepositories.size() > 1;
    }

    @Override
    public void updateRepository(@Nullable VirtualFile root) {
        T repo = this.getRepositoryForRoot(root);
        if (repo != null) {
            repo.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAllRepositories() {
        HashMap<VirtualFile, T> repositories;
        try {
            this.REPO_LOCK.readLock().lock();
            repositories = new HashMap<VirtualFile, T>(this.myRepositories);
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
        for (VirtualFile root : repositories.keySet()) {
            this.updateRepository(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRepositoriesCollection() {
        HashMap<VirtualFile, T> repositories;
        try {
            this.REPO_LOCK.readLock().lock();
            repositories = new HashMap<VirtualFile, T>(this.myRepositories);
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
        Object[] roots = this.myVcsManager.getRootsUnderVcs(this.myVcs);
        Iterator iterator = repositories.entrySet().iterator();
        while (iterator.hasNext()) {
            if (ArrayUtil.contains((Object)((Repository)iterator.next().getValue()).getRoot(), (Object[])roots)) continue;
            iterator.remove();
        }
        for (Object root : roots) {
            if (repositories.containsKey(root)) continue;
            if (this.isRootValid((VirtualFile)root)) {
                try {
                    T repository = this.createRepository((VirtualFile)root);
                    repositories.put((VirtualFile)root, repository);
                }
                catch (RepoStateException e) {
                    LOG.error("Couldn't initialize Repository in " + root.getPresentableUrl(), (Throwable)e);
                }
                continue;
            }
            LOG.info("Invalid vcs root: " + root);
        }
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myRepositories.clear();
            this.myRepositories.putAll(repositories);
            this.myInitializationWaiter.countDown();
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    private boolean isRootValid(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/dvcs/repo/AbstractRepositoryManager", "isRootValid"));
        }
        VirtualFile vcsDir = root.findChild(this.myRepoDirName);
        return vcsDir != null && vcsDir.exists();
    }

    @NotNull
    protected abstract T createRepository(@NotNull VirtualFile var1);

    @NotNull
    public String toString() {
        String string = "RepositoryManager{myRepositories: " + this.myRepositories + '}';
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/AbstractRepositoryManager", "toString"));
        }
        return string;
    }

    @Override
    public void waitUntilInitialized() {
        try {
            this.myInitializationWaiter.await();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
    }
}

