/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.ErrorReportConfigurable;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.JetBrainsAccountDialog;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.errorreport.ErrorReportSender;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.errorreport.error.InternalEAPException;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.errorreport.error.UpdateAvailableException;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.idea.IdeaLogger;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public class ITNReporter
extends ErrorReportSubmitter {
    private static int previousExceptionThreadId = 0;
    private static boolean wasException = false;
    @NonNls
    private static final String URL_HEADER = "http://www.intellij.net/tracker/idea/viewSCR?publicId=";

    public String getReportActionText() {
        return DiagnosticBundle.message("error.report.to.jetbrains.action", new Object[0]);
    }

    public SubmittedReportInfo submit(IdeaLoggingEvent[] events, Component parentComponent) {
        return new SubmittedReportInfo(null, "0", SubmittedReportInfo.SubmissionStatus.FAILED);
    }

    public boolean trySubmitAsync(IdeaLoggingEvent[] events, String additionalInfo, Component parentComponent, Consumer<SubmittedReportInfo> consumer) {
        return ITNReporter.sendError(events[0], additionalInfo, parentComponent, consumer);
    }

    public boolean showErrorInRelease(IdeaLoggingEvent event) {
        return false;
    }

    private static boolean sendError(IdeaLoggingEvent event, String additionalInfo, Component parentComponent, Consumer<SubmittedReportInfo> callback) {
        ErrorBean errorBean = new ErrorBean(event.getThrowable(), IdeaLogger.ourLastActionId);
        return ITNReporter.doSubmit(event, parentComponent, callback, errorBean, additionalInfo);
    }

    private static boolean doSubmit(final IdeaLoggingEvent event, final Component parentComponent, final Consumer<SubmittedReportInfo> callback, final ErrorBean errorBean, final String description) {
        Object data;
        IdeaPluginDescriptor ideaPluginDescriptor;
        PluginId pluginId;
        Throwable t;
        DataContext dataContext = DataManager.getInstance().getDataContext(parentComponent);
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        ErrorReportConfigurable errorReportConfigurable = ErrorReportConfigurable.getInstance();
        if (!errorReportConfigurable.KEEP_ITN_PASSWORD && !StringUtil.isEmpty((String)errorReportConfigurable.ITN_LOGIN) && StringUtil.isEmpty((String)errorReportConfigurable.getPlainItnPassword())) {
            JetBrainsAccountDialog dlg = new JetBrainsAccountDialog(parentComponent);
            dlg.show();
            if (!dlg.isOK()) {
                return false;
            }
        }
        errorBean.setDescription(description);
        errorBean.setMessage(event.getMessage());
        if (previousExceptionThreadId != 0) {
            errorBean.setPreviousException(previousExceptionThreadId);
        }
        if ((t = event.getThrowable()) != null && (pluginId = IdeErrorsDialog.findPluginId(t)) != null && (ideaPluginDescriptor = PluginManager.getPlugin(pluginId)) != null && !ideaPluginDescriptor.isBundled()) {
            errorBean.setPluginName(ideaPluginDescriptor.getName());
            errorBean.setPluginVersion(ideaPluginDescriptor.getVersion());
        }
        if ((data = event.getData()) instanceof AbstractMessage) {
            errorBean.setAssigneeId(((AbstractMessage)data).getAssigneeId());
        }
        if (data instanceof LogMessageEx) {
            errorBean.setAttachments(((LogMessageEx)data).getAttachments());
        }
        String login = errorReportConfigurable.ITN_LOGIN;
        String password = errorReportConfigurable.getPlainItnPassword();
        if (login.trim().length() == 0 && password.trim().length() == 0) {
            login = "idea_anonymous";
            password = "guest";
        }
        ErrorReportSender.sendError(project, login, password, errorBean, new Consumer<Integer>(){

            public void consume(Integer threadId) {
                previousExceptionThreadId = threadId;
                wasException = true;
                final SubmittedReportInfo reportInfo = new SubmittedReportInfo(ITNReporter.URL_HEADER + threadId, String.valueOf(threadId), SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
                callback.consume((Object)reportInfo);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StringBuilder text = new StringBuilder();
                        String url = IdeErrorsDialog.getUrl(reportInfo, true);
                        IdeErrorsDialog.appendSubmissionInformation(reportInfo, text, url);
                        text.append(".");
                        if (reportInfo.getStatus() != SubmittedReportInfo.SubmissionStatus.FAILED) {
                            text.append("<br/>").append(DiagnosticBundle.message("error.report.gratitude", new Object[0]));
                        }
                        NotificationType type = reportInfo.getStatus() == SubmittedReportInfo.SubmissionStatus.FAILED ? NotificationType.ERROR : NotificationType.INFORMATION;
                        NotificationListener.UrlOpeningListener listener = url != null ? new NotificationListener.UrlOpeningListener(true) : null;
                        ReportMessages.GROUP.createNotification(ReportMessages.ERROR_REPORT, XmlStringUtil.wrapInHtml((CharSequence)text), type, (NotificationListener)listener).setImportant(false).notify(project);
                    }
                });
            }
        }, new Consumer<Exception>(){

            public void consume(final Exception e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String msg = e instanceof NoSuchEAPUserException ? DiagnosticBundle.message("error.report.authentication.failed", new Object[0]) : (e instanceof InternalEAPException ? DiagnosticBundle.message("error.report.posting.failed", e.getMessage()) : DiagnosticBundle.message("error.report.sending.failure", new Object[0]));
                        if (e instanceof UpdateAvailableException) {
                            String message = DiagnosticBundle.message("error.report.new.eap.build.message", e.getMessage());
                            ITNReporter.showMessageDialog(parentComponent, project, message, CommonBundle.getWarningTitle(), Messages.getWarningIcon());
                            callback.consume((Object)new SubmittedReportInfo(null, "0", SubmittedReportInfo.SubmissionStatus.FAILED));
                        } else if (ITNReporter.showYesNoDialog(parentComponent, project, msg, ReportMessages.ERROR_REPORT, Messages.getErrorIcon()) != 0) {
                            callback.consume((Object)new SubmittedReportInfo(null, "0", SubmittedReportInfo.SubmissionStatus.FAILED));
                        } else {
                            if (e instanceof NoSuchEAPUserException) {
                                JetBrainsAccountDialog dialog = parentComponent.isShowing() ? new JetBrainsAccountDialog(parentComponent) : new JetBrainsAccountDialog(project);
                                dialog.show();
                            }
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ITNReporter.doSubmit(event, parentComponent, (Consumer<SubmittedReportInfo>)callback, errorBean, description);
                                }
                            });
                        }
                    }
                });
            }
        });
        return true;
    }

    private static void showMessageDialog(Component parentComponent, Project project, String message, String title, Icon icon) {
        if (parentComponent.isShowing()) {
            Messages.showMessageDialog((Component)parentComponent, (String)message, (String)title, (Icon)icon);
        } else {
            Messages.showMessageDialog((Project)project, (String)message, (String)title, (Icon)icon);
        }
    }

    @Messages.YesNoResult
    private static int showYesNoDialog(Component parentComponent, Project project, String message, String title, Icon icon) {
        if (parentComponent.isShowing()) {
            return Messages.showYesNoDialog((Component)parentComponent, (String)message, (String)title, (Icon)icon);
        }
        return Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)icon);
    }
}

