/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FieldDescriptorImpl
extends ValueDescriptorImpl
implements FieldDescriptor {
    public static final String OUTER_LOCAL_VAR_FIELD_PREFIX = "val$";
    private final Field myField;
    private final ObjectReference myObject;
    private Boolean myIsPrimitive;
    private final boolean myIsStatic;

    public FieldDescriptorImpl(Project project, ObjectReference objRef, @NotNull Field field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/debugger/ui/impl/watch/FieldDescriptorImpl", "<init>"));
        }
        super(project);
        this.myIsPrimitive = null;
        this.myObject = objRef;
        this.myField = field;
        this.myIsStatic = field.isStatic();
        this.setLvalue(!field.isFinal());
    }

    @Override
    public Field getField() {
        return this.myField;
    }

    @Override
    public ObjectReference getObject() {
        return this.myObject;
    }

    public SourcePosition getSourcePosition(Project project, DebuggerContextImpl context) {
        DebugProcessImpl debugProcess;
        if (context.getFrameProxy() == null) {
            return null;
        }
        ReferenceType type = this.myField.declaringType();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        String fieldName = this.myField.name();
        if (fieldName.startsWith(OUTER_LOCAL_VAR_FIELD_PREFIX)) {
            String varName = fieldName.substring(fieldName.lastIndexOf(36) + 1);
            PsiElement element = PositionUtil.getContextElement((StackFrameContext)context);
            if (element == null) {
                return null;
            }
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
            if (aClass == null) {
                return null;
            }
            aClass = (PsiClass)aClass.getNavigationElement();
            PsiVariable psiVariable = facade.getResolveHelper().resolveReferencedVariable(varName, (PsiElement)aClass);
            if (psiVariable == null) {
                return null;
            }
            return SourcePosition.createFromOffset((PsiFile)psiVariable.getContainingFile(), (int)psiVariable.getTextOffset());
        }
        DebuggerSession session = context.getDebuggerSession();
        GlobalSearchScope scope = session != null ? session.getSearchScope() : GlobalSearchScope.allScope((Project)this.myProject);
        PsiClass aClass = facade.findClass(type.name().replace('$', '.'), scope);
        if (aClass == null && (debugProcess = context.getDebugProcess()) != null) {
            try {
                List<Location> locations = type.allLineLocations();
                if (!locations.isEmpty()) {
                    Location lastLocation = locations.get(locations.size() - 1);
                    SourcePosition position = debugProcess.getPositionManager().getSourcePosition(lastLocation);
                    if (position != null) {
                        aClass = JVMNameUtil.getClassAt(position);
                    }
                }
            }
            catch (AbsentInformationException ignored) {
            }
            catch (ClassNotPreparedException ignored) {
                // empty catch block
            }
        }
        if (aClass != null) {
            aClass = (PsiClass)aClass.getNavigationElement();
            for (PsiField field : aClass.getFields()) {
                if (!fieldName.equals(field.getName())) continue;
                return SourcePosition.createFromOffset((PsiFile)field.getContainingFile(), (int)field.getTextOffset());
            }
        }
        return null;
    }

    @Override
    public void setAncestor(NodeDescriptor oldDescriptor) {
        super.setAncestor(oldDescriptor);
        Boolean isPrimitive = ((FieldDescriptorImpl)oldDescriptor).myIsPrimitive;
        if (isPrimitive != null) {
            this.myIsPrimitive = isPrimitive;
        }
    }

    @Override
    public boolean isPrimitive() {
        if (this.myIsPrimitive == null) {
            Value value = this.getValue();
            this.myIsPrimitive = value != null ? Boolean.valueOf(super.isPrimitive()) : (DebuggerUtils.isPrimitiveType((String)this.myField.typeName()) ? Boolean.TRUE : Boolean.FALSE);
        }
        return this.myIsPrimitive;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            return this.myObject != null ? this.myObject.getValue(this.myField) : this.myField.declaringType().getValue(this.myField);
        }
        catch (ObjectCollectedException ignored) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    @Override
    public String getName() {
        String fieldName = this.myField.name();
        if (this.isOuterLocalVariableValue() && NodeRendererSettings.getInstance().getClassRenderer().SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES) {
            return StringUtil.trimStart((String)fieldName, (String)OUTER_LOCAL_VAR_FIELD_PREFIX);
        }
        return fieldName;
    }

    public boolean isOuterLocalVariableValue() {
        try {
            return DebuggerUtils.isSynthetic((TypeComponent)this.myField) && this.myField.name().startsWith(OUTER_LOCAL_VAR_FIELD_PREFIX);
        }
        catch (UnsupportedOperationException ignored) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String calcValueName() {
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            buf.append(this.getName());
            if (classRenderer.SHOW_DECLARED_TYPE) {
                buf.append(": ");
                buf.append(classRenderer.renderTypeName(this.myField.typeName()));
            }
            String string = buf.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        String fieldName;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        if (this.isStatic()) {
            String typeName = this.myField.declaringType().name().replace('$', '.');
            typeName = DebuggerTreeNodeExpression.normalize(typeName, PositionUtil.getContextElement((StackFrameContext)context), context.getProject());
            fieldName = typeName + "." + this.getName();
        } else {
            fieldName = this.isOuterLocalVariableValue() ? StringUtil.trimStart((String)this.getName(), (String)OUTER_LOCAL_VAR_FIELD_PREFIX) : "this." + this.getName();
        }
        try {
            return elementFactory.createExpressionFromText(fieldName, null);
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.field.name", (Object[])new Object[]{this.getName()}), (Throwable)e);
        }
    }
}

