/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EvaluationDescriptor
extends ValueDescriptorImpl {
    private Modifier myModifier;
    protected TextWithImports myText;
    private CodeFragmentFactory myCodeFragmentFactory = null;

    protected EvaluationDescriptor(TextWithImports text, Project project, Value value) {
        super(project, value);
        this.myText = text;
    }

    protected EvaluationDescriptor(TextWithImports text, Project project) {
        super(project);
        this.setLvalue(false);
        this.myText = text;
    }

    public final void setCodeFragmentFactory(CodeFragmentFactory codeFragmentFactory) {
        this.myCodeFragmentFactory = codeFragmentFactory != null ? new CodeFragmentFactoryContextWrapper(codeFragmentFactory) : null;
    }

    @Nullable
    public final CodeFragmentFactory getCodeFragmentFactory() {
        return this.myCodeFragmentFactory;
    }

    @NotNull
    protected final CodeFragmentFactory getEffectiveCodeFragmentFactory(PsiElement psiContext) {
        if (this.myCodeFragmentFactory != null) {
            CodeFragmentFactory codeFragmentFactory = this.myCodeFragmentFactory;
            if (codeFragmentFactory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/EvaluationDescriptor", "getEffectiveCodeFragmentFactory"));
            }
            return codeFragmentFactory;
        }
        CodeFragmentFactory codeFragmentFactory = DebuggerUtilsEx.getEffectiveCodeFragmentFactory(psiContext);
        if (codeFragmentFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/EvaluationDescriptor", "getEffectiveCodeFragmentFactory"));
        }
        return codeFragmentFactory;
    }

    protected abstract EvaluationContextImpl getEvaluationContext(EvaluationContextImpl var1);

    protected abstract PsiCodeFragment getEvaluationCode(StackFrameContext var1) throws EvaluateException;

    @Override
    public final Value calcValue(final EvaluationContextImpl evaluationContext) throws EvaluateException {
        try {
            final EvaluationContextImpl thisEvaluationContext = this.getEvaluationContext(evaluationContext);
            ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, new EvaluatingComputable<ExpressionEvaluator>(){

                @Override
                public ExpressionEvaluator compute() throws EvaluateException {
                    PsiElement psiContext = PositionUtil.getContextElement((StackFrameContext)evaluationContext);
                    return EvaluationDescriptor.this.getEffectiveCodeFragmentFactory(psiContext).getEvaluatorBuilder().build((PsiElement)EvaluationDescriptor.this.getEvaluationCode((StackFrameContext)thisEvaluationContext), ContextUtil.getSourcePosition((StackFrameContext)thisEvaluationContext));
                }
            });
            if (!thisEvaluationContext.getDebugProcess().isAttached()) {
                throw EvaluateExceptionUtil.PROCESS_EXITED;
            }
            StackFrameProxyImpl frameProxy = thisEvaluationContext.getFrameProxy();
            if (frameProxy == null) {
                throw EvaluateExceptionUtil.NULL_STACK_FRAME;
            }
            Value value = evaluator.evaluate((EvaluationContext)thisEvaluationContext);
            if (value instanceof ObjectReference) {
                thisEvaluationContext.getSuspendContext().keep((ObjectReference)value);
            }
            this.myModifier = evaluator.getModifier();
            this.setLvalue(this.myModifier != null);
            return value;
        }
        catch (EvaluateException ex) {
            throw new EvaluateException(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    @Override
    public String calcValueName() {
        return this.getName();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiCodeFragment evaluationCode = this.getEvaluationCode((StackFrameContext)context);
        if (evaluationCode instanceof PsiExpressionCodeFragment) {
            return ((PsiExpressionCodeFragment)evaluationCode).getExpression();
        }
        throw new EvaluateException(DebuggerBundle.message((String)"error.cannot.create.expression.from.code.fragment", (Object[])new Object[0]), null);
    }

    public Modifier getModifier() {
        return this.myModifier;
    }

    @Override
    public boolean canSetValue() {
        return super.canSetValue() && this.myModifier != null && this.myModifier.canSetValue();
    }

    public TextWithImports getEvaluationText() {
        return this.myText;
    }
}

