/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.TipManager;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.ui.GeometryUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeBase
extends DnDAwareTree
implements Disposable {
    private final Project myProject;
    private DebuggerTreeNodeImpl myCurrentTooltipNode;
    private JComponent myCurrentTooltip;
    protected final TipManager myTipManager;

    public DebuggerTreeBase(TreeModel model, Project project) {
        super(model);
        this.myProject = project;
        this.myTipManager = new TipManager((JComponent)((Object)this), new TipManager.TipFactory(){

            @Override
            public JComponent createToolTip(MouseEvent e) {
                return DebuggerTreeBase.this.createToolTip(e);
            }

            @Override
            public MouseEvent createTooltipEvent(MouseEvent candidateEvent) {
                return DebuggerTreeBase.this.createTooltipEvent(candidateEvent);
            }

            @Override
            public boolean isFocusOwner() {
                return DebuggerTreeBase.this.isFocusOwner();
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myTipManager);
        UIUtil.setLineStyleAngled((JTree)((Object)this));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer((TreeCellRenderer)((Object)new DebuggerTreeRenderer()));
        this.updateUI();
        TreeUtil.installActions((JTree)((Object)this));
    }

    private JComponent createTipContent(String tipText, DebuggerTreeNodeImpl node) {
        JToolTip tooltip = new JToolTip();
        if (tipText == null) {
            tooltip.setTipText(tipText);
        } else {
            Dimension rootSize = this.getVisibleRect().getSize();
            Insets borderInsets = tooltip.getBorder().getBorderInsets(tooltip);
            rootSize.width -= (borderInsets.left + borderInsets.right) * 2;
            rootSize.height -= (borderInsets.top + borderInsets.bottom) * 2;
            StringBuilder tipBuilder = new StringBuilder();
            String markupText = node.getMarkupTooltipText();
            if (markupText != null) {
                tipBuilder.append(markupText);
            }
            if (!tipText.isEmpty()) {
                StringTokenizer tokenizer = new StringTokenizer(tipText, "\n ", true);
                while (tokenizer.hasMoreElements()) {
                    String each = tokenizer.nextElement();
                    if ("\n".equals(each)) {
                        tipBuilder.append("<br>");
                        continue;
                    }
                    if (" ".equals(each)) {
                        tipBuilder.append("&nbsp ");
                        continue;
                    }
                    tipBuilder.append(JDOMUtil.legalizeText((String)each));
                }
            }
            tooltip.setTipText(UIUtil.toHtml((String)tipBuilder.toString(), (int)0));
        }
        tooltip.setBorder(null);
        return tooltip;
    }

    public MouseEvent createTooltipEvent(MouseEvent candidate) {
        TreePath path = null;
        if (candidate != null) {
            Point treePoint = SwingUtilities.convertPoint(candidate.getComponent(), candidate.getPoint(), (Component)((Object)this));
            if (GeometryUtil.isWithin((Rectangle)new Rectangle(0, 0, this.getWidth(), this.getHeight()), (Point2D)treePoint)) {
                path = this.getPathForLocation(treePoint.x, treePoint.y);
            }
        }
        if (path == null && this.isFocusOwner()) {
            path = this.getSelectionPath();
        }
        if (path == null) {
            return null;
        }
        int row = this.getRowForPath(path);
        if (row == -1) {
            return null;
        }
        Rectangle bounds = this.getRowBounds(row);
        return new MouseEvent((Component)((Object)this), 503, System.currentTimeMillis(), 0, bounds.x, bounds.y + bounds.height - bounds.height / 4, 0, false);
    }

    @Nullable
    public JComponent createToolTip(MouseEvent e) {
        DebuggerTreeNodeImpl node = this.getNodeToShowTip(e);
        if (node == null) {
            return null;
        }
        if (this.myCurrentTooltip != null && this.myCurrentTooltip.isShowing() && this.myCurrentTooltipNode == node) {
            return this.myCurrentTooltip;
        }
        this.myCurrentTooltipNode = node;
        String toolTipText = this.getTipText(node);
        if (toolTipText == null) {
            return null;
        }
        JComponent tipContent = this.createTipContent(toolTipText, node);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)tipContent);
        scrollPane.setBorder(null);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        Point point = e.getPoint();
        SwingUtilities.convertPointToScreen(point, e.getComponent());
        Rectangle tipRectangle = new Rectangle(point, tipContent.getPreferredSize());
        Rectangle screen = ScreenUtil.getScreenRectangle((int)point.x, (int)point.y);
        JToolTip toolTip = new JToolTip();
        tipContent.addMouseListener(new HideTooltip(toolTip));
        Border tooltipBorder = toolTip.getBorder();
        if (tooltipBorder != null) {
            Insets borderInsets = tooltipBorder.getBorderInsets((Component)((Object)this));
            tipRectangle.setSize(tipRectangle.width + borderInsets.left + borderInsets.right, tipRectangle.height + borderInsets.top + borderInsets.bottom);
        }
        toolTip.setLayout(new BorderLayout());
        toolTip.add((Component)scrollPane, "Center");
        tipRectangle.height += scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        tipRectangle.width += scrollPane.getVerticalScrollBar().getPreferredSize().width;
        int maxWidth = (int)((double)screen.width - (double)screen.width * 0.25);
        if (tipRectangle.width > maxWidth) {
            tipRectangle.width = maxWidth;
        }
        Dimension prefSize = tipRectangle.getSize();
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)tipRectangle);
        if (prefSize.width > tipRectangle.width) {
            int delta = prefSize.width - tipRectangle.width;
            tipRectangle.x -= delta;
            if (tipRectangle.x < screen.x) {
                tipRectangle.x = screen.x + maxWidth / 2;
                tipRectangle.width = screen.width - maxWidth / 2;
            } else {
                tipRectangle.width += delta;
            }
        }
        toolTip.setPreferredSize(tipRectangle.getSize());
        this.myCurrentTooltip = toolTip;
        return this.myCurrentTooltip;
    }

    @Nullable
    private String getTipText(DebuggerTreeNodeImpl node) {
        String text;
        NodeDescriptorImpl descriptor = node.getDescriptor();
        if (descriptor instanceof ValueDescriptorImpl && (text = ((ValueDescriptorImpl)descriptor).getValueLabel()) != null) {
            String tipText;
            int idx;
            if (StringUtil.startsWithChar((CharSequence)text, (char)'{') && text.indexOf(125) > 0 && (idx = text.indexOf(125)) != text.length() - 1) {
                text = text.substring(idx + 1);
            }
            if (StringUtil.startsWithChar((CharSequence)text, (char)'\"') && StringUtil.endsWithChar((CharSequence)text, (char)'\"')) {
                text = text.substring(1, text.length() - 1);
            }
            if (!((tipText = this.prepareToolTipText(text)).isEmpty() || tipText.indexOf(10) < 0 && this.getVisibleRect().contains(this.getRowBounds(this.getRowForPath(new TreePath(node.getPath())))))) {
                return tipText;
            }
        }
        return node.getMarkupTooltipText() != null ? "" : null;
    }

    @Nullable
    private DebuggerTreeNodeImpl getNodeToShowTip(MouseEvent event) {
        Object last;
        TreePath path = this.getPathForLocation(event.getX(), event.getY());
        if (path != null && (last = path.getLastPathComponent()) instanceof DebuggerTreeNodeImpl) {
            return (DebuggerTreeNodeImpl)last;
        }
        return null;
    }

    private String prepareToolTipText(String text) {
        int tabSize = CodeStyleSettingsManager.getSettings((Project)this.myProject).getTabSize((FileType)StdFileTypes.JAVA);
        if (tabSize < 0) {
            tabSize = 0;
        }
        StringBuilder buf = new StringBuilder();
        boolean special = false;
        for (int idx = 0; idx < text.length(); ++idx) {
            char c = text.charAt(idx);
            if (special) {
                if (c == 't') {
                    for (int i = 0; i < tabSize; ++i) {
                        buf.append(' ');
                    }
                } else if (c != 'r') {
                    if (c == 'n') {
                        buf.append('\n');
                    } else if (c == '\"') {
                        buf.append('\"');
                    } else {
                        buf.append('\\');
                        buf.append(c);
                    }
                }
                special = false;
                continue;
            }
            if (c == '\\') {
                special = true;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public void dispose() {
        JComponent tooltip = this.myCurrentTooltip;
        if (tooltip != null) {
            tooltip.setVisible(false);
        }
        this.myCurrentTooltip = null;
        this.myCurrentTooltipNode = null;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static class HideTooltip
    extends MouseAdapter {
        private final JToolTip myToolTip;

        public HideTooltip(JToolTip toolTip) {
            this.myToolTip = toolTip;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Window wnd;
            if (UIUtil.isActionClick((MouseEvent)e) && (wnd = SwingUtilities.getWindowAncestor(this.myToolTip)) instanceof JWindow) {
                wnd.setVisible(false);
            }
        }
    }
}

