/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.ui.CompletionEditor;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.debugger.ui.DebuggerStatementEditor;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointDefaults;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.EditClassFiltersDialog;
import com.intellij.debugger.ui.breakpoints.EditInstanceFiltersDialog;
import com.intellij.debugger.ui.breakpoints.EnableBreakpointRule;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiClass;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IJSwingUtilities;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointChooser;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointNoneItem;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.Nullable;

public abstract class BreakpointPropertiesPanel {
    private BreakpointChooser myMasterBreakpointChooser;
    protected final Project myProject;
    private final Key<? extends Breakpoint> myBreakpointCategory;
    private boolean myCompact;
    private JPanel myPanel;
    private final DebuggerExpressionComboBox myConditionCombo;
    private final DebuggerExpressionComboBox myLogExpressionCombo;
    private JTextField myPassCountField;
    private final FieldPanel myInstanceFiltersField;
    private final FieldPanel myClassFiltersField;
    private com.intellij.ui.classFilter.ClassFilter[] myClassFilters;
    private com.intellij.ui.classFilter.ClassFilter[] myClassExclusionFilters;
    private InstanceFilter[] myInstanceFilters;
    private JCheckBox myLogExpressionCheckBox;
    private JCheckBox myLogMessageCheckBox;
    protected JCheckBox myPassCountCheckbox;
    private JCheckBox myInstanceFiltersCheckBox;
    private JCheckBox myClassFiltersCheckBox;
    private JPanel myInstanceFiltersFieldPanel;
    private JPanel myClassFiltersFieldPanel;
    private JPanel myConditionComboPanel;
    private JPanel myLogExpressionComboPanel;
    private JPanel myDependentBreakpointComboPanel;
    private JPanel mySpecialBoxPanel;
    private PsiClass myBreakpointPsiClass;
    private JRadioButton myRbSuspendThread;
    private JRadioButton myRbSuspendAll;
    private JCheckBox myCbSuspend;
    private JButton myMakeDefaultButton;
    private JRadioButton myDisableAgainRadio;
    private JRadioButton myLeaveEnabledRadioButton;
    private JLabel myEnableOrDisableLabel;
    private JPanel myDependsOnPanel;
    private JPanel myInstanceFiltersPanel;
    private JPanel myClassFiltersPanel;
    private JPanel myPassCountPanel;
    private JPanel myConditionsPanel;
    private JPanel myActionsPanel;
    private JCheckBox myConditionCheckbox;
    private JCheckBox myTemporaryCheckBox;
    private JCheckBox myEnabledCheckbox;
    ButtonGroup mySuspendPolicyGroup;
    public static final String CONTROL_LOG_MESSAGE = "logMessage";
    private final FixedSizeButton myConditionMagnifierButton;
    private boolean myMoreOptionsVisible = true;
    private Breakpoint myBreakpoint;
    private Delegate myDelegate;

    public void setDetailView(DetailView detailView) {
        this.myMasterBreakpointChooser.setDetailView(detailView);
    }

    public boolean isMoreOptionsVisible() {
        return this.myMoreOptionsVisible;
    }

    public JComponent getControl(String control) {
        if (CONTROL_LOG_MESSAGE.equals(control)) {
            return this.myLogExpressionCombo;
        }
        return null;
    }

    public void dispose() {
        if (this.myConditionCombo != null) {
            this.myConditionCombo.dispose();
        }
        if (this.myLogExpressionCombo != null) {
            this.myLogExpressionCombo.dispose();
        }
    }

    public void setActionsPanelVisible(boolean b) {
        this.myActionsPanel.setVisible(b);
    }

    public void setMoreOptionsVisible(boolean b) {
        this.myMoreOptionsVisible = b;
        this.myDependsOnPanel.setVisible(b);
        this.myConditionsPanel.setVisible(b);
        if (b) {
            this.myActionsPanel.setVisible(true);
        }
        if (!b) {
            this.myPanel.setPreferredSize(new Dimension(500, -1));
        }
    }

    public void setDelegate(Delegate delegate) {
        this.myDelegate = delegate;
    }

    private static void insert(JPanel panel, JComponent component) {
        panel.setLayout(new BorderLayout());
        panel.add((Component)component, "Center");
    }

    public BreakpointPropertiesPanel(Project project, final Key<? extends Breakpoint> breakpointCategory, boolean compact) {
        this.myProject = project;
        this.myBreakpointCategory = breakpointCategory;
        this.myCompact = compact;
        this.$$$setupUI$$$();
        this.mySuspendPolicyGroup = new ButtonGroup();
        this.mySuspendPolicyGroup.add(this.myRbSuspendAll);
        this.mySuspendPolicyGroup.add(this.myRbSuspendThread);
        this.updateSuspendPolicyRbFont();
        ItemListener suspendPolicyChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        };
        this.myCbSuspend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean enabled = BreakpointPropertiesPanel.this.myCbSuspend.isSelected();
                BreakpointPropertiesPanel.this.myRbSuspendAll.setEnabled(enabled);
                BreakpointPropertiesPanel.this.myRbSuspendThread.setEnabled(enabled);
            }
        });
        this.myRbSuspendAll.addItemListener(suspendPolicyChangeListener);
        this.myRbSuspendThread.addItemListener(suspendPolicyChangeListener);
        this.myConditionCheckbox.addItemListener(suspendPolicyChangeListener);
        this.myMakeDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointManager breakpointManager = BreakpointPropertiesPanel.getBreakpointManager(BreakpointPropertiesPanel.this.myProject);
                String suspendPolicy = BreakpointPropertiesPanel.this.getSelectedSuspendPolicy();
                breakpointManager.setBreakpointDefaults((Key<? extends Breakpoint>)breakpointCategory, new BreakpointDefaults(suspendPolicy, BreakpointPropertiesPanel.this.myConditionCheckbox.isSelected()));
                BreakpointPropertiesPanel.this.updateSuspendPolicyRbFont();
                if ("SuspendThread".equals(suspendPolicy)) {
                    BreakpointPropertiesPanel.this.myRbSuspendThread.requestFocus();
                } else {
                    BreakpointPropertiesPanel.this.myRbSuspendAll.requestFocus();
                }
                BreakpointPropertiesPanel.this.myMakeDefaultButton.setEnabled(false);
            }
        });
        this.myConditionCombo = new DebuggerExpressionComboBox(project, "LineBreakpoint condition");
        this.myConditionCombo.addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
                BreakpointPropertiesPanel.this.myConditionCheckbox.setSelected(true);
            }

            public void documentChanged(DocumentEvent event) {
            }
        });
        this.myConditionCombo.getEditorComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                BreakpointPropertiesPanel.this.myConditionCombo.setEnabled(true);
                BreakpointPropertiesPanel.this.myConditionCheckbox.setSelected(true);
            }
        });
        if (this.myCompact) {
            this.myPanel.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent event) {
                    DebuggerExpressionComboBox focus = BreakpointPropertiesPanel.this.myLogExpressionCheckBox.isSelected() ? BreakpointPropertiesPanel.this.myLogExpressionCombo : BreakpointPropertiesPanel.this.myConditionCombo;
                    IdeFocusManager.findInstance().requestFocus((Component)focus, true);
                }
            });
        }
        this.myLogExpressionCombo = new DebuggerExpressionComboBox(project, "LineBreakpoint logMessage");
        this.myInstanceFiltersField = new FieldPanel((JTextField)new MyTextField(), "", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointPropertiesPanel.this.reloadInstanceFilters();
                EditInstanceFiltersDialog _dialog = new EditInstanceFiltersDialog(BreakpointPropertiesPanel.this.myProject);
                _dialog.setFilters(BreakpointPropertiesPanel.this.myInstanceFilters);
                _dialog.show();
                if (_dialog.getExitCode() == 0) {
                    BreakpointPropertiesPanel.access$1502(BreakpointPropertiesPanel.this, _dialog.getFilters());
                    BreakpointPropertiesPanel.this.updateInstanceFilterEditor(true);
                }
            }
        }, null);
        this.myClassFiltersField = new FieldPanel((JTextField)new MyTextField(), "", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointPropertiesPanel.this.reloadClassFilters();
                ClassFilter classFilter = BreakpointPropertiesPanel.this.createClassConditionFilter();
                EditClassFiltersDialog _dialog = new EditClassFiltersDialog(BreakpointPropertiesPanel.this.myProject, classFilter);
                _dialog.setFilters(BreakpointPropertiesPanel.this.myClassFilters, BreakpointPropertiesPanel.this.myClassExclusionFilters);
                _dialog.show();
                if (_dialog.getExitCode() == 0) {
                    BreakpointPropertiesPanel.access$1602(BreakpointPropertiesPanel.this, _dialog.getFilters());
                    BreakpointPropertiesPanel.access$1702(BreakpointPropertiesPanel.this, _dialog.getExclusionFilters());
                    BreakpointPropertiesPanel.this.updateClassFilterEditor(true);
                }
            }
        }, null);
        ToolTipManager.sharedInstance().registerComponent(this.myClassFiltersField.getTextField());
        ToolTipManager.sharedInstance().registerComponent(this.myInstanceFiltersField.getTextField());
        JComponent specialBox = this.createSpecialBox();
        if (specialBox != null) {
            BreakpointPropertiesPanel.insert(this.mySpecialBoxPanel, specialBox);
        } else {
            this.mySpecialBoxPanel.setVisible(false);
        }
        JPanel conditionPanel = new JPanel(new BorderLayout());
        conditionPanel.add((Component)this.myConditionCombo, "Center");
        this.myConditionMagnifierButton = new FixedSizeButton((JComponent)this.myConditionCombo);
        conditionPanel.add((Component)this.myConditionMagnifierButton, "East");
        this.myConditionMagnifierButton.setFocusable(false);
        this.myConditionMagnifierButton.addActionListener((ActionListener)new MagnifierButtonAction(project, this.myConditionCombo, "Condition"));
        BreakpointPropertiesPanel.insert(this.myConditionComboPanel, conditionPanel);
        BreakpointPropertiesPanel.insert(this.myLogExpressionComboPanel, this.myLogExpressionCombo);
        BreakpointPropertiesPanel.insert(this.myInstanceFiltersFieldPanel, (JComponent)this.myInstanceFiltersField);
        BreakpointPropertiesPanel.insert(this.myClassFiltersFieldPanel, (JComponent)this.myClassFiltersField);
        DebuggerUIUtil.enableEditorOnCheck(this.myLogExpressionCheckBox, this.myLogExpressionCombo);
        ActionListener updateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointPropertiesPanel.this.updateCheckboxes();
            }
        };
        this.myPassCountCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (BreakpointPropertiesPanel.this.myPassCountCheckbox.isSelected()) {
                    BreakpointPropertiesPanel.this.myConditionCheckbox.setSelected(false);
                }
                BreakpointPropertiesPanel.this.updateCheckboxes();
            }
        });
        this.myInstanceFiltersCheckBox.addActionListener(updateListener);
        this.myClassFiltersCheckBox.addActionListener(updateListener);
        this.myConditionCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (BreakpointPropertiesPanel.this.myConditionCheckbox.isSelected()) {
                    BreakpointPropertiesPanel.this.myPassCountCheckbox.setSelected(false);
                }
                BreakpointPropertiesPanel.this.updateCheckboxes();
            }
        });
        DebuggerUIUtil.focusEditorOnCheck(this.myPassCountCheckbox, this.myPassCountField);
        DebuggerUIUtil.focusEditorOnCheck(this.myLogExpressionCheckBox, this.myLogExpressionCombo);
        DebuggerUIUtil.focusEditorOnCheck(this.myInstanceFiltersCheckBox, this.myInstanceFiltersField.getTextField());
        DebuggerUIUtil.focusEditorOnCheck(this.myClassFiltersCheckBox, this.myClassFiltersField.getTextField());
        DebuggerUIUtil.focusEditorOnCheck(this.myConditionCheckbox, this.myConditionCombo);
        IJSwingUtilities.adjustComponentsOnMac(this.myCbSuspend);
        IJSwingUtilities.adjustComponentsOnMac(this.myLogExpressionCheckBox);
        IJSwingUtilities.adjustComponentsOnMac(this.myLogMessageCheckBox);
        IJSwingUtilities.adjustComponentsOnMac(this.myTemporaryCheckBox);
        IJSwingUtilities.adjustComponentsOnMac(this.myEnabledCheckbox);
    }

    private List<BreakpointItem> getBreakpointItemsExceptMy() {
        ArrayList<BreakpointItem> items = new ArrayList<BreakpointItem>();
        DebuggerSupport support = DebuggerSupport.getDebuggerSupport(JavaDebuggerSupport.class);
        support.getBreakpointPanelProvider().provideBreakpointItems(this.myProject, items);
        for (BreakpointItem item : items) {
            if (item.getBreakpoint() != this.myBreakpoint) continue;
            items.remove(item);
            break;
        }
        items.add(new BreakpointNoneItem());
        return items;
    }

    private void saveMasterBreakpoint() {
        Breakpoint masterBreakpoint = (Breakpoint)this.myMasterBreakpointChooser.getSelectedBreakpoint();
        if (masterBreakpoint == null) {
            BreakpointPropertiesPanel.getBreakpointManager(this.myProject).removeBreakpointRule(this.myBreakpoint);
        } else {
            EnableBreakpointRule rule = this.findMasterBreakpointRule();
            boolean selected = this.myLeaveEnabledRadioButton.isSelected();
            if (rule != null) {
                if (rule.getMasterBreakpoint() != masterBreakpoint || rule.isLeaveEnabled() != selected) {
                    BreakpointPropertiesPanel.getBreakpointManager(this.myProject).removeBreakpointRule(rule);
                } else {
                    return;
                }
            }
            BreakpointPropertiesPanel.getBreakpointManager(this.myProject).addBreakpointRule(new EnableBreakpointRule(BreakpointPropertiesPanel.getBreakpointManager(this.myProject), masterBreakpoint, this.myBreakpoint, selected));
        }
    }

    private String getSelectedSuspendPolicy() {
        if (this.myRbSuspendThread.isSelected()) {
            return "SuspendThread";
        }
        return "SuspendAll";
    }

    private void updateSuspendPolicyRbFont() {
        Font font = this.myRbSuspendAll.getFont().deriveFont(0);
        Font boldFont = font.deriveFont(1);
    }

    protected ClassFilter createClassConditionFilter() {
        ClassFilter classFilter = this.myBreakpointPsiClass != null ? new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return BreakpointPropertiesPanel.this.myBreakpointPsiClass == aClass || aClass.isInheritor(BreakpointPropertiesPanel.this.myBreakpointPsiClass, true);
            }
        } : null;
        return classFilter;
    }

    protected JComponent createSpecialBox() {
        return null;
    }

    public void initFrom(Breakpoint breakpoint, boolean moreOptionsVisible1) {
    }

    private void initMasterBreakpointPanel() {
        EnableBreakpointRule rule = this.findMasterBreakpointRule();
        Breakpoint baseBreakpoint = rule != null ? rule.getMasterBreakpoint() : null;
        this.updateMasterBreakpointPanel(rule);
        this.myMasterBreakpointChooser = new BreakpointChooser(this.myProject, new BreakpointChooser.Delegate(){

            @Override
            public void breakpointChosen(Project project, BreakpointItem item) {
                boolean enabled = item != null && item.getBreakpoint() != null;
                BreakpointPropertiesPanel.this.myLeaveEnabledRadioButton.setEnabled(enabled);
                BreakpointPropertiesPanel.this.myDisableAgainRadio.setEnabled(enabled);
                BreakpointPropertiesPanel.this.myEnableOrDisableLabel.setEnabled(enabled);
                if (item != null) {
                    BreakpointPropertiesPanel.this.saveMasterBreakpoint();
                }
                BreakpointPropertiesPanel.this.updateMasterBreakpointPanel(BreakpointPropertiesPanel.this.findMasterBreakpointRule());
            }
        }, baseBreakpoint, this.getBreakpointItemsExceptMy());
        BreakpointPropertiesPanel.insert(this.myDependentBreakpointComboPanel, this.myMasterBreakpointChooser.getComponent());
    }

    @Nullable
    private EnableBreakpointRule findMasterBreakpointRule() {
        return this.myBreakpoint != null ? BreakpointPropertiesPanel.getBreakpointManager(this.myProject).findBreakpointRule(this.myBreakpoint) : null;
    }

    private void updateMasterBreakpointPanel(@Nullable EnableBreakpointRule rule) {
        boolean leaveEnabled;
        boolean bl = leaveEnabled = rule != null && rule.isLeaveEnabled();
        if (leaveEnabled) {
            this.myLeaveEnabledRadioButton.setSelected(true);
        } else {
            this.myDisableAgainRadio.setSelected(true);
        }
    }

    private static TextWithImportsImpl emptyText() {
        return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
    }

    public void saveTo(Breakpoint breakpoint) {
    }

    private static String concatWithEx(List<String> s, String concator, int N, String NthConcator) {
        String result = "";
        int i = 1;
        Iterator<String> iterator = s.iterator();
        while (iterator.hasNext()) {
            String str = iterator.next();
            result = result + str;
            if (iterator.hasNext()) {
                result = i % N == 0 ? result + NthConcator : result + concator;
            }
            ++i;
        }
        return result;
    }

    private void updateInstanceFilterEditor(boolean updateText) {
        ArrayList<String> filters = new ArrayList<String>();
        for (InstanceFilter instanceFilter : this.myInstanceFilters) {
            if (!instanceFilter.isEnabled()) continue;
            filters.add(Long.toString(instanceFilter.getId()));
        }
        if (updateText) {
            this.myInstanceFiltersField.setText(StringUtil.join(filters, (String)" "));
        }
        String tipText = BreakpointPropertiesPanel.concatWithEx(filters, " ", (int)Math.sqrt(this.myInstanceFilters.length) + 1, "\n");
        this.myInstanceFiltersField.getTextField().setToolTipText(tipText);
    }

    private void reloadInstanceFilters() {
        String filtersText = this.myInstanceFiltersField.getText();
        ArrayList<InstanceFilter> idxs = new ArrayList<InstanceFilter>();
        int startNumber = -1;
        for (int i = 0; i <= filtersText.length(); ++i) {
            if (i < filtersText.length() && Character.isDigit(filtersText.charAt(i))) {
                if (startNumber != -1) continue;
                startNumber = i;
                continue;
            }
            if (startNumber < 0) continue;
            idxs.add(InstanceFilter.create(filtersText.substring(startNumber, i)));
            startNumber = -1;
        }
        for (InstanceFilter instanceFilter : this.myInstanceFilters) {
            if (instanceFilter.isEnabled()) continue;
            idxs.add(instanceFilter);
        }
        this.myInstanceFilters = idxs.toArray(new InstanceFilter[idxs.size()]);
    }

    private void updateClassFilterEditor(boolean updateText) {
        ArrayList<String> filters = new ArrayList<String>();
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassFilters) {
            if (!classFilter.isEnabled()) continue;
            filters.add(classFilter.getPattern());
        }
        ArrayList<String> excludeFilters = new ArrayList<String>();
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassExclusionFilters) {
            if (!classFilter.isEnabled()) continue;
            excludeFilters.add("-" + classFilter.getPattern());
        }
        if (updateText) {
            String editorText = StringUtil.join(filters, (String)" ");
            if (!filters.isEmpty()) {
                editorText = editorText + " ";
            }
            editorText = editorText + StringUtil.join(excludeFilters, (String)" ");
            this.myClassFiltersField.setText(editorText);
        }
        int width = (int)Math.sqrt(this.myClassExclusionFilters.length + this.myClassFilters.length) + 1;
        String tipText = BreakpointPropertiesPanel.concatWithEx(filters, " ", width, "\n");
        if (!filters.isEmpty()) {
            tipText = tipText + "\n";
        }
        tipText = tipText + BreakpointPropertiesPanel.concatWithEx(excludeFilters, " ", width, "\n");
        this.myClassFiltersField.getTextField().setToolTipText(tipText);
    }

    private void reloadClassFilters() {
        String filtersText = this.myClassFiltersField.getText();
        ArrayList<com.intellij.ui.classFilter.ClassFilter> classFilters = new ArrayList<com.intellij.ui.classFilter.ClassFilter>();
        ArrayList<com.intellij.ui.classFilter.ClassFilter> exclusionFilters = new ArrayList<com.intellij.ui.classFilter.ClassFilter>();
        int startFilter = -1;
        for (int i = 0; i <= filtersText.length(); ++i) {
            if (i < filtersText.length() && !Character.isWhitespace(filtersText.charAt(i))) {
                if (startFilter != -1) continue;
                startFilter = i;
                continue;
            }
            if (startFilter < 0) continue;
            if (filtersText.charAt(startFilter) == '-') {
                exclusionFilters.add(new com.intellij.ui.classFilter.ClassFilter(filtersText.substring(startFilter + 1, i)));
            } else {
                classFilters.add(new com.intellij.ui.classFilter.ClassFilter(filtersText.substring(startFilter, i)));
            }
            startFilter = -1;
        }
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassFilters) {
            if (classFilter.isEnabled()) continue;
            classFilters.add(classFilter);
        }
        for (com.intellij.ui.classFilter.ClassFilter classFilter : this.myClassExclusionFilters) {
            if (classFilter.isEnabled()) continue;
            exclusionFilters.add(classFilter);
        }
        this.myClassFilters = classFilters.toArray(new com.intellij.ui.classFilter.ClassFilter[classFilters.size()]);
        this.myClassExclusionFilters = exclusionFilters.toArray(new com.intellij.ui.classFilter.ClassFilter[exclusionFilters.size()]);
    }

    public void setEnabled(boolean enabled) {
        Component[] components;
        this.myPanel.setEnabled(enabled);
        for (Component component : components = this.myPanel.getComponents()) {
            component.setEnabled(enabled);
        }
    }

    protected void updateCheckboxes() {
        boolean passCountApplicable = true;
        if (this.myInstanceFiltersCheckBox.isSelected() || this.myClassFiltersCheckBox.isSelected()) {
            passCountApplicable = false;
        }
        this.myPassCountCheckbox.setEnabled(passCountApplicable);
        boolean passCountSelected = this.myPassCountCheckbox.isSelected();
        this.myInstanceFiltersCheckBox.setEnabled(!passCountSelected);
        this.myClassFiltersCheckBox.setEnabled(!passCountSelected);
        this.myPassCountField.setEditable(this.myPassCountCheckbox.isSelected());
        this.myPassCountField.setEnabled(this.myPassCountCheckbox.isSelected());
        this.myConditionCombo.setEnabled(this.myConditionCheckbox.isSelected());
        this.myConditionMagnifierButton.setEnabled(this.myConditionCheckbox.isSelected());
        this.myInstanceFiltersField.setEnabled(this.myInstanceFiltersCheckBox.isSelected());
        this.myInstanceFiltersField.getTextField().setEditable(this.myInstanceFiltersCheckBox.isSelected());
        this.myClassFiltersField.setEnabled(this.myClassFiltersCheckBox.isSelected());
        this.myClassFiltersField.getTextField().setEditable(this.myClassFiltersCheckBox.isSelected());
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private static BreakpointManager getBreakpointManager(Project project) {
        return DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
    }

    static /* synthetic */ InstanceFilter[] access$1502(BreakpointPropertiesPanel x0, InstanceFilter[] x1) {
        x0.myInstanceFilters = x1;
        return x1;
    }

    static /* synthetic */ com.intellij.ui.classFilter.ClassFilter[] access$1602(BreakpointPropertiesPanel x0, com.intellij.ui.classFilter.ClassFilter[] x1) {
        x0.myClassFilters = x1;
        return x1;
    }

    static /* synthetic */ com.intellij.ui.classFilter.ClassFilter[] access$1702(BreakpointPropertiesPanel x0, com.intellij.ui.classFilter.ClassFilter[] x1) {
        x0.myClassExclusionFilters = x1;
        return x1;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox3;
        JPanel jPanel3;
        JPanel jPanel4;
        JCheckBox jCheckBox4;
        JPanel jPanel5;
        JPanel jPanel6;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JLabel jLabel;
        JPanel jPanel7;
        JPanel jPanel8;
        JPanel jPanel9;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JPanel jPanel10;
        JCheckBox jCheckBox7;
        JPanel jPanel11;
        JCheckBox jCheckBox8;
        JButton jButton;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JCheckBox jCheckBox9;
        JPanel jPanel12;
        JPanel jPanel13;
        this.myPanel = jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel14, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myConditionComboPanel = jPanel12 = new JPanel();
        jPanel14.add((Component)jPanel12, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myConditionCheckbox = jCheckBox9 = new JCheckBox();
        jCheckBox9.setText("Condition");
        jCheckBox9.setMnemonic('C');
        jCheckBox9.setDisplayedMnemonicIndex(0);
        jPanel14.add((Component)jCheckBox9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel13.add((Component)jPanel15, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myRbSuspendThread = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.suspend.thread"));
        jPanel15.add((Component)jRadioButton4, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRbSuspendAll = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.suspend.all"));
        jPanel15.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel15.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myMakeDefaultButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.suspend.default"));
        jPanel15.add((Component)jButton, new GridConstraints(0, 4, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCbSuspend = jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("Suspend");
        jCheckBox8.setMnemonic('S');
        jCheckBox8.setDisplayedMnemonicIndex(0);
        jPanel15.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel16, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel16.add((Component)jPanel17, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(245, 251), null));
        this.myActionsPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 5), -1, -1, false, false));
        jPanel11.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel17.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel11.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.breakpoint.properties.panel.group.actions"), (int)0, (int)0, null, null));
        this.myLogMessageCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.log.message"));
        jPanel11.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel18, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel18.add((Component)jPanel19, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel19.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myLogExpressionComboPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel19.add((Component)jPanel10, new GridConstraints(0, 1, 1, 1, 1, 1, 7, 0, null, null, null));
        this.myLogExpressionCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.log.expression"));
        jPanel18.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myTemporaryCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Remove once hit");
        jCheckBox5.setMnemonic('R');
        jCheckBox5.setDisplayedMnemonicIndex(0);
        jPanel11.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySpecialBoxPanel = jPanel9 = new JPanel();
        ((Component)jPanel9).setVisible(true);
        jPanel17.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDependsOnPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "");
        jPanel17.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 5), -1, -1, false, false));
        jPanel8.add((Component)jPanel20, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDependentBreakpointComboPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 15, 0, 0), -1, -1, false, false));
        jPanel20.add((Component)jPanel7, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 0, null, null, null));
        this.myEnableOrDisableLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.dependency.type.lable"));
        jPanel20.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDisableAgainRadio = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.depends.disable.again"));
        jPanel20.add((Component)jRadioButton2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLeaveEnabledRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.depends.leave.enabled"));
        jPanel20.add((Component)jRadioButton, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoint.master.breakpoint.description"));
        jPanel20.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConditionsPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(2, 2, 5, 5), -1, 7, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel16.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.breakpoint.properties.panel.group.conditions"), (int)0, (int)0, null, null));
        this.myInstanceFiltersPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myInstanceFiltersCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.instance.filters"));
        jPanel5.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel21, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel21.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myInstanceFiltersFieldPanel = jPanel4 = new JPanel();
        jPanel21.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myClassFiltersPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myClassFiltersCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.class.filters"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel22, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myClassFiltersFieldPanel = jPanel2 = new JPanel();
        jPanel22.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel22.add((Component)spacer4, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myPassCountPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        this.myPassCountCheckbox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.pass.count"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel23 = new JPanel();
        jPanel23.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel23, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPassCountField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(true);
        jTextField.setHorizontalAlignment(10);
        jPanel23.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(15, -1), null));
        Spacer spacer5 = new Spacer();
        jPanel23.add((Component)spacer5, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        Spacer spacer6 = new Spacer();
        jPanel6.add((Component)spacer6, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel24 = new JPanel();
        jPanel24.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel24, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEnabledCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enabled");
        Font font = jCheckBox.getFont();
        jCheckBox.setFont(new Font(font.getName(), 1, 11));
        jPanel24.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MagnifierButtonAction
    implements ActionListener {
        private final Project myProject;
        private final CompletionEditor myTargetEditor;
        private final String myDialogTitle;
        private DebuggerStatementEditor myEditor;

        private MagnifierButtonAction(Project project, CompletionEditor targetEditor, String dialogTitle) {
            this.myProject = project;
            this.myTargetEditor = targetEditor;
            this.myDialogTitle = dialogTitle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new DialogWrapper(this.myTargetEditor, true){

                public void show() {
                    this.setTitle(MagnifierButtonAction.this.myDialogTitle);
                    this.setModal(true);
                    this.init();
                    super.show();
                }

                public JComponent getPreferredFocusedComponent() {
                    return MagnifierButtonAction.this.myEditor;
                }

                @Nullable
                protected JComponent createCenterPanel() {
                    JPanel panel = new JPanel(new BorderLayout());
                    MagnifierButtonAction.this.myEditor = new DebuggerStatementEditor(MagnifierButtonAction.this.myProject, MagnifierButtonAction.this.myTargetEditor.getContext(), MagnifierButtonAction.this.myTargetEditor.getRecentsId(), DefaultCodeFragmentFactory.getInstance());
                    MagnifierButtonAction.this.myEditor.setPreferredSize(new Dimension(400, 150));
                    MagnifierButtonAction.this.myEditor.setText(MagnifierButtonAction.this.myTargetEditor.getText());
                    panel.add((Component)MagnifierButtonAction.this.myEditor, "Center");
                    return panel;
                }

                protected void dispose() {
                    super.dispose();
                    MagnifierButtonAction.this.myEditor.dispose();
                }

                protected void doOKAction() {
                    MagnifierButtonAction.this.myTargetEditor.setText(MagnifierButtonAction.this.myEditor.getText());
                    super.doOKAction();
                }
            }.show();
        }
    }

    private class MyTextField
    extends JTextField {
        @Override
        public String getToolTipText(MouseEvent event) {
            BreakpointPropertiesPanel.this.reloadClassFilters();
            BreakpointPropertiesPanel.this.updateClassFilterEditor(false);
            BreakpointPropertiesPanel.this.reloadInstanceFilters();
            BreakpointPropertiesPanel.this.updateInstanceFilterEditor(false);
            String toolTipText = super.getToolTipText(event);
            return this.getToolTipText().length() == 0 ? null : toolTipText;
        }

        @Override
        public JToolTip createToolTip() {
            JToolTip toolTip = new JToolTip(){
                {
                    this.setUI((ComponentUI)new MultiLineTooltipUI());
                }
            };
            toolTip.setComponent(this);
            return toolTip;
        }
    }

    public static interface Delegate {
        public void showActionsPanel();
    }
}

