/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.actions.EvaluateActionHandler;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.DebuggerEditorImpl;
import com.intellij.debugger.ui.DebuggerStatementEditor;
import com.intellij.debugger.ui.EvaluationDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.DimensionService;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StatementEvaluationDialog
extends EvaluationDialog {
    private final JPanel myPanel;
    private final Action mySwitchAction = new SwitchAction();
    @NonNls
    private static final String STATEMENT_EDITOR_DIMENSION_KEY = "#com.intellij.debugger.ui.StatementEvaluationDialog.StatementEditor";
    @NonNls
    private static final String EVALUATION_PANEL_DIMENSION_KEY = "#com.intellij.debugger.ui.StatementEvaluationDialog.EvaluationPanel";

    public StatementEvaluationDialog(Project project, TextWithImports text) {
        super(project, text);
        this.setTitle(DebuggerBundle.message((String)"evaluate.statement.dialog.title", (Object[])new Object[0]));
        this.myPanel = new JPanel(new BorderLayout());
        Splitter splitter = new Splitter(true);
        splitter.setHonorComponentsMinimumSize(true);
        JPanel editorPanel = new JPanel(new GridBagLayout());
        JLabel statementsLabel = new JLabel(DebuggerBundle.message((String)"label.evaluation.dialog.statements", (Object[])new Object[0]));
        editorPanel.add((Component)statementsLabel, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        editorPanel.add((Component)this.getStatementEditor(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        splitter.setFirstComponent((JComponent)editorPanel);
        EvaluationDialog.MyEvaluationPanel evaluationPanel = this.getEvaluationPanel();
        JPanel ep = new JPanel(new BorderLayout());
        ep.add((Component)evaluationPanel, "Center");
        splitter.setSecondComponent((JComponent)ep);
        Dimension statementSize = DimensionService.getInstance().getSize(STATEMENT_EDITOR_DIMENSION_KEY, project);
        Dimension evaluationSize = DimensionService.getInstance().getSize(EVALUATION_PANEL_DIMENSION_KEY, project);
        if (statementSize != null && evaluationSize != null) {
            float proportion = (float)statementSize.height / (float)(statementSize.height + evaluationSize.height);
            splitter.setProportion(proportion);
        }
        this.myPanel.add((Component)splitter, "Center");
        this.setDebuggerContext(this.getDebuggerContext());
        KeyStroke codeFragment = KeyStroke.getKeyStroke(69, 8);
        KeyStroke resultStroke = KeyStroke.getKeyStroke(82, 8);
        KeyStroke altEnter = KeyStroke.getKeyStroke(10, 2);
        final JRootPane rootPane = this.getRootPane();
        final AnAction toStatementAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                StatementEvaluationDialog.this.getStatementEditor().requestFocus();
            }
        };
        toStatementAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(codeFragment), (JComponent)rootPane);
        this.addDisposeRunnable(new Runnable(){

            @Override
            public void run() {
                toStatementAction.unregisterCustomShortcutSet((JComponent)rootPane);
            }
        });
        final AnAction toEvaluationAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                StatementEvaluationDialog.this.getEvaluationPanel().getWatchTree().requestFocus();
            }
        };
        toEvaluationAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(resultStroke), (JComponent)rootPane);
        this.addDisposeRunnable(new Runnable(){

            @Override
            public void run() {
                toEvaluationAction.unregisterCustomShortcutSet((JComponent)rootPane);
            }
        });
        final AnAction okAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                StatementEvaluationDialog.this.doOKAction();
            }
        };
        okAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(altEnter), (JComponent)rootPane);
        this.addDisposeRunnable(new Runnable(){

            @Override
            public void run() {
                okAction.unregisterCustomShortcutSet((JComponent)rootPane);
            }
        });
        final DebuggerEditorImpl editor = this.getEditor();
        final DocumentAdapter docListener = new DocumentAdapter(){

            public void documentChanged(final DocumentEvent e) {
                DebuggerInvocationUtil.invokeLater(StatementEvaluationDialog.this.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        StatementEvaluationDialog.this.updateSwitchButton(e.getDocument());
                    }
                });
            }
        };
        editor.addDocumentListener((DocumentListener)docListener);
        this.addDisposeRunnable(new Runnable(){

            @Override
            public void run() {
                editor.removeDocumentListener((DocumentListener)docListener);
            }
        });
        this.init();
    }

    private void updateSwitchButton(Document document) {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        PsiElement[] children = psiFile.getChildren();
        int nonWhite = 0;
        for (PsiElement child : children) {
            if (child instanceof PsiWhiteSpace || ++nonWhite <= 1) continue;
            this.mySwitchAction.setEnabled(false);
            return;
        }
        this.mySwitchAction.setEnabled(true);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.mySwitchAction, this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/StatementEvaluationDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("debugging.debugMenu.evaluate");
    }

    @Override
    protected DebuggerEditorImpl createEditor(CodeFragmentFactory factory) {
        return new DebuggerStatementEditor(this.getProject(), PositionUtil.getContextElement((StackFrameContext)this.getDebuggerContext()), "evaluation", factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            DebuggerEditorImpl editor = this.getEditor();
            DimensionService dimensionService = DimensionService.getInstance();
            dimensionService.setSize(STATEMENT_EDITOR_DIMENSION_KEY, editor.getSize(null), this.getProject());
            dimensionService.setSize(EVALUATION_PANEL_DIMENSION_KEY, this.getEvaluationPanel().getSize(), this.getProject());
        }
        finally {
            super.dispose();
        }
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private DebuggerStatementEditor getStatementEditor() {
        return (DebuggerStatementEditor)this.getEditor();
    }

    private class SwitchAction
    extends AbstractAction {
        public SwitchAction() {
            this.putValue("Name", DebuggerBundle.message((String)"action.evaluate.statement.dialog.switch.mode.description", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final TextWithImports text = StatementEvaluationDialog.this.getEditor().getText();
            StatementEvaluationDialog.this.doCancelAction();
            DebuggerInvocationUtil.invokeLater(StatementEvaluationDialog.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    EvaluateActionHandler.showEvaluationDialog(StatementEvaluationDialog.this.getProject(), text, "EvaluateExpression");
                }
            });
        }
    }
}

