/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.WildcardMethodBreakpoint;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.impl.actions.ViewBreakpointsAction;
import com.intellij.xdebugger.ui.DebuggerColors;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PositionHighlighter {
    private static final Key<Boolean> HIGHLIGHTER_USERDATA_KEY = new Key("HIGHLIGHTER_USERDATA_KEY");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.PositionHighlighter");
    private final Project myProject;
    private DebuggerContextImpl myContext = DebuggerContextImpl.EMPTY_CONTEXT;
    private SelectionDescription mySelectionDescription = null;
    private ExecutionPointDescription myExecutionPointDescription = null;

    public PositionHighlighter(Project project, DebuggerStateManager stateManager) {
        this.myProject = project;
        stateManager.addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(DebuggerContextImpl newContext, int event) {
                PositionHighlighter.this.myContext = newContext;
                if (event != 11 && event != 12) {
                    PositionHighlighter.this.refresh();
                }
            }
        });
    }

    private void showLocationInEditor() {
        this.myContext.getDebugProcess().getManagerThread().schedule(new ShowLocationCommand(this.myContext));
    }

    private void refresh() {
        this.clearSelections();
        DebuggerSession session = this.myContext.getDebuggerSession();
        if (session != null) {
            switch (session.getState()) {
                case 3: {
                    if (this.myContext.getFrameProxy() == null) break;
                    this.showLocationInEditor();
                    return;
                }
            }
        }
    }

    private void showSelection(SourcePosition position) {
        Editor editor = this.getEditor(position);
        if (editor == null) {
            return;
        }
        if (this.mySelectionDescription != null) {
            this.mySelectionDescription.remove();
        }
        this.mySelectionDescription = SelectionDescription.createSelection(editor, position.getLine());
        this.mySelectionDescription.select();
    }

    private void showExecutionPoint(SourcePosition position, List<Pair<Breakpoint, Event>> events) {
        if (this.myExecutionPointDescription != null) {
            this.myExecutionPointDescription.remove();
        }
        int lineIndex = position.getLine();
        Editor editor = this.getEditor(position);
        if (editor == null) {
            return;
        }
        this.myExecutionPointDescription = SelectionDescription.createExecutionPoint(editor, lineIndex);
        this.myExecutionPointDescription.select();
        RangeHighlighter highlighter = this.myExecutionPointDescription.getHighlighter();
        if (highlighter != null) {
            ArrayList<Pair<Breakpoint, Event>> eventsOutOfLine = new ArrayList<Pair<Breakpoint, Event>>();
            for (Pair<Breakpoint, Event> eventDescriptor : events) {
                Breakpoint breakpoint;
                block10: {
                    breakpoint = (Breakpoint)eventDescriptor.getFirst();
                    if (breakpoint instanceof MethodBreakpoint) {
                        try {
                            if (!((MethodBreakpoint)breakpoint).matchesEvent((LocatableEvent)eventDescriptor.getSecond(), this.myContext.getDebugProcess())) {
                                continue;
                            }
                            break block10;
                        }
                        catch (EvaluateException ignored) {
                            break block10;
                        }
                    }
                    if (breakpoint instanceof WildcardMethodBreakpoint && !((WildcardMethodBreakpoint)breakpoint).matchesEvent((LocatableEvent)eventDescriptor.getSecond())) continue;
                }
                if (breakpoint instanceof BreakpointWithHighlighter) {
                    if (!((BreakpointWithHighlighter)breakpoint).isVisible() || !breakpoint.isValid()) continue;
                    breakpoint.reload();
                    SourcePosition sourcePosition = ((BreakpointWithHighlighter)breakpoint).getSourcePosition();
                    if (sourcePosition != null && sourcePosition.getLine() == lineIndex) continue;
                    eventsOutOfLine.add(eventDescriptor);
                    continue;
                }
                eventsOutOfLine.add(eventDescriptor);
            }
            if (!eventsOutOfLine.isEmpty()) {
                highlighter.setGutterIconRenderer((GutterIconRenderer)new MyGutterIconRenderer(eventsOutOfLine));
            }
        }
    }

    private Editor getEditor(SourcePosition position) {
        PsiFile psiFile = position.getFile();
        Document doc = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
        if (!psiFile.isValid()) {
            return null;
        }
        int lineIndex = position.getLine();
        if (lineIndex < 0 || lineIndex > doc.getLineCount()) {
            return null;
        }
        return position.openEditor(false);
    }

    private void clearSelections() {
        if (this.mySelectionDescription != null || this.myExecutionPointDescription != null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (PositionHighlighter.this.mySelectionDescription != null) {
                        PositionHighlighter.this.mySelectionDescription.remove();
                        PositionHighlighter.this.mySelectionDescription = null;
                    }
                    if (PositionHighlighter.this.myExecutionPointDescription != null) {
                        PositionHighlighter.this.myExecutionPointDescription.remove();
                        PositionHighlighter.this.myExecutionPointDescription = null;
                    }
                }
            });
        }
    }

    public void updateContextPointDescription() {
        if (this.myContext.getDebuggerSession() == null) {
            return;
        }
        this.showLocationInEditor();
    }

    private class MyGutterIconRenderer
    extends GutterIconRenderer {
        private final List<Pair<Breakpoint, Event>> myEventsOutOfLine;

        public MyGutterIconRenderer(List<Pair<Breakpoint, Event>> eventsOutOfLine) {
            this.myEventsOutOfLine = eventsOutOfLine;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = ((Breakpoint)this.myEventsOutOfLine.get(0).getFirst()).getIcon();
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/PositionHighlighter$MyGutterIconRenderer", "getIcon"));
            }
            return icon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getTooltipText() {
            DebugProcessImpl debugProcess = PositionHighlighter.this.myContext.getDebugProcess();
            if (debugProcess == null) {
                return null;
            }
            StringBuilder buf = StringBuilderSpinAllocator.alloc();
            try {
                buf.append("<html><body>");
                Iterator<Pair<Breakpoint, Event>> iterator = this.myEventsOutOfLine.iterator();
                while (iterator.hasNext()) {
                    Pair<Breakpoint, Event> eventDescriptor = iterator.next();
                    buf.append(((DebugProcessEvents)debugProcess).getEventText(eventDescriptor));
                    if (!iterator.hasNext()) continue;
                    buf.append("<br>");
                }
                buf.append("</body></html>");
                String string = buf.toString();
                return string;
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)buf);
            }
        }

        public ActionGroup getPopupMenuActions() {
            DefaultActionGroup group = new DefaultActionGroup();
            for (Pair<Breakpoint, Event> eventDescriptor : this.myEventsOutOfLine) {
                Breakpoint breakpoint = (Breakpoint)eventDescriptor.getFirst();
                ViewBreakpointsAction viewBreakpointsAction = new ViewBreakpointsAction(breakpoint.getDisplayName(), breakpoint);
                group.add((AnAction)viewBreakpointsAction);
            }
            return group;
        }

        public AnAction getMiddleButtonClickAction() {
            return new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    if (MyGutterIconRenderer.this.myEventsOutOfLine.size() == 1) {
                        Breakpoint breakpoint;
                        breakpoint.setEnabled(!(breakpoint = (Breakpoint)((Pair)MyGutterIconRenderer.this.myEventsOutOfLine.get(0)).getFirst()).isEnabled());
                        DebuggerManagerEx.getInstanceEx(PositionHighlighter.this.myProject).getBreakpointManager().fireBreakpointChanged(breakpoint);
                    }
                }
            };
        }

        public boolean equals(Object obj) {
            return obj instanceof MyGutterIconRenderer && Comparing.equal((String)this.getTooltipText(), (String)((MyGutterIconRenderer)((Object)obj)).getTooltipText()) && Comparing.equal((Object)this.getIcon(), (Object)((MyGutterIconRenderer)((Object)obj)).getIcon());
        }

        public int hashCode() {
            return this.getIcon().hashCode();
        }
    }

    private class ShowLocationCommand
    extends DebuggerContextCommandImpl {
        private final DebuggerContextImpl myContext;

        public ShowLocationCommand(DebuggerContextImpl context) {
            super(context);
            this.myContext = context;
        }

        @Override
        public void threadAction() {
            final SourcePosition contextPosition = this.myContext.getSourcePosition();
            if (contextPosition == null) {
                return;
            }
            boolean isExecutionPoint = false;
            try {
                StackFrameProxyImpl frameProxy = this.myContext.getFrameProxy();
                ThreadReferenceProxyImpl thread = this.getSuspendContext().getThread();
                isExecutionPoint = thread != null && frameProxy != null && frameProxy.equals(thread.frame(0));
            }
            catch (Throwable th) {
                LOG.debug(th);
            }
            final List<Pair<Breakpoint, Event>> events = DebuggerUtilsEx.getEventDescriptors(this.getSuspendContext());
            final SourcePosition position = (SourcePosition)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SourcePosition>(){

                public SourcePosition compute() {
                    Document document = PsiDocumentManager.getInstance((Project)PositionHighlighter.this.myProject).getDocument(contextPosition.getFile());
                    if (document != null && (contextPosition.getLine() < 0 || contextPosition.getLine() >= document.getLineCount())) {
                        return SourcePosition.createFromLine((PsiFile)contextPosition.getFile(), (int)0);
                    }
                    return contextPosition;
                }
            });
            if (isExecutionPoint) {
                DebuggerInvocationUtil.swingInvokeLater(PositionHighlighter.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        SourcePosition highlightPosition = ShowLocationCommand.this.getHighlightPosition(events, position);
                        PositionHighlighter.this.showExecutionPoint(highlightPosition, events);
                    }
                });
            } else {
                DebuggerInvocationUtil.swingInvokeLater(PositionHighlighter.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        PositionHighlighter.this.showSelection(position);
                    }
                });
            }
        }

        private SourcePosition getHighlightPosition(List<Pair<Breakpoint, Event>> events, SourcePosition position) {
            for (Pair<Breakpoint, Event> eventDescriptor : events) {
                Breakpoint breakpoint = (Breakpoint)eventDescriptor.getFirst();
                if (breakpoint instanceof LineBreakpoint) {
                    breakpoint.reload();
                    SourcePosition breakPosition = ((BreakpointWithHighlighter)breakpoint).getSourcePosition();
                    if (breakPosition == null || breakPosition.getLine() == position.getLine()) continue;
                    position = SourcePosition.createFromLine((PsiFile)position.getFile(), (int)breakPosition.getLine());
                    continue;
                }
                if (!(breakpoint instanceof MethodBreakpoint)) continue;
                MethodBreakpoint methodBreakpoint = (MethodBreakpoint)breakpoint;
                methodBreakpoint.reload();
                SourcePosition breakPosition = methodBreakpoint.getSourcePosition();
                LocatableEvent event = (LocatableEvent)eventDescriptor.getSecond();
                if (breakPosition == null || !breakPosition.getFile().equals(position.getFile()) || breakPosition.getLine() == position.getLine() || !(event instanceof MethodEntryEvent)) continue;
                try {
                    if (!methodBreakpoint.matchesEvent(event, this.myContext.getDebugProcess())) continue;
                    position = SourcePosition.createFromLine((PsiFile)position.getFile(), (int)breakPosition.getLine());
                }
                catch (EvaluateException ignored) {}
            }
            return position;
        }
    }

    protected static abstract class SelectionDescription {
        protected Editor myEditor;
        protected boolean myIsActive;

        public SelectionDescription(Editor editor) {
            this.myEditor = editor;
        }

        public abstract void select();

        public abstract void remove();

        public static ExecutionPointDescription createExecutionPoint(Editor editor, int lineIndex) {
            return new ExecutionPointDescription(editor, lineIndex);
        }

        public static SelectionDescription createSelection(final Editor editor, final int lineIndex) {
            return new SelectionDescription(editor){

                @Override
                public void select() {
                    if (this.myIsActive) {
                        return;
                    }
                    this.myIsActive = true;
                    DocumentEx doc = (DocumentEx)editor.getDocument();
                    editor.getSelectionModel().setSelection(doc.getLineStartOffset(lineIndex), doc.getLineEndOffset(lineIndex) + doc.getLineSeparatorLength(lineIndex));
                }

                @Override
                public void remove() {
                    if (!this.myIsActive) {
                        return;
                    }
                    this.myIsActive = false;
                    this.myEditor.getSelectionModel().removeSelection();
                }
            };
        }
    }

    protected static class ExecutionPointDescription
    extends SelectionDescription {
        private RangeHighlighter myHighlighter;
        private final int myLineIndex;

        protected ExecutionPointDescription(Editor editor, int lineIndex) {
            super(editor);
            this.myLineIndex = lineIndex;
        }

        @Override
        public void select() {
            if (this.myIsActive) {
                return;
            }
            this.myIsActive = true;
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.myHighlighter = this.myEditor.getMarkupModel().addLineHighlighter(this.myLineIndex, 5999, scheme.getAttributes(DebuggerColors.EXECUTIONPOINT_ATTRIBUTES));
            ExecutionPointDescription.adjustCounter(this.myEditor, 1);
            this.myHighlighter.setErrorStripeTooltip((Object)DebuggerBundle.message((String)"position.highlighter.stripe.tooltip", (Object[])new Object[0]));
            this.myHighlighter.putUserData(HIGHLIGHTER_USERDATA_KEY, (Object)Boolean.TRUE);
        }

        private static void adjustCounter(@NotNull Editor editor, int increment) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/PositionHighlighter$ExecutionPointDescription", "adjustCounter"));
            }
            JComponent component = editor.getComponent();
            Object o = component.getClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING);
            Integer value = (o instanceof Integer ? (Integer)o : 0) + increment;
            component.putClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING, value > 0 ? value : null);
        }

        @Override
        public void remove() {
            if (!this.myIsActive) {
                return;
            }
            this.myIsActive = false;
            ExecutionPointDescription.adjustCounter(this.myEditor, -1);
            if (this.myHighlighter != null) {
                this.myHighlighter.dispose();
                this.myHighlighter = null;
            }
        }

        public RangeHighlighter getHighlighter() {
            return this.myHighlighter;
        }
    }
}

