/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.AddToWatchActionHandler;
import com.intellij.debugger.actions.EvaluateActionHandler;
import com.intellij.debugger.actions.ForceRunToCursorActionHandler;
import com.intellij.debugger.actions.ForceStepIntoActionHandler;
import com.intellij.debugger.actions.ForceStepOverActionHandler;
import com.intellij.debugger.actions.JavaMarkObjectActionHandler;
import com.intellij.debugger.actions.JvmSmartStepIntoActionHandler;
import com.intellij.debugger.actions.MuteBreakpointsActionHandler;
import com.intellij.debugger.actions.PauseActionHandler;
import com.intellij.debugger.actions.QuickEvaluateActionHandler;
import com.intellij.debugger.actions.ResumeActionHandler;
import com.intellij.debugger.actions.RunToCursorActionHandler;
import com.intellij.debugger.actions.ShowExecutionPointActionHandler;
import com.intellij.debugger.actions.StepIntoActionHandler;
import com.intellij.debugger.actions.StepOutActionHandler;
import com.intellij.debugger.actions.StepOverActionHandler;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.DebuggerDataViewsConfigurable;
import com.intellij.debugger.settings.DebuggerHotswapConfigurable;
import com.intellij.debugger.settings.DebuggerLaunchingConfigurable;
import com.intellij.debugger.settings.DebuggerSteppingConfigurable;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.UserRenderersConfigurable;
import com.intellij.debugger.ui.XBreakpointGroupingByClassRule;
import com.intellij.debugger.ui.XBreakpointGroupingByPackageRule;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.DebuggerToggleActionHandler;
import com.intellij.xdebugger.impl.actions.EditBreakpointActionHandler;
import com.intellij.xdebugger.impl.actions.MarkObjectActionHandler;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.settings.DebuggerSettingsPanelProvider;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JavaDebuggerSupport
extends DebuggerSupport {
    private final JavaBreakpointPanelProvider myBreakpointPanelProvider = new JavaBreakpointPanelProvider();
    private final StepOverActionHandler myStepOverActionHandler = new StepOverActionHandler();
    private final StepIntoActionHandler myStepIntoActionHandler = new StepIntoActionHandler();
    private final StepOutActionHandler myStepOutActionHandler = new StepOutActionHandler();
    private final ForceStepOverActionHandler myForceStepOverActionHandler = new ForceStepOverActionHandler();
    private final ForceStepIntoActionHandler myForceStepIntoActionHandler = new ForceStepIntoActionHandler();
    private final RunToCursorActionHandler myRunToCursorActionHandler = new RunToCursorActionHandler();
    private final ForceRunToCursorActionHandler myForceRunToCursorActionHandler = new ForceRunToCursorActionHandler();
    private final ResumeActionHandler myResumeActionHandler = new ResumeActionHandler();
    private final PauseActionHandler myPauseActionHandler = new PauseActionHandler();
    private final ShowExecutionPointActionHandler myShowExecutionPointActionHandler = new ShowExecutionPointActionHandler();
    private final EvaluateActionHandler myEvaluateActionHandler = new EvaluateActionHandler();
    private final QuickEvaluateActionHandler myQuickEvaluateHandler = new QuickEvaluateActionHandler();
    private final JavaDebuggerSettingsPanelProvider myDebuggerSettingsPanelProvider = new JavaDebuggerSettingsPanelProvider();
    private final MuteBreakpointsActionHandler myMuteBreakpointsHandler = new MuteBreakpointsActionHandler();
    private final DebuggerActionHandler mySmartStepIntoHandler = new JvmSmartStepIntoActionHandler();
    private final DebuggerActionHandler myAddToWatchedActionHandler = new AddToWatchActionHandler();
    private final JavaMarkObjectActionHandler myMarkObjectActionHandler = new JavaMarkObjectActionHandler();
    private static final DebuggerActionHandler DISABLED = new DebuggerActionHandler(){

        @Override
        public void perform(@NotNull Project project, AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/JavaDebuggerSupport$1", "perform"));
            }
        }

        @Override
        public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/JavaDebuggerSupport$1", "isEnabled"));
            }
            return false;
        }
    };
    private static final EditBreakpointActionHandler X_EDIT = new EditBreakpointActionHandler(){

        @Override
        protected void doShowPopup(Project project, JComponent component, Point whereToShow, Object breakpoint) {
            DebuggerUIUtil.showXBreakpointEditorBalloon(project, whereToShow, component, false, (XBreakpoint)breakpoint);
        }

        @Override
        public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/JavaDebuggerSupport$2", "isEnabled"));
            }
            return false;
        }
    };

    @Override
    @NotNull
    public BreakpointPanelProvider<?> getBreakpointPanelProvider() {
        JavaBreakpointPanelProvider javaBreakpointPanelProvider = this.myBreakpointPanelProvider;
        if (javaBreakpointPanelProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getBreakpointPanelProvider"));
        }
        return javaBreakpointPanelProvider;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepOverHandler() {
        StepOverActionHandler stepOverActionHandler = this.myStepOverActionHandler;
        if (stepOverActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getStepOverHandler"));
        }
        return stepOverActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepIntoHandler() {
        StepIntoActionHandler stepIntoActionHandler = this.myStepIntoActionHandler;
        if (stepIntoActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getStepIntoHandler"));
        }
        return stepIntoActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getSmartStepIntoHandler() {
        DebuggerActionHandler debuggerActionHandler = this.mySmartStepIntoHandler;
        if (debuggerActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getSmartStepIntoHandler"));
        }
        return debuggerActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepOutHandler() {
        StepOutActionHandler stepOutActionHandler = this.myStepOutActionHandler;
        if (stepOutActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getStepOutHandler"));
        }
        return stepOutActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceStepOverHandler() {
        ForceStepOverActionHandler forceStepOverActionHandler = this.myForceStepOverActionHandler;
        if (forceStepOverActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getForceStepOverHandler"));
        }
        return forceStepOverActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceStepIntoHandler() {
        ForceStepIntoActionHandler forceStepIntoActionHandler = this.myForceStepIntoActionHandler;
        if (forceStepIntoActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getForceStepIntoHandler"));
        }
        return forceStepIntoActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getRunToCursorHandler() {
        RunToCursorActionHandler runToCursorActionHandler = this.myRunToCursorActionHandler;
        if (runToCursorActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getRunToCursorHandler"));
        }
        return runToCursorActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceRunToCursorHandler() {
        ForceRunToCursorActionHandler forceRunToCursorActionHandler = this.myForceRunToCursorActionHandler;
        if (forceRunToCursorActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getForceRunToCursorHandler"));
        }
        return forceRunToCursorActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getResumeActionHandler() {
        ResumeActionHandler resumeActionHandler = this.myResumeActionHandler;
        if (resumeActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getResumeActionHandler"));
        }
        return resumeActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getPauseHandler() {
        PauseActionHandler pauseActionHandler = this.myPauseActionHandler;
        if (pauseActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getPauseHandler"));
        }
        return pauseActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getToggleLineBreakpointHandler() {
        DebuggerActionHandler debuggerActionHandler = DISABLED;
        if (debuggerActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getToggleLineBreakpointHandler"));
        }
        return debuggerActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getToggleTemporaryLineBreakpointHandler() {
        DebuggerActionHandler debuggerActionHandler = DISABLED;
        if (debuggerActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getToggleTemporaryLineBreakpointHandler"));
        }
        return debuggerActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getShowExecutionPointHandler() {
        ShowExecutionPointActionHandler showExecutionPointActionHandler = this.myShowExecutionPointActionHandler;
        if (showExecutionPointActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getShowExecutionPointHandler"));
        }
        return showExecutionPointActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getEvaluateHandler() {
        EvaluateActionHandler evaluateActionHandler = this.myEvaluateActionHandler;
        if (evaluateActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getEvaluateHandler"));
        }
        return evaluateActionHandler;
    }

    @Override
    @NotNull
    public QuickEvaluateHandler getQuickEvaluateHandler() {
        QuickEvaluateActionHandler quickEvaluateActionHandler = this.myQuickEvaluateHandler;
        if (quickEvaluateActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getQuickEvaluateHandler"));
        }
        return quickEvaluateActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getAddToWatchesActionHandler() {
        DebuggerActionHandler debuggerActionHandler = this.myAddToWatchedActionHandler;
        if (debuggerActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getAddToWatchesActionHandler"));
        }
        return debuggerActionHandler;
    }

    @Override
    @NotNull
    public DebuggerToggleActionHandler getMuteBreakpointsHandler() {
        MuteBreakpointsActionHandler muteBreakpointsActionHandler = this.myMuteBreakpointsHandler;
        if (muteBreakpointsActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getMuteBreakpointsHandler"));
        }
        return muteBreakpointsActionHandler;
    }

    @Override
    @NotNull
    public MarkObjectActionHandler getMarkObjectHandler() {
        JavaMarkObjectActionHandler javaMarkObjectActionHandler = this.myMarkObjectActionHandler;
        if (javaMarkObjectActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getMarkObjectHandler"));
        }
        return javaMarkObjectActionHandler;
    }

    @Override
    public AbstractDebuggerSession getCurrentSession(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/JavaDebuggerSupport", "getCurrentSession"));
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project).getContext();
        return context != null ? context.getDebuggerSession() : null;
    }

    @Override
    @NotNull
    public EditBreakpointActionHandler getEditBreakpointAction() {
        EditBreakpointActionHandler editBreakpointActionHandler = X_EDIT;
        if (editBreakpointActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getEditBreakpointAction"));
        }
        return editBreakpointActionHandler;
    }

    @Override
    @NotNull
    public DebuggerSettingsPanelProvider getSettingsPanelProvider() {
        JavaDebuggerSettingsPanelProvider javaDebuggerSettingsPanelProvider = this.myDebuggerSettingsPanelProvider;
        if (javaDebuggerSettingsPanelProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getSettingsPanelProvider"));
        }
        return javaDebuggerSettingsPanelProvider;
    }

    public static Project getCurrentProject() {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        if (project != null) {
            return project;
        }
        return ProjectManager.getInstance().getDefaultProject();
    }

    public static class JavaDebuggerSettingsPanelProvider
    extends DebuggerSettingsPanelProvider {
        @Override
        public int getPriority() {
            return 1;
        }

        @Override
        public Configurable getRootConfigurable() {
            return new DebuggerLaunchingConfigurable();
        }

        @Override
        public Collection<? extends Configurable> getConfigurables() {
            ArrayList<Object> configurables = new ArrayList<Object>();
            configurables.add(new DebuggerDataViewsConfigurable(null));
            configurables.add(new DebuggerSteppingConfigurable());
            configurables.add(new UserRenderersConfigurable(null));
            configurables.add(new DebuggerHotswapConfigurable());
            return configurables;
        }

        @Override
        public void apply() {
            NodeRendererSettings.getInstance().fireRenderersChanged();
        }
    }

    private static class JavaBreakpointPanelProvider
    extends BreakpointPanelProvider<Breakpoint> {
        private JavaBreakpointPanelProvider() {
        }

        @Override
        public AnAction[] getAddBreakpointActions(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/JavaDebuggerSupport$JavaBreakpointPanelProvider", "getAddBreakpointActions"));
            }
            return AnAction.EMPTY_ARRAY;
        }

        @Override
        public void createBreakpointsGroupingRules(Collection<XBreakpointGroupingRule> rules) {
            rules.add(new XBreakpointGroupingByPackageRule());
            rules.add(new XBreakpointGroupingByClassRule());
        }

        @Override
        public void addListener(BreakpointPanelProvider.BreakpointsListener listener, Project project, Disposable disposable) {
        }

        @Override
        protected void removeListener(BreakpointPanelProvider.BreakpointsListener listener) {
        }

        @Override
        public int getPriority() {
            return 100;
        }

        @Override
        public Breakpoint findBreakpoint(@NotNull Project project, @NotNull Document document, int offset) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/ui/JavaDebuggerSupport$JavaBreakpointPanelProvider", "findBreakpoint"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/ui/JavaDebuggerSupport$JavaBreakpointPanelProvider", "findBreakpoint"));
            }
            return null;
        }

        @Override
        public GutterIconRenderer getBreakpointGutterIconRenderer(Object breakpoint) {
            return null;
        }

        @Override
        public void onDialogClosed(Project project) {
        }

        @Override
        public void provideBreakpointItems(Project project, Collection<BreakpointItem> items) {
        }
    }
}

