/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.impl.descriptors.data.SimpleDisplayKey;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ThreadGroupData
extends DescriptorData<ThreadGroupDescriptorImpl> {
    private final ThreadGroupReferenceProxyImpl myThreadGroup;

    public ThreadGroupData(ThreadGroupReferenceProxyImpl threadGroup) {
        this.myThreadGroup = threadGroup;
    }

    @Override
    protected ThreadGroupDescriptorImpl createDescriptorImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/impl/descriptors/data/ThreadGroupData", "createDescriptorImpl"));
        }
        return new ThreadGroupDescriptorImpl(this.myThreadGroup);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ThreadGroupData)) {
            return false;
        }
        return this.myThreadGroup.equals(((ThreadGroupData)object).myThreadGroup);
    }

    @Override
    public int hashCode() {
        return this.myThreadGroup.hashCode();
    }

    @Override
    public DisplayKey<ThreadGroupDescriptorImpl> getDisplayKey() {
        return new SimpleDisplayKey<ThreadGroupDescriptorImpl>(this.myThreadGroup);
    }
}

