/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.impl.descriptors.data.SimpleDisplayKey;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgValueData
extends DescriptorData<ArgumentValueDescriptorImpl> {
    private final int myIndex;
    private final Value myValue;
    @Nullable
    private final String myDisplayName;

    public ArgValueData(int index, Value value, @Nullable String displayName) {
        this.myIndex = index;
        this.myValue = value;
        this.myDisplayName = displayName;
    }

    @Override
    protected ArgumentValueDescriptorImpl createDescriptorImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/impl/descriptors/data/ArgValueData", "createDescriptorImpl"));
        }
        return new ArgumentValueDescriptorImpl(project, this.myIndex, this.myValue, this.myDisplayName);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ArgValueData)) {
            return false;
        }
        return this.myIndex == ((ArgValueData)object).myIndex;
    }

    @Override
    public int hashCode() {
        return this.myIndex;
    }

    @Override
    public DisplayKey<ArgumentValueDescriptorImpl> getDisplayKey() {
        return new SimpleDisplayKey<ArgumentValueDescriptorImpl>(this.myIndex);
    }
}

