/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.GenericDebuggerParametersRunnerConfigurable;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PatchedRunnableState;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithRunnerSettings;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaPatchableProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDebuggerRunner
extends JavaPatchableProgramRunner<GenericDebuggerRunnerSettings> {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/impl/GenericDebuggerRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/impl/GenericDebuggerRunner", "canRun"));
        }
        return executorId.equals(DefaultDebugExecutor.EXECUTOR_ID) && profile instanceof ModuleRunProfile && !(profile instanceof RunConfigurationWithSuppressedDefaultDebugAction);
    }

    @NotNull
    public String getRunnerId() {
        if ("Debug" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/GenericDebuggerRunner", "getRunnerId"));
        }
        return "Debug";
    }

    protected RunContentDescriptor doExecute(@NotNull Project project, @NotNull RunProfileState state, RunContentDescriptor contentToReuse, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/impl/GenericDebuggerRunner", "doExecute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/debugger/impl/GenericDebuggerRunner", "doExecute"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/debugger/impl/GenericDebuggerRunner", "doExecute"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.createContentDescriptor(project, state, contentToReuse, env);
    }

    @Nullable
    protected RunContentDescriptor createContentDescriptor(Project project, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment env) throws ExecutionException {
        if (state instanceof JavaCommandLine) {
            JavaParameters parameters = ((JavaCommandLine)state).getJavaParameters();
            GenericDebuggerRunner.runCustomPatchers((JavaParameters)parameters, (Executor)env.getExecutor(), (RunProfile)env.getRunProfile());
            RemoteConnection connection = DebuggerManagerImpl.createDebugParameters(parameters, true, DebuggerSettings.getInstance().DEBUGGER_TRANSPORT, "", false);
            return this.attachVirtualMachine(project, state, contentToReuse, env, connection, true);
        }
        if (state instanceof PatchedRunnableState) {
            RemoteConnection connection = GenericDebuggerRunner.doPatch(new JavaParameters(), env.getRunnerSettings());
            return this.attachVirtualMachine(project, state, contentToReuse, env, connection, true);
        }
        if (state instanceof RemoteState) {
            RemoteConnection connection = GenericDebuggerRunner.createRemoteDebugConnection((RemoteState)state, env.getRunnerSettings());
            return this.attachVirtualMachine(project, state, contentToReuse, env, connection, false);
        }
        return null;
    }

    @Nullable
    protected RunContentDescriptor attachVirtualMachine(Project project, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment env, RemoteConnection connection, boolean pollConnection) throws ExecutionException {
        DebuggerPanelsManager manager = DebuggerPanelsManager.getInstance(project);
        return manager.attachVirtualMachine(env.getExecutor(), (ProgramRunner)this, env, state, contentToReuse, connection, pollConnection);
    }

    private static RemoteConnection createRemoteDebugConnection(RemoteState connection, RunnerSettings settings) {
        RemoteConnection remoteConnection = connection.getRemoteConnection();
        GenericDebuggerRunnerSettings debuggerRunnerSettings = (GenericDebuggerRunnerSettings)settings;
        if (debuggerRunnerSettings != null) {
            remoteConnection.setUseSockets(debuggerRunnerSettings.getTransport() == 0);
            remoteConnection.setAddress(debuggerRunnerSettings.DEBUG_PORT);
        }
        return remoteConnection;
    }

    public GenericDebuggerRunnerSettings createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return new GenericDebuggerRunnerSettings();
    }

    public void patch(JavaParameters javaParameters, RunnerSettings settings, RunProfile runProfile, boolean beforeExecution) throws ExecutionException {
        GenericDebuggerRunner.doPatch(javaParameters, settings);
        GenericDebuggerRunner.runCustomPatchers((JavaParameters)javaParameters, (Executor)((Executor)Executor.EXECUTOR_EXTENSION_NAME.findExtension(DefaultDebugExecutor.class)), (RunProfile)runProfile);
    }

    private static RemoteConnection doPatch(JavaParameters javaParameters, RunnerSettings settings) throws ExecutionException {
        GenericDebuggerRunnerSettings debuggerSettings = (GenericDebuggerRunnerSettings)settings;
        if (StringUtil.isEmpty((String)debuggerSettings.getDebugPort())) {
            debuggerSettings.setDebugPort(DebuggerUtils.getInstance().findAvailableDebugAddress(debuggerSettings.getTransport() == 0));
        }
        return DebuggerManagerImpl.createDebugParameters(javaParameters, debuggerSettings, false);
    }

    public SettingsEditor<GenericDebuggerRunnerSettings> getSettingsEditor(Executor executor, RunConfiguration configuration) {
        if (configuration instanceof RunConfigurationWithRunnerSettings && ((RunConfigurationWithRunnerSettings)configuration).isSettingsNeeded()) {
            return new GenericDebuggerParametersRunnerConfigurable(configuration.getProject());
        }
        return null;
    }
}

