/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;

public class DebuggerContextUtil {
    public static void setStackFrame(DebuggerStateManager manager, StackFrameProxyImpl stackFrame) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerContextImpl context = manager.getContext();
        if (context == null) {
            return;
        }
        DebuggerSession session = context.getDebuggerSession();
        DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(session, context.getSuspendContext(), stackFrame.threadProxy(), stackFrame);
        manager.setState(newContext, session != null ? session.getState() : 6, 7, null);
    }

    public static void setThread(DebuggerStateManager contextManager, ThreadDescriptorImpl item) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerContextImpl context = contextManager.getContext();
        if (context == null) {
            return;
        }
        DebuggerSession session = context.getDebuggerSession();
        DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(session, item.getSuspendContext(), item.getThreadReference(), null);
        contextManager.setState(newContext, session != null ? session.getState() : 6, 8, null);
    }

    public static DebuggerContextImpl createDebuggerContext(@NotNull DebuggerSession session, SuspendContextImpl suspendContext) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/impl/DebuggerContextUtil", "createDebuggerContext"));
        }
        return DebuggerContextImpl.createDebuggerContext(session, suspendContext, suspendContext != null ? suspendContext.getThread() : null, null);
    }
}

