/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import org.jetbrains.annotations.NotNull;

public class RunToCursorActionHandler
extends DebuggerActionHandler {
    private final boolean myIgnoreBreakpoints;

    public RunToCursorActionHandler() {
        this(false);
    }

    protected RunToCursorActionHandler(boolean ignoreBreakpoints) {
        this.myIgnoreBreakpoints = ignoreBreakpoints;
    }

    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/actions/RunToCursorActionHandler", "isEnabled"));
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            return false;
        }
        if (DebuggerUtils.isDebugActionAware((PsiFile)file)) {
            DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(project).getContext().getDebuggerSession();
            return debuggerSession != null && debuggerSession.isPaused();
        }
        return false;
    }

    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/actions/RunToCursorActionHandler", "perform"));
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project).getContext();
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        DebuggerSession session = context.getDebuggerSession();
        if (session != null) {
            session.runToCursor(editor.getDocument(), editor.getCaretModel().getLogicalPosition().line, this.myIgnoreBreakpoints);
        }
    }
}

