/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.VMDisconnectedException;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class PopFrameAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        StackFrameProxyImpl stackFrame = PopFrameAction.getStackFrameProxy(e);
        if (stackFrame == null) {
            return;
        }
        try {
            DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
            DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
            if (debugProcess == null) {
                return;
            }
            debugProcess.getManagerThread().schedule(debugProcess.createPopFrameCommand(debuggerContext, stackFrame));
        }
        catch (NativeMethodException e2) {
            Messages.showMessageDialog((Project)project, (String)DebuggerBundle.message((String)"error.native.method.exception", (Object[])new Object[0]), (String)ActionsBundle.actionText((String)"Debugger.PopFrame"), (Icon)Messages.getErrorIcon());
        }
        catch (InvalidStackFrameException ignored) {
        }
        catch (VMDisconnectedException vde) {
            // empty catch block
        }
    }

    @Nullable
    private static StackFrameProxyImpl getStackFrameProxy(AnActionEvent e) {
        DebuggerContextImpl debuggerContext;
        StackFrameProxyImpl frameProxy;
        DebuggerTreeNodeImpl selectedNode = PopFrameAction.getSelectedNode(e.getDataContext());
        if (selectedNode != null) {
            NodeDescriptorImpl descriptor = selectedNode.getDescriptor();
            if (descriptor instanceof StackFrameDescriptorImpl) {
                if (selectedNode.getNextSibling() != null) {
                    StackFrameDescriptorImpl frameDescriptor = (StackFrameDescriptorImpl)descriptor;
                    return frameDescriptor.getFrameProxy();
                }
                return null;
            }
            if (descriptor instanceof ThreadDescriptorImpl || descriptor instanceof ThreadGroupDescriptorImpl) {
                return null;
            }
        }
        if ((frameProxy = (debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext())).getFrameProxy()) == null || frameProxy.isBottom()) {
            return null;
        }
        return frameProxy;
    }

    private static boolean isAtBreakpoint(AnActionEvent e) {
        DebuggerTreeNodeImpl parent;
        DebuggerTreeNodeImpl selectedNode = PopFrameAction.getSelectedNode(e.getDataContext());
        if (selectedNode != null && selectedNode.getDescriptor() instanceof StackFrameDescriptorImpl && (parent = selectedNode.getParent()) != null) {
            return ((ThreadDescriptorImpl)parent.getDescriptor()).isAtBreakpoint();
        }
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        SuspendContextImpl suspendContext = debuggerContext.getSuspendContext();
        return suspendContext != null && debuggerContext.getThreadProxy() == suspendContext.getThread();
    }

    public void update(AnActionEvent e) {
        boolean enable = false;
        StackFrameProxyImpl stackFrameProxy = PopFrameAction.getStackFrameProxy(e);
        if (stackFrameProxy != null && PopFrameAction.isAtBreakpoint(e)) {
            VirtualMachineProxyImpl virtualMachineProxy = stackFrameProxy.getVirtualMachine();
            enable = virtualMachineProxy.canPopFrames();
        }
        if ("MainMenu".equals(e.getPlace()) || "DebuggerToolbar".equals(e.getPlace())) {
            e.getPresentation().setEnabled(enable);
        } else {
            e.getPresentation().setVisible(enable);
        }
    }
}

