/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmSmartStepIntoActionHandler
extends DebuggerActionHandler {
    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/actions/JvmSmartStepIntoActionHandler", "perform"));
        }
        DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(project).getContext();
        DebuggerSession session = debuggerContext.getDebuggerSession();
        if (session != null) {
            JvmSmartStepIntoActionHandler.doStep(project, debuggerContext.getSourcePosition(), session);
        }
    }

    private static void doStep(@NotNull Project project, @Nullable SourcePosition position, @NotNull DebuggerSession session) {
        FileEditor fileEditor;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/actions/JvmSmartStepIntoActionHandler", "doStep"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/debugger/actions/JvmSmartStepIntoActionHandler", "doStep"));
        }
        VirtualFile file = position != null ? position.getFile().getVirtualFile() : null;
        FileEditor fileEditor2 = fileEditor = file != null ? FileEditorManager.getInstance((Project)project).getSelectedEditor(file) : null;
        if (fileEditor instanceof TextEditor) {
            for (JvmSmartStepIntoHandler handler : (JvmSmartStepIntoHandler[])Extensions.getExtensions(JvmSmartStepIntoHandler.EP_NAME)) {
                if (!handler.isAvailable(position) || !handler.doSmartStep(position, session, (TextEditor)fileEditor)) continue;
                return;
            }
        }
        session.stepInto(true, null);
    }

    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/debugger/actions/JvmSmartStepIntoActionHandler", "isEnabled"));
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project).getContext();
        DebuggerSession debuggerSession = context.getDebuggerSession();
        boolean isPaused = debuggerSession != null && debuggerSession.isPaused();
        SuspendContextImpl suspendContext = context.getSuspendContext();
        boolean hasCurrentThread = suspendContext != null && suspendContext.getThread() != null;
        return isPaused && hasCurrentThread;
    }
}

