/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.List;

public class JumpToObjectAction
extends DebuggerAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.actions.JumpToObjectAction");

    public void actionPerformed(AnActionEvent e) {
        DebuggerTreeNodeImpl selectedNode = JumpToObjectAction.getSelectedNode(e.getDataContext());
        if (selectedNode == null) {
            return;
        }
        NodeDescriptorImpl descriptor = selectedNode.getDescriptor();
        if (!(descriptor instanceof ValueDescriptor)) {
            return;
        }
        DebuggerContextImpl debuggerContext = JumpToObjectAction.getDebuggerContext(e.getDataContext());
        DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        debugProcess.getManagerThread().schedule(new NavigateCommand(debuggerContext, (ValueDescriptor)((Object)descriptor), debugProcess, e));
    }

    public void update(AnActionEvent e) {
        if (!JumpToObjectAction.isFirstStart(e)) {
            return;
        }
        DebuggerContextImpl debuggerContext = JumpToObjectAction.getDebuggerContext(e.getDataContext());
        DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            e.getPresentation().setVisible(false);
            return;
        }
        DebuggerTreeNodeImpl selectedNode = JumpToObjectAction.getSelectedNode(e.getDataContext());
        if (selectedNode == null) {
            e.getPresentation().setVisible(false);
            return;
        }
        NodeDescriptorImpl descriptor = selectedNode.getDescriptor();
        if (descriptor instanceof ValueDescriptor) {
            debugProcess.getManagerThread().schedule(new EnableCommand(debuggerContext, (ValueDescriptor)((Object)descriptor), debugProcess, e));
        } else {
            e.getPresentation().setVisible(false);
        }
    }

    private static SourcePosition calcPosition(ValueDescriptor descriptor, final DebugProcessImpl debugProcess) throws ClassNotLoadedException {
        Value value = descriptor.getValue();
        if (value == null) {
            return null;
        }
        Type type = value.type();
        if (type == null) {
            return null;
        }
        try {
            ClassType clsType;
            List<Location> locations;
            if (type instanceof ArrayType) {
                type = ((ArrayType)type).componentType();
            }
            if (type instanceof ClassType && (locations = (clsType = (ClassType)type).allLineLocations()).size() > 0) {
                final Location location = locations.get(0);
                return (SourcePosition)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SourcePosition>(){

                    public SourcePosition compute() {
                        SourcePosition position = debugProcess.getPositionManager().getSourcePosition(location);
                        if (clsType.name().indexOf(36) < 0) {
                            SourcePosition classPosition;
                            PsiClass classAt;
                            PsiClass psiClass = classAt = position != null ? JVMNameUtil.getClassAt(position) : null;
                            if (classAt != null && (classPosition = SourcePosition.createFromElement((PsiElement)classAt)) != null) {
                                position = classPosition;
                            }
                        }
                        return position;
                    }
                });
            }
        }
        catch (ClassNotPreparedException e) {
            LOG.debug((Throwable)e);
        }
        catch (AbsentInformationException e) {
            LOG.debug((Throwable)e);
        }
        return null;
    }

    public static abstract class SourcePositionCommand
    extends SuspendContextCommandImpl {
        protected final DebuggerContextImpl myDebuggerContext;
        protected final ValueDescriptor myDescriptor;
        protected final DebugProcessImpl myDebugProcess;
        protected final AnActionEvent myActionEvent;

        public SourcePositionCommand(DebuggerContextImpl debuggerContext, ValueDescriptor descriptor, DebugProcessImpl debugProcess, AnActionEvent actionEvent) {
            super(debuggerContext.getSuspendContext());
            this.myDebuggerContext = debuggerContext;
            this.myDescriptor = descriptor;
            this.myDebugProcess = debugProcess;
            this.myActionEvent = actionEvent;
        }

        @Override
        public final void contextAction() throws Exception {
            block2: {
                try {
                    this.doAction(JumpToObjectAction.calcPosition(this.myDescriptor, this.myDebugProcess));
                }
                catch (ClassNotLoadedException ex) {
                    String className = ex.className();
                    if (this.loadClass(className) == null) break block2;
                    this.myDebugProcess.getManagerThread().schedule(this.createRetryCommand());
                }
            }
        }

        protected abstract SourcePositionCommand createRetryCommand();

        protected abstract void doAction(SourcePosition var1);

        private ReferenceType loadClass(String className) {
            EvaluationContextImpl eContext = this.myDebuggerContext.createEvaluationContext();
            try {
                return this.myDebugProcess.loadClass(eContext, className, eContext.getClassLoader());
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    private static class EnableCommand
    extends SourcePositionCommand {
        public EnableCommand(DebuggerContextImpl debuggerContext, ValueDescriptor descriptor, DebugProcessImpl debugProcess, AnActionEvent e) {
            super(debuggerContext, descriptor, debugProcess, e);
        }

        @Override
        protected EnableCommand createRetryCommand() {
            return new EnableCommand(this.myDebuggerContext, this.myDescriptor, this.myDebugProcess, this.myActionEvent);
        }

        @Override
        protected void doAction(SourcePosition sourcePosition) {
            DebuggerAction.enableAction(this.myActionEvent, sourcePosition != null);
        }
    }

    private static class NavigateCommand
    extends SourcePositionCommand {
        public NavigateCommand(DebuggerContextImpl debuggerContext, ValueDescriptor descriptor, DebugProcessImpl debugProcess, AnActionEvent e) {
            super(debuggerContext, descriptor, debugProcess, e);
        }

        @Override
        protected NavigateCommand createRetryCommand() {
            return new NavigateCommand(this.myDebuggerContext, this.myDescriptor, this.myDebugProcess, this.myActionEvent);
        }

        @Override
        protected void doAction(SourcePosition sourcePosition) {
            if (sourcePosition != null) {
                sourcePosition.navigate(true);
            }
        }
    }
}

