/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.settings.DebuggerDataViewsConfigurable;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.UserRenderersConfigurable;
import com.intellij.debugger.ui.impl.FrameVariablesTree;
import com.intellij.debugger.ui.impl.WatchDebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;

public class CustomizeContextViewAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        Disposable disposable = Disposer.newDisposable();
        TabbedConfigurable configurable = new TabbedConfigurable(disposable){

            @Override
            protected List<Configurable> createConfigurables() {
                ArrayList<Configurable> array = new ArrayList<Configurable>();
                array.add((Configurable)new DebuggerDataViewsConfigurable(project));
                array.add((Configurable)new UserRenderersConfigurable(project));
                return array;
            }

            @Override
            public void apply() throws ConfigurationException {
                super.apply();
                NodeRendererSettings.getInstance().fireRenderersChanged();
            }

            public String getDisplayName() {
                return DebuggerBundle.message((String)"title.customize.data.views", (Object[])new Object[0]);
            }

            public String getHelpTopic() {
                return null;
            }

            @Override
            protected void createConfigurableTabs() {
                for (Configurable configurable : this.getConfigurables()) {
                    JComponent component = configurable.createComponent();
                    component.setBorder(new EmptyBorder(8, 8, 8, 8));
                    this.myTabbedPane.addTab(configurable.getDisplayName(), component);
                }
            }
        };
        SingleConfigurableEditor editor = new SingleConfigurableEditor(project, (Configurable)configurable);
        Disposer.register((Disposable)editor.getDisposable(), (Disposable)disposable);
        editor.show();
    }

    public void update(AnActionEvent e) {
        DebuggerTree tree = CustomizeContextViewAction.getTree(e.getDataContext());
        e.getPresentation().setVisible(tree instanceof FrameVariablesTree || tree instanceof WatchDebuggerTree);
        e.getPresentation().setText(ActionsBundle.actionText((String)"Debugger.CustomizeContextView"));
    }
}

