/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;

public class AutoRendererAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        DebuggerTreeNodeImpl[] selectedNodes;
        DebugProcessImpl debugProcess;
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        if (debuggerContext != null && (debugProcess = debuggerContext.getDebugProcess()) != null && (selectedNodes = DebuggerAction.getSelectedNodes(e.getDataContext())) != null) {
            debugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public void threadAction() {
                    for (DebuggerTreeNodeImpl selectedNode : selectedNodes) {
                        NodeDescriptorImpl descriptor = selectedNode.getDescriptor();
                        if (!(descriptor instanceof ValueDescriptorImpl)) continue;
                        ((ValueDescriptorImpl)descriptor).setRenderer(null);
                        selectedNode.calcRepresentation();
                    }
                }
            });
        }
    }
}

