/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;

public class DefaultDebugEnvironment
implements DebugEnvironment {
    private final GlobalSearchScope mySearchScope;
    private final Executor myExecutor;
    private final ProgramRunner myRunner;
    private RunProfileState myState;
    private final RemoteConnection myRemoteConnection;
    private final boolean myPollConnection;
    private final RunProfile myRunProfile;

    public DefaultDebugEnvironment(Project project, Executor executor, ProgramRunner runner, RunProfile runProfile, RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) {
        this.myExecutor = executor;
        this.myRunner = runner;
        this.myRunProfile = runProfile;
        this.myState = state;
        this.myRemoteConnection = remoteConnection;
        this.myPollConnection = pollConnection;
        this.mySearchScope = RunContentBuilder.createSearchScope(project, runProfile);
    }

    @Override
    public ExecutionResult createExecutionResult() throws ExecutionException {
        TextConsoleBuilder consoleBuilder;
        if (this.myState instanceof CommandLineState && (consoleBuilder = ((CommandLineState)this.myState).getConsoleBuilder()) != null) {
            consoleBuilder.filters(ExceptionFilters.getFilters((GlobalSearchScope)this.mySearchScope));
        }
        return this.myState.execute(this.myExecutor, this.myRunner);
    }

    @Override
    public GlobalSearchScope getSearchScope() {
        return this.mySearchScope;
    }

    @Override
    public boolean isRemote() {
        return this.myState instanceof RemoteState;
    }

    @Override
    public RemoteConnection getRemoteConnection() {
        return this.myRemoteConnection;
    }

    @Override
    public boolean isPollConnection() {
        return this.myPollConnection;
    }

    @Override
    public String getSessionName() {
        return this.myRunProfile.getName();
    }
}

